FILE: 'Alan Kay.md'
---
exported: 2026-02-07T16:12:11.419Z
source: NotebookLM
type: chat
title: Alan Kay on 💬Keywords and Jargon
tags:
  - Alan-Kay
  - Keywords
author: Alan Kay
---
### Key Concepts, Principles, and Theories

**Keywords**

• **Object-Oriented Programming (OOP)**\[1\],\[2\],\[3\],\[4\],\[5\],\[6\]

• **Late Binding**\[7\],\[8\],\[9\],\[10\]

• **The Dynabook**\[11\],\[12\],\[13\],\[14\],\[15\]

• **Biological Metaphor**\[16\],\[2\],\[17\],\[18\],\[19\],\[20\]

• **Messaging**\[21\],\[22\],\[23\],\[24\],\[25\]

• **Context / Point of View**\[26\],\[27\],\[28\],\[29\],\[30\]

• **Bruner’s Multiple Mentalities**\[31\],\[32\],\[33\]

• **Complexity vs. Complication**\[34\],\[35\],\[36\]

• **WIAN (What Is Actually Needed)**\[37\],\[38\],\[39\],\[40\]

• **Recursive Design**\[22\],\[41\],\[42\]

• **Meta / Reflection**\[43\],\[11\],\[44\],\[45\],\[46\]

\--------------------------------------------------------------------------------

### Glossary of Concepts

**Biological Design (The Biological Metaphor)**A systems design philosophy that rejects the "clockwork" or mechanical view of computing in favor of an organic approach. This involves viewing software components like biological cells: autonomous, encapsulated entities that can function independently, repair themselves, and scale massively without crashing the whole organism\[16\],\[2\],\[19\]. This approach relies on "variation, speciation, and epigenesis" rather than rigid engineering\[18\].

**Complexity vs. Complication**A distinction used to evaluate system difficulty. **Complexity** is defined as the intrinsic difficulty of the problem or the organization of ingredients required to solve a goal. **Complication** is the extrinsic "noise" or mess introduced by poor human design or "accumulated mess"\[34\]. A good architecture manages complexity while eliminating complication\[35\].

**Context (Point of View)**The principle that "Point of view is worth 80 IQ points"\[26\],\[47\]. This theory posits that "knowledge" is less valuable than the "context" or perspective in which that knowledge is viewed. Changing the context (e.g., from Roman numerals to Arabic numerals, or from procedural to object-oriented thinking) turns difficult problems into simple ones\[48\],\[28\].

**Doing with Images makes Symbols**A user interface and learning theory derived from Jerome Bruner's three stages of learning: **Enactive** (doing/muscle memory), **Iconic** (visual/images), and **Symbolic** (language/math)\[31\],\[49\]. Kay applied this to interface design (GUI), where the user interacts enacting with a mouse ("doing"), manipulating icons/windows ("images"), to eventually understand the underlying scripting or programming ("symbols")\[32\].

**The Dynabook**A visionary concept for a "personal dynamic medium" the size of a notebook, capable of handling all information needs\[50\]. Unlike a laptop, which is a tool, the Dynabook was conceived as a "metamedium" designed specifically for children to learn and create, functioning as an "intellectual amplifier"\[51\],\[13\]. It is a qualitative shift in how humans relate to knowledge, similar to the printing press\[52\].

**Late Binding**The principle of delaying the commitment to specific implementations, data types, or strategies until the last possible moment (runtime)\[8\]. This is essential for creating "growing" systems that can evolve without being stopped and rebuilt. It allows for extreme flexibility, such as changing the definition of an object while the system is running\[53\],\[10\].

**Messaging**The core mechanism of Kay’s Object-Oriented Programming. Instead of direct data manipulation (which leads to dependencies), objects communicate by sending "requests" (messages)\[22\],\[4\]. The receiver decides _how_ to handle the request, maintaining the protection of its internal state\[21\]. This allows for "negotiation" between parts of a system rather than command-and-control\[41\].

**Meta / Reflection**The capability of a system to describe, examine, and modify itself. Influenced by Lisp, a "meta" language uses a small kernel of code to define the rest of the language\[54\],\[55\]. **Reflection** allows a running program to look at its own execution state and structure\[43\], enabling powerful debugging and extensibility\[46\].

**Object-Oriented Programming (Kay's Definition)**Distinct from C++ or Java, Kay's OOP is defined by:

1\. Everything is an object\[5\].

2\. Objects communicate only by message passing\[21\].

3\. Objects have their own memory (state) protected from the outside\[41\].

4\. Recursive design: Objects are "virtual computers" that can be composed of other virtual computers\[3\],\[56\].

**Recursive Design**The architectural principle that the parts of a system should have the same power and characteristics as the whole\[41\]. Just as a computer on the Internet is a whole computer, an object in a software system should be a "whole virtual computer"\[22\]. This allows for infinite scalability and fault tolerance\[17\].

**WIAN (What Is Actually Needed)**A heuristic for "problem finding" rather than just "problem solving"\[37\]. It warns against "incrementalism" or making a bad design "better" (inverse vandalism)\[57\]. Instead, one should identify the fundamental human or system need, often requiring a qualitative shift in approach rather than a quantitative optimization\[39\],\[40\].

---
> [!info]- References
> [1] Alan Kay - Quora 2023-11.pdf
> [2] Alan Kay - Quora 2023-11.pdf
> [3] Alan Kay - Quora 2023-11.pdf
> [4] Alan Kay - Quora 2023-11.pdf
> [5] Alan Kay - Quora 2023-11.pdf
> [6] Alan Kay - Quora 2023-11.pdf
> [7] Alan Kay - Quora 2023-11.pdf
> [8] Alan Kay - Quora 2023-11.pdf
> [9] Alan Kay - Quora 2023-11.pdf
> [10] Kay - Moving to Tomorrows Computing Infrastructure.pdf
> [11] Alan Kay - Quora 2023-11.pdf
> [12] Alan Kay - Quora 2023-11.pdf
> [13] Alan Kay - Quora 2023-11.pdf
> [14] AlanKay.pdf
> [15] Kay - Personal dynamic media.pdf
> [16] Alan Kay - Quora 2023-11.pdf
> [17] Alan Kay - Quora 2023-11.pdf
> [18] Alan Kay - Quora 2023-11.pdf
> [19] Alan Kay - Quora 2023-11.pdf
> [20] OOP in a Nutshell From Clockwork to Biology.pdf
> [21] Alan Kay - Quora 2023-11.pdf
> [22] Alan Kay - Quora 2023-11.pdf
> [23] Alan Kay - Quora 2023-11.pdf
> [24] Alan Kay - Quora 2023-11.pdf
> [25] Alan Kay - Quora 2023-11.pdf
> [26] Alan Kay - Quora 2023-11.pdf
> [27] Alan Kay - Quora 2023-11.pdf
> [28] Alan Kay - Quora 2023-11.pdf
> [29] Alan Kay - Quora 2023-11.pdf
> [30] Kay - Programming and programming language.pdf
> [31] Alan Kay - Quora 2023-11.pdf
> [32] AlanKay.pdf
> [33] [Book] AlanKay - 70th Points of View.pdf
> [34] Alan Kay - Quora 2023-11.pdf
> [35] Alan Kay - Quora 2023-11.pdf
> [36] Alan Kay - Quora 2023-11.pdf
> [37] Alan Kay - Quora 2023-11.pdf
> [38] Alan Kay - Quora 2023-11.pdf
> [39] Alan Kay - Quora 2023-11.pdf
> [40] Alan Kay - Quora 2023-11.pdf
> [41] Alan Kay - Quora 2023-11.pdf
> [42] [Book] AlanKay - 70th Points of View.pdf
> [43] Alan Kay - Quora 2023-11.pdf
> [44] Alan Kay - Quora 2023-11.pdf
> [45] Alan Kay - Quora 2023-11.pdf
> [46] Alan Kay - Quora 2023-11.pdf
> [47] Alan Kay - Quora 2023-11.pdf
> [48] Alan Kay - Quora 2023-11.pdf
> [49] Alan Kay - Quora 2023-11.pdf
> [50] Kay - Personal dynamic media.pdf
> [51] Alan Kay - Quora 2023-11.pdf
> [52] Kay - Personal dynamic media.pdf
> [53] Alan Kay - Quora 2023-11.pdf
> [54] A Conversation with Alan Kay.pdf
> [55] Alan Kay - Quora 2023-11.pdf
> [56] Alan Kay - Quora 2023-11.pdf
> [57] Alan Kay - Quora 2023-11.pdf


FILE: 'Alicia Juarrero.md'
---
exported: '2026-02-01T00:10:42.834Z'
source: NotebookLM
type: chat
title: Alicia Juarrero on 💬Keywords and Jargon
tags:
  - Alicia-Juarrero
  - Keywords
author: Alicia Juarrero
---

Based on the provided sources, particularly Alicia Juarrero’s _Context Changes Everything_ and _Dynamics in Action_, I have extracted the key concepts, principles, and theories. These center on shifting the philosophical and scientific understanding of causality from linear, efficient causes to a model based on complex dynamical systems and constraints.

### **Keywords**

**Causality & Explanation**

• Efficient Causality vs. Structuring Causality

• Interlevel (Mereological) Causality

• Top-Down Causation

• Self-Cause (Circular Causality)

• Narrative (Hermeneutic) Explanation

**Thermodynamics & Systems Theory**

• Complex Adaptive Systems

• Dissipative Structures

• Far-from-Equilibrium Thermodynamics

• Phase Space / State Space

• Attractors (Semantic, Strange)

• Bifurcation (Phase Transition)

• Metastability

• Hysteresis (History-dependence)

**The Theory of Constraints**

• Constraints (as Causes)

• Context-Independent Constraints

• Context-Dependent Constraints (Context-Sensitive)

• Enabling Constraints

• Governing (Constitutive) Constraints

• Constraint Closure

**Action Theory & Mind**

• Intentional Action (Wink vs. Blink)

• Act-Types vs. Act-Tokens

• Prior vs. Proximate Intentions

• Multiple Realizability (Degeneracy)

• Information Flow (Noise & Equivocation)

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**I. The Nature of Constraints**

Juarrero redefines causality not as forceful impact, but as the operation of constraints that alter the probability of events.

• **Constraints:** Entities, processes, or conditions that reduce the number of ways a system can behave, thereby lowering the randomness (equiprobability) of a system\[1\],\[2\]. Constraints do not transfer energy directly (like a push); rather, they shape the "possibility space" of a system, making certain outcomes more likely than others\[3\],\[4\].

• **Context-Independent Constraints:** Constraints that take a system away from randomness (equiprobability) but do not create complex organization. Examples include temperature gradients or walls of a container. They restrict the range of possibilities (creating inhomogeneity) but do not correlate the components\[5\],\[6\].

• **Context-Dependent (Context-Sensitive) Constraints:** Constraints that take a system away from _independence_. These connect components so that the behavior of one becomes conditional on the behavior of others\[5\],\[7\]. They weave separate entities into coherent wholes (e.g., feedback loops, catalysts, language rules)\[8\],\[9\].

• **Enabling Constraints:** A type of context-dependent constraint that creates _new_ possibilities or degrees of freedom that did not exist for the isolated components. For example, rules of syntax constrain random sounds but _enable_ the creation of infinite meaning\[10\],\[11\]. They facilitate phase transitions to new levels of organization\[12\].

• **Governing (Constitutive) Constraints:** Top-down constraints that emerge once a system has self-organized. They regulate the components to maintain the system's coherence and identity (e.g., homeostasis regulating body temperature)\[13\],\[14\].

• **Constraint Closure:** A specific organization where a set of constraints folds back on itself, establishing mutual dependence. This closure allows a system to become self-determining and distinct from its environment\[15\],\[16\].

**II. Causality and Dynamics**

Juarrero challenges the Newtonian view that all causes must be "efficient" (forceful impacts between separate things).

• **Efficient Causality:** The classical Newtonian view of cause as an external force transferring energy to an inert object (billiard ball model). Juarrero argues this is insufficient to explain biological and mental organization\[1\],\[17\].

• **Interlevel (Mereological) Causality:** A reciprocal causal relationship between a whole and its parts. Parts interact to create a self-organizing whole (bottom-up), and the emergent whole regulates the parts (top-down)\[5\],\[18\].

• **Top-Down Causation:** The influence of a higher-level system (the whole) on its lower-level components. Juarrero conceptualizes this not as magic or force, but as the operation of _second-order contextual constraints_ that modify the probability distribution of the components' behavior\[19\],\[20\].

• **Self-Cause:** Historically rejected by Aristotle, but reclaimed by complexity theory to describe circular processes (like feedback loops) where the product of a process is necessary for the process itself\[1\],\[21\].

• **Dissipative Structures:** Open systems operating far from thermodynamic equilibrium (e.g., a tornado or a living cell). They maintain their structure by constantly exchanging energy and matter with their environment, generating order out of chaos\[5\],\[22\].

**III. Action Theory and Mind**

Applying systems theory to the philosophical problem of how mental intentions cause physical actions.

• **Intentional Action:** Defined dynamically as a trajectory of behavior constrained by a meaningful mental state (intention). The difference between a "wink" (action) and a "blink" (reflex) is that a wink is behavior organized and constrained by a self-organized neurological dynamic (the intention)\[1\],\[23\].

• **Attractor:** A region in a system's phase space toward which the system tends to evolve. Juarrero views mental states (intentions) as complex attractors that pull neurological and motor activity into a specific pattern\[24\],\[19\].

• **Semantic Attractor:** A neurological dynamic where the "basin of attraction" embodies meaning. For example, a neural network settling into the correct output pattern for a word despite noisy input\[24\],\[25\].

• **Phase Space (State Space):** A multi-dimensional map representing all possible states a system can occupy. Constraints work by carving "valleys" (attractors) into this landscape, making certain behaviors probable\[19\],\[26\].

• **Act-Type vs. Act-Token:** An _Act-Type_ is a generalized category of action (e.g., "greeting someone"). An _Act-Token_ is the specific, individual instance of that action (e.g., "waving my left hand now"). Juarrero argues that intentions constrain the _type_ (the general landscape), while the environment helps fill in the specific _token_ details\[27\],\[23\].

• **Multiple Realizability (Degeneracy):** The principle that the same higher-level function (or Act-Type) can be physically realized by many different lower-level mechanisms (Act-Tokens). For example, one can realize the intention of "greeting" by waving, speaking, or nodding\[28\],\[29\].

**IV. Explanation and Information**

How we describe and measure complex systems.

• **Narrative (Hermeneutic) Explanation:** Because complex systems are path-dependent and sensitive to initial conditions, they cannot be explained solely by universal laws (deduction). They require historical narratives that reconstruct the unique trajectory of the system\[30\],\[31\].

• **Equivocation and Noise:** Terms borrowed from information theory. In action theory, "noise" is extraneous movement not generated by the intention. "Equivocation" is information generated by the intention that fails to make it into the behavior (a failed action). Successful action requires a flow of information where equivocation is minimized\[32\],\[33\].

• **Hysteresis (History-Dependence):** The property of complex systems where the current state depends not just on current input, but on the history of the system. Systems "carry their history on their backs"\[34\],\[35\].

---
> [!info]- References
> [1] Juarrero - The Self-Organization of Intentional Action.pdf
> [2] [Book] Jarrero - Context Changes Everything.pdf
> [3] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [4] [Book] Jarrero - Context Changes Everything.pdf
> [5] Juarrero - The Self-Organization of Intentional Action.pdf
> [6] [Book] Jarrero - Context Changes Everything.pdf
> [7] [Book] Jarrero - Context Changes Everything.pdf
> [8] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [9] [Book] Jarrero - Context Changes Everything.pdf
> [10] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [11] [Book] Jarrero - Context Changes Everything.pdf
> [12] [Book] Jarrero - Context Changes Everything.pdf
> [13] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [14] [Book] Jarrero - Context Changes Everything.pdf
> [15] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [16] [Book] Jarrero - Context Changes Everything.pdf
> [17] [Book] Jarrero - Context Changes Everything.pdf
> [18] [Book] Jarrero - Context Changes Everything.pdf
> [19] Juarrero - The Self-Organization of Intentional Action.pdf
> [20] [Book] Jarrero - Context Changes Everything.pdf
> [21] Juarrero - intentions as complex dynamical attractors.pdf
> [22] [Book] Jarrero - Context Changes Everything.pdf
> [23] Juarrero - The Self-Organization of Intentional Action.pdf
> [24] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [25] [Book] Jarrero - Context Changes Everything.pdf
> [26] [Book] Jarrero - Context Changes Everything.pdf
> [27] Juarrero - The Self-Organization of Intentional Action.pdf
> [28] Juarrero - Context Changes Everything - How Constraints Create Coherence.pdf
> [29] [Book] Jarrero - Context Changes Everything.pdf
> [30] [Book] Juarerro - Dynamics in Action.pdf
> [31] [Book] Juarerro - Dynamics in Action.pdf
> [32] [Book] Juarerro - Dynamics in Action.pdf
> [33] [Book] Juarerro - Dynamics in Action.pdf
> [34] Juarrero - intentions as complex dynamical attractors.pdf
> [35] [Book] Juarerro - Dynamics in Action.pdf


FILE: 'Barry Richmond.md'
---
exported: '2026-01-31T20:12:38.406Z'
source: NotebookLM
type: chat
title: Barry Richmond on 💬Keywords and Jargon
tags:
  - Barry-Richmond
  - Keywords
author: Barry Richmond
---
### **Key Concepts, Principles, and Theories**

**Keywords:****Systems Thinking**, **System Dynamics**, **Feedback Loops** (Reinforcing & Balancing), **Stocks and Flows**, **Operational Thinking**, **Complexity**, **Emergence**, **Self-Organization**, **System Archetypes**, **Mental Models**, **Resilience**, **Non-linearity**, **Socio-ecological Systems**.

\--------------------------------------------------------------------------------

### **Attached Glossary**

**Accumulator (Stock)**Anything that builds up or dwindles over time, represented by a rectangular box icon (the "bathtub" metaphor)\[1\]\[2\]. Stocks represent the **state of the system** at any given point in time and are changed only by flows\[3\]\[4\].

**Balancing Process/Loop**A feedback loop that **seeks equilibrium** by trying to bring the system to a desired state and keep it there\[5\]\[6\]. It acts as a goal-seeking mechanism that resists change in a given direction\[6\]\[7\].

**Bifocal Perspective**A core systems thinking vantage point where the observer positions themselves to see **both the forest and the trees**, perceiving both generic patterns and specific events simultaneously\[8\]\[9\].

**Causal Loop Diagram (CLD)**A visual tool used to capture how variables in a system are interrelated through closed loops of **circular causality**\[10\]. CLDs help explicitize one's understanding of a system's structure\[13\]\[14\].

**Closed-loop Thinking**A thinking skill that views the world as a set of **ongoing, interdependent processes** rather than one-way, linear "laundry list" relationships\[15\]. It identifies the feedback loops responsible for generating behavior\[18\]\[19\].

**Complex Adaptive Systems (CAS)**A dynamic network of many agents (cells, individuals, nations) acting in parallel and constantly **reacting to one another**. In a CAS, both the agents and the system as a whole are adaptive and self-organizing\[20\].

**Complexity**A property of systems characterized by **non-linearity, emergence, and uncertainty**\[23\]. Complex systems (unlike "complicated" ones) produce properties that cannot be understood by analyzing parts in isolation\[24\]\[25\].

**Dynamic Thinking**The ability to see and deduce **behavior patterns over time** rather than focusing on isolated events\[26\]\[27\]. It frames problems in terms of trajectories and graphs rather than static points\[28\]\[29\].

**Emergence**A phenomenon in complex systems where the **whole exhibits properties** that its individual parts do not possess (e.g., table salt is salty, but its components—sodium and chlorine—are not)\[30\]\[31\].

**Feedback**The return of information about the status of a process that **influences the next occurrence** of that same process\[32\]\[33\]. Feedback can either amplify change (reinforcing) or counteract it (balancing)\[34\]\[35\].

**Flow (Rate)**The amount of change a stock undergoes during a particular unit of time\[33\]\[36\]. Flows are the **activities or actions** that fill or drain accumulations\[3\]\[4\].

**Generic Structures**Underlying systemic structures that can be generalized across diverse fields (e.g., biology, economics) because their **feedback relationships are identical**\[37\].

**Leverage Point**A place within a system where a **small shift in one area** can yield large, long-lasting improvements across the entire system\[40\].

**Mental Models**The selective abstractions of reality that individuals carry in their heads and use to **make meaning of experiences** and inform actions\[43\]. Learning is defined as the process of changing these mental models\[46\]\[47\].

**Non-linearity**A characteristic of systems where cause and effect are not proportional; small actions can cause large reactions (the "butterfly effect"), and behavior often involves **sudden shifts or thresholds**\[23\].

**Operational Thinking**The practice of getting "down to the physics" of a system by concentrating on the actual **stock-and-flow infrastructure** that generates behavior\[50\]. It avoids correlational thinking in favor of structural causality\[53\].

**Reinforcing Process/Loop**A feedback loop that **amplifies change**, leading to either exponential growth or accelerating collapse\[35\]\[56\]. It is a self-compounding engine of growth or decay\[57\]\[58\].

**Resilience**The capacity of a system to **absorb disturbance and reorganize** so as to retain essentially the same function, structure, and identity\[59\].

**Socio-ecological System (SES)**An integrated system of human society and ecosystems characterized by **reciprocal feedback and interdependence**\[59\]\[62\].

**System-as-Cause Thinking**Placing responsibility for a system's behavior on the **internal actors and structure** of that system rather than blaming external forces\[18\].

---
> [!info]- References
> [1] System Archetypes Stories that Repeat.pdf
> [2] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [3] Richmond - Systems Thinking four key questions.pdf
> [4] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [5] System Archetypes Stories that Repeat.pdf
> [6] Systems-Thinking-Tools-TRST01E.pdf
> [7] Systems-Thinking-Tools-TRST01E.pdf
> [8] Richmond 1994 systems thinking lets just get on with it.pdf
> [9] SDSTletsjustgetonwithit.pdf
> [10] System Archetypes Stories that Repeat.pdf
> [13] Systems Archetypes II.pdf
> [14] Systems-Thinking-Tools-TRST01E.pdf
> [15] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [18] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [19] Richmond 1993 Systems thinking critical thinking skills for the 1990s and beyond.pdf
> [20] KV 277.pdf
> [23] KV 277.pdf
> [24] KV 277.pdf
> [25] KV 277.pdf
> [26] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [27] Richmond 1993 Systems thinking critical thinking skills for the 1990s and beyond.pdf
> [28] System Archetypes Stories that Repeat.pdf
> [29] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [30] 200RefsSystems2c.pdf
> [31] KV 277.pdf
> [32] KV 277.pdf
> [33] Systems-Thinking-Tools-TRST01E.pdf
> [34] KV 277.pdf
> [35] System Archetypes Stories that Repeat.pdf
> [36] System Archetypes Stories that Repeat.pdf
> [37] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [40] 2005 Fisher - The prophet of unintended consequences.pdf
> [43] 2005 Fisher - The prophet of unintended consequences.pdf
> [46] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [47] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [50] Richmond 1994 systems thinking lets just get on with it.pdf
> [53] Richmond - Systems Thinking critical thinking skills for the 1990's and beyond.pdf
> [56] Systems-Thinking-Tools-TRST01E.pdf
> [57] Systems-Thinking-Tools-TRST01E.pdf
> [58] [Book] Richmond - An Introduction to Systems Thinking - Stella guide.pdf
> [59] KV 277.pdf
> [62] KV 277.pdf


FILE: 'Bob Williams.md'
---
exported: '2026-01-31T20:05:11.890Z'
source: NotebookLM
type: chat
title: Bob Williams on 💬Keywords and Jargon
tags:
  - Bob-Williams
  - Keywords
author: Bob Williams
---
### **Key Keywords**

**Core Concepts:**

• **Systems Thinking**\[1\]

• **Wicked Problems**\[4\]

• **Inter-relationships**\[7\]

• **Perspectives**\[10\]

• **Boundaries**\[3\]

• **Emergence**\[14\]

• **Self-Organization**\[15\]

• **Non-linearity**\[18\]

• **Feedback Loops**\[24\]

• **Stocks and Flows**\[26\]

**Principles & Methodologies:**

• **Boundary Critique**\[3\]

• **Learning Loops** (Single, Double, Triple)\[34\]

• **Soft Systems Methodology (SSM)**\[38\]

• **Critical Systems Heuristics (CSH)**\[42\]

• **Human Systems Dynamics (HSD)**\[46\]\[47\]

• **CDE Model** (Container, Difference, Exchange)\[48\]\[49\]

• **CATWOE / BATWOVE**\[50\]

• **Simple Rules**\[54\]\[55\]

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts, Principles, and Theories**

**Boundary Critique**A systematic process of **deliberating and justifying the choices made about what is included ("in") and what is excluded ("out")** of a specific inquiry or intervention\[31\]\[44\]. It recognizes that boundaries are not "given" but are **ethical and political choices** that determine who benefits and who is marginalized\[56\].

**CATWOE / BATWOVE**Mnemonics used in **Soft Systems Methodology** to define a "root definition" of a system\[50\]\[52\]. **CATWOE** stands for Customers, Actors, Transformation, Weltanschauung (worldview), Owner, and Environment\[53\]\[59\]. **BATWOVE** updates this by splitting Customers into **Beneficiaries** and **Victims** to ensure ethical consideration of those harmed by a system\[51\].

**CDE Model**A framework used in **Human Systems Dynamics** to influence the conditions of self-organization\[48\]\[49\].

• **Container:** The area or boundary that keeps agents together\[62\].

• **Difference:** The **tensions or diversities** within the container that drive change\[63\].

• **Exchange:** The **interactions or transfers** of resources/information between agents\[64\].

**Complex Adaptive Systems (CAS)**A theory viewing systems as **collections of semi-independent agents** (people, departments, etc.) that act in unpredictable ways\[65\]\[66\]. System-wide patterns **emerge from the interaction** of these agents rather than through top-down hierarchical control\[67\]\[68\].

**Double-Loop Learning**A level of learning that goes beyond simple error correction (Single-Loop) to **question and change the underlying norms, rules, and assumptions**\[35\]\[37\]. It asks, **"Are we doing the right things?"** rather than just "Are we doing things right?"\[35\].

**Emergence**A phenomenon where **new system-wide properties arise** from the interactions of the parts that cannot be found in the parts themselves\[14\]. Emergence is unpredictable and generally cannot be directly engineered or controlled from the outside\[70\]\[71\].

**Holon**A term used in Soft Systems Methodology to describe a **plausible, relevant, and purposeful perspective** used to study real-world activities\[72\]\[73\]. It is a conceptual construct used for evaluation rather than a literal description of reality\[39\]\[74\].

**Rich Picture**A soft systems technique involving a **free-hand drawing that captures the complexity and "messiness"** of a situation\[75\]\[76\]. It includes structures, processes, conflicts, people, and "climates" to help stakeholders see the "whole" before selecting specific areas for intervention\[77\].

**Simple Rules**A principle used to manage complex systems by identifying a **short list of basic constraints** (e.g., "stay connected," "build success") that all agents follow\[54\]\[55\]. When applied, these rules allow **coherent patterns to emerge** across a diverse system without the need for rigid management\[55\]\[80\].

**Stocks and Flows**Concepts from System Dynamics\[26\]\[29\]. **Stocks** are things that **accumulate over time** (e.g., knowledge, money, dissatisfaction), while **flows** represent the **movement into or out of** those stocks\[30\]. Understanding these helps identify system stability or points of failure\[81\]\[82\].

**System Maturity**The theory that systems follow an **S-shaped growth curve** through four phases: **Growth** (searching for success), **Development** (replicating formulas), **Maturation** (optimizing and standardizing), and **Senescence** (decline or collapse)\[83\].

**Triple-Loop Learning**The highest level of learning, which involves **reflecting on the paradigms and power structures** that govern how we determine what is "right"\[36\]\[87\]. It is often referred to as **"learning to learn"** and addresses the legitimacy of the learning process itself\[36\]\[88\].

**Wicked Problems**Complex, ill-structured human situations where the **problem is not understood until a solution is formulated**\[5\]. They have no stopping rule, no single cause, and solutions are judged as **"better or worse"** rather than "right or wrong"\[6\]\[90\].

---
> [!info]- References
> [1] 118-The idea and practice of systems thinking and their rele.pdf
> [3] CAP0901_37_ENG_DEF_LR Small.pdf
> [4] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [5] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [6] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [7] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [10] Libro-Bob-Williams.pdf
> [14] 118-The idea and practice of systems thinking and their rele.pdf
> [15] 118-The idea and practice of systems thinking and their rele.pdf
> [18] 118-The idea and practice of systems thinking and their rele.pdf
> [24] 118-The idea and practice of systems thinking and their rele.pdf
> [26] 118-The idea and practice of systems thinking and their rele.pdf
> [29] Systems thinking for evaluation.pdf
> [30] Systems thinking for evaluation.pdf
> [31] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [34] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [35] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [36] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [37] Systems thinking for evaluation.pdf
> [38] 118-The idea and practice of systems thinking and their rele.pdf
> [39] Bob Williams - SSM.pdf
> [42] 118-The idea and practice of systems thinking and their rele.pdf
> [44] Systems thinking for evaluation.pdf
> [46] Systems thinking for evaluation.pdf
> [47] Systems thinking for evaluation.pdf
> [48] Systems thinking for evaluation.pdf
> [49] Systems thinking for evaluation.pdf
> [50] Bob Williams - SSM.pdf
> [51] Bob Williams - SSM.pdf
> [52] Systems thinking for evaluation.pdf
> [53] Systems thinking for evaluation.pdf
> [54] Systems thinking for evaluation.pdf
> [55] Systems thinking for evaluation.pdf
> [56] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf
> [59] Bob Williams - SSM.pdf
> [62] Systems thinking for evaluation.pdf
> [63] Systems thinking for evaluation.pdf
> [64] Systems thinking for evaluation.pdf
> [65] Systems thinking for evaluation.pdf
> [66] Systems thinking for evaluation.pdf
> [67] Systems thinking for evaluation.pdf
> [68] Systems thinking for evaluation.pdf
> [70] 118-The idea and practice of systems thinking and their rele.pdf
> [71] CAP0901_37_ENG_DEF_LR Small.pdf
> [72] Bob Williams - SSM.pdf
> [73] Soft Systems Methodology.pdf
> [74] Soft Systems Methodology.pdf
> [75] Bob Williams - SSM.pdf
> [76] Libro-Bob-Williams.pdf
> [77] Bob Williams - SSM.pdf
> [80] Systems thinking for evaluation.pdf
> [81] Systems thinking for evaluation.pdf
> [82] Systems thinking for evaluation.pdf
> [83] Systems thinking for evaluation.pdf
> [87] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [88] Hummelbrunner - Learning systems concepts and values in evaluation.pdf
> [90] 2015 - Wicked solutions a systems approach to complex problems - williams.pdf


FILE: 'C. West Churchman.md'
---
exported: '2026-01-31T20:15:32.478Z'
source: NotebookLM
type: chat
title: C. West Churchman on 💬Keywords and Jargon
tags:
  - Keywords
  - West-Churchman
author: C. West Churchman
---
### Key Keywords

**Systems Approach**, **Inquiring Systems**, **Wicked Problems**, **Teleology**, **Whole System**, **Suboptimization**, **Environmental Fallacy**, **Sweeping-in**, **Unfolding**, **Dialectics**, **Guarantor**, **Boundary Judgments**, **Securing Improvement**, **Ethical Imperative**.\[1\]

\--------------------------------------------------------------------------------

### Attached Glossary

**A Priori Concepts**The underlying formal structures (like logic, arithmetic, or geometry) and assumptions that an inquiring system must possess before it can receive or process any information\[10\].

**Boundary Judgments**The process of deciding **what is "inside" the system and what is part of the "environment."**\[13\]. This is considered a **design choice** made by the inquirer rather than a fixed reality\[16\]\[17\].

**Dialectics**A method of inquiry, rooted in Hegelian philosophy, that generates knowledge through the **confrontation of a thesis and an antithesis** to produce a synthesis\[18\]. It is used to surface and debate conflicting worldviews\[22\].

**Environmental Fallacy**The error of attempting to solve a problem by **isolating it from its context**, thereby ignoring the ramifications and responses of the broader environment\[6\].

**Guarantor**A concept or entity that provides **certainty or a "built-in guarantee"** that the knowledge produced by a system is valid or that a design will achieve its intended purpose\[27\]. Historically, rationalists identified this as God, while modern systems thinkers look to consensus or progress\[31\].

**Inquiring Systems**Systems designed with the purpose of **creating knowledge**, which Churchman defines as the capability of choosing the right means for desired ends\[34\]. The five major types include:

• **Leibnizian:** Builds networks of contingent facts and formal models (fact nets)\[38\].

• **Lockean:** Relies on **consensus** among a community of observers to establish "facts"\[38\].

• **Kantian:** Uses multiple **representations** or models to structure data, emphasizing that the mode of representation is a design choice\[38\].

• **Hegelian:** Employs a **dialectic** between opposing views to surface underlying assumptions\[38\].

• **Singerian:** A never-ending process of inquiry aimed at **progress** and "sweeping in" ethical and social variables\[36\].

**Moral Outrage**The suggested "germination" or **starting point for a systems planner**, where action is motivated by a visceral reaction to human suffering (e.g., "kids are starving") rather than a dispassionate "felt need"\[51\].

**Securing**A term emphasized by Churchman to indicate that a solution must not only be found but **implemented such that the improvement persists** in the larger system over time\[5\].

**Suboptimization**The process of **improving a part of a system** at the expense of the whole, often making the overall situation worse\[55\].

**Sweeping-in**A Singerian principle of **continually expanding the boundaries of inquiry** to include more variables, disciplines, and "enemies" (politics, morality, etc.) to achieve a more holistic understanding\[7\].

**Systems Approach**A philosophy of management based on the principle that **all aspects of the human world should be tied together** in a rational scheme\[34\]\[64\]. It begins by seeing the world through the eyes of another and discovering that every worldview is restricted\[1\].

**Teleology**The study of **purposeful behavior**; it characterizes systems as entities that pursue goals through the selection of functional means\[3\].

**Unfolding**A critical process of drawing out the **implications of a system's design**, specifically by identifying the client, decision-maker, designer, and their respective values\[8\].

**Wicked Problems**A class of social system problems that are **ill-formulated and confusing**, involving many stakeholders with conflicting values and ramifications that are thoroughly muddled across the whole system\[2\].

**Whole System**The concept that no part of a system can be understood or optimized without reference to the **entirety of the interconnected components** and their ultimate purpose\[1\].

---
> [!info]- References
> [1] Assad 2011 C West Churchman.pdf
> [2] Assad 2011 C West Churchman.pdf
> [3] Assad 2011 C West Churchman.pdf
> [5] Assad 2011 C West Churchman.pdf
> [6] The systems approach and its enemies - Churchman - abstarcts.pdf
> [7] Nelson 2003 - The Legacy of C West Churchman.pdf
> [8] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [10] [Book] Churchman - The Design of Inquiring Systems.pdf
> [13] Assad 2011 C West Churchman.pdf
> [16] [Book] Churchman - The Design of Inquiring Systems.pdf
> [17] Stowell - The Art of Systems Inquiry - retracing the footsteps of Churchman and Checkland.pdf
> [18] Assad 2011 C West Churchman.pdf
> [22] Assad 2011 C West Churchman.pdf
> [27] Assad 2011 C West Churchman.pdf
> [31] Churchman-Challenge-Reason-1-223-1968.pdf
> [34] Churchman and Stories of Information Systems Development.pdf
> [36] [Book] Churchman - The Design of Inquiring Systems.pdf
> [38] Checkland 1988 - Churchmans Anatomy of System Teleology revisited.pdf
> [51] Assad 2011 C West Churchman.pdf
> [55] Assad 2011 C West Churchman.pdf
> [64] Assad 2011 C West Churchman.pdf


FILE: 'Christopher Alexander.md'
---
exported: '2026-01-31T20:20:51.650Z'
source: NotebookLM
type: chat
title: Christopher Alexander
tags:
  - Christopher-Alexander
  - Keywords
---
Based on the sources, the work of Christopher Alexander focuses on the objective nature of order, beauty, and life in the built environment. His theories transitioned from mathematical rationalism and set theory to a cosmological understanding of space as a living structure.

### **Key Keywords**

**Wholeness**, **Centers**, **Patterns**, **Pattern Language**, **Generative Systems**, **Semilattice**, **Misfit**, **Quality Without a Name (QWAN)**, **Unfolding**, **Structure-Preserving Transformations**, **15 Geometric Properties**, **Piecemeal Growth**, **Human Feeling**.

\--------------------------------------------------------------------------------

### **Glossary of Concepts, Principles, and Theories**

**Theoretical Framework**

• **Wholeness:** An abstract mathematical structure existing in space that captures the global character of a configuration\[1\]. It is the root criterion of life and spirit in a building or town\[2\].

• **Quality Without a Name (QWAN):** The objective, precise, yet ineffable quality that constitutes the "life" of a structure\[2\]. It is characterized by a freedom from inner contradictions and a sense of being "at one" with the world\[3\]\[4\].

• **A City is Not a Tree:** Alexander’s critique of artificial planning, arguing that natural cities have the structure of a **Semilattice** (overlapping, complex sets of relationships), while designed cities are often forced into a **Tree** structure (hierarchical, non-overlapping sets), which destroys their social and functional vitality\[5\].

• **Fact and Value Unification:** The theory that statements about the degree of "life" or "harmony" in a structure are objective facts (true or false) rather than subjective opinions\[8\].

**Mechanics of Design**

• **Centers:** The primary entities of which wholeness is built; they are distinct, noticeable configurations that recursively strengthen one another\[11\].

• **Pattern:** A three-part rule expressing the relationship between a specific **Context**, a recurring **Problem** (or system of forces), and a spatial **Configuration** that allows those forces to resolve themselves\[14\].

• **Pattern Language:** A generative system consisting of a kit of patterns and rules for their combination, allowing users to generate an infinite variety of unique, well-adapted designs\[17\].

• **Misfit:** A specific point of failure or "irritant" where a form does not fit its context\[20\]\[21\]. Design is seen as the humble activity of identifying and neutralizing these misfits\[20\].

• **Generative System:** A kit of parts with combinatory rules capable of creating "wholes"\[24\]\[25\]. Alexander argues that living structures must be _generated_ (grown from a seed/rule set) rather than _fabricated_ (built from a static blueprint)\[17\].

**The Process of Growth**

• **Unfolding:** A dynamic process of development where the whole precedes the parts through progressive differentiation\[28\]\[29\].

• **Structure-Preserving (or Wholeness-Extending) Transformations:** The steps in an unfolding process that strengthen and enhance the existing wholeness of a site while adding new structure\[12\].

• **Piecemeal Growth:** The principle that construction should be weighted toward small projects and continuous repair rather than "large lump" master planning\[32\]\[33\].

• **Agency and Participation:** The principle that all decisions about what and how to build should be in the hands of the users, as they possess the most local knowledge to achieve "fit"\[32\]\[33\].

**The 15 Geometric Properties of Life**

Alexander identified 15 recurrent structural features present in all living systems\[34\]:

1\. **Levels of Scale:** Centers associated with other centers at distinct size-ratios\[13\]\[37\].

2\. **Strong Centers:** Focal points that anchor the structure\[13\].

3\. **Boundaries (Thick Boundaries):** Separating zones that are themselves made of centers\[34\]\[38\].

4\. **Alternating Repetition:** Rhythmic variation between repeating elements\[39\]\[40\].

5\. **Positive Space:** Every bit of space has a coherent, substantial shape\[39\]\[40\].

6\. **Good Shape:** Coherent centers participating in the shape as a whole\[41\].

7\. **Local Symmetries:** Bonds between elements that create local unity\[41\].

8\. **Deep Interlock and Ambiguity:** Elements "hooked" into their surroundings\[34\]\[42\].

9\. **Contrast:** Centers distinguished through opposites\[42\].

10\. **Gradients:** Systematic variation in size or quality\[43\].

11\. **Roughness:** Imperfections resulting from required local adaptations\[43\]\[44\].

12\. **Echoes:** Family resemblances or deep connections between entities\[44\]\[45\].

13\. **The Void:** Undifferentiated, quiet centers within a structure\[45\]\[46\].

14\. **Simplicity and Inner Calm:** Removal of all unnecessary features\[4\]\[46\].

15\. **Not-Separateness:** Connectedness and continuity with the surrounding world\[4\]\[46\].

---
> [!info]- References
> [1] Alexander - Harmony seeking computations.pdf
> [2] A search for beauty a struggle with complexity Alexander.pdf
> [3] A search for beauty a struggle with complexity Alexander.pdf
> [4] Alexander - Harmony seeking computations.pdf
> [5] A search for beauty a struggle with complexity Alexander.pdf
> [8] A search for beauty a struggle with complexity Alexander.pdf
> [11] A search for beauty a struggle with complexity Alexander.pdf
> [12] Alexander - Harmony seeking computations.pdf
> [13] Alexander - Harmony seeking computations.pdf
> [14] A search for beauty a struggle with complexity Alexander.pdf
> [17] A search for beauty a struggle with complexity Alexander.pdf
> [20] A search for beauty a struggle with complexity Alexander.pdf
> [21] Misfits Balance Requirements and Systems_ Thoughts on Alexande.pdf
> [24] Coevolving innovations systems generating systems architectural design theory by Christopher Alexander -1968.pdf
> [25] Systems Changes Ing Learning Alexander Legacy.pdf
> [28] A search for beauty a struggle with complexity Alexander.pdf
> [29] Systems Changes Ing Learning Alexander Legacy.pdf
> [32] A search for beauty a struggle with complexity Alexander.pdf
> [33] A search for beauty a struggle with complexity Alexander.pdf
> [34] A search for beauty a struggle with complexity Alexander.pdf
> [37] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [38] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [39] Alexander - Harmony seeking computations.pdf
> [40] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [41] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [42] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [43] Alexander - Harmony seeking computations.pdf
> [44] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf
> [45] Alexander - Harmony seeking computations.pdf
> [46] Alshaikh 2013 - Christopher Alexander 15 Properties.pdf


FILE: 'Claude Shannon.md'
---
exported: '2026-01-31T20:09:30.746Z'
source: NotebookLM
type: chat
title: Claude Shannon on 💬Keywords and Jargon
tags:
  - Claude-Shannon
  - Keywords
author: Claude Shannon
---
Based on the provided sources, the key concepts, principles, and theories at the intersection of information theory, complexity science, and semiotics are summarized below.

### **Key Keywords**

• **Information Theory:** Entropy (H), Bit, Channel Capacity (C), Noise, Redundancy, Source Coding, Channel Coding, Equivocation, Mutual Information (I(X;Y)), Stochastic Process\[1\].

• **Complexity & Systems:** Emergence, Complex vs. Complicated, Cynefin Framework, Digital Twin, Systems Thinking, Organizational Congruence, Transdisciplinarity\[6\].

• **Thermodynamics & Semiotics:** Boltzmann Entropy, Information as Absence, Constraint, Referential Information, Natural Selection, Semiosis\[10\].

• **Meaning & Consciousness:** Integrated Information Theory (IIT), Φ (Phi), Cause-Effect Power, Semantic Information, Loop-Closing Semantics\[15\].

\--------------------------------------------------------------------------------

### **Attached Glossary**

**Absence (Information as):** A constitutive principle where information is not intrinsic to a signal but is defined by its relationship to the ensemble of possible messages that were _not_ produced\[11\].

**Bit:** The fundamental unit of information, representing a choice between two equally probable alternatives (a "binary digit" or "binary unit")\[20\].

**Channel Capacity (**C**):** The maximum rate at which a medium can reliably transmit information, determined by bandwidth and signal-to-noise ratio\[23\]. It is the benchmark beyond which transmission error becomes unavoidable\[26\]\[27\].

**Complex vs. Complicated:** A system is **complicated** if its many parts can be disassembled and reassembled without changing the system's nature; it is **complex** if its interactions are non-linear, irreversible, and produce emergent behaviors\[6\]\[7\].

**Congruence:** The alignment between an organization’s "Organizational Intelligence" (what it thinks) and its "Performance Management" (what it does), managed via tools like the CX Tool\[28\]\[29\].

**Constraint:** A boundary condition or relationship between what is and what could have been; a reduction in signal variety that serves as the physical basis for referential information\[12\]\[30\].

**Cynefin Framework:** A sensemaking framework used to categorize systems into five domains (Obvious, Complicated, Complex, Chaotic, and Disordered) to determine appropriate management responses\[9\]\[31\].

**Digital Twin:** A virtual version of a physical system used to simulate design and usage to uncover and mitigate unpredictable, undesirable emergent behaviors before they occur in reality\[8\]\[32\].

**Emergence:** Global behaviors or phenomena that arise from the interactions of a system's parts but cannot be predicted from the properties of those individual parts alone\[7\]\[33\].

**Entropy (**H**):**

1\. **Shannon Entropy:** A mathematical measure of uncertainty or "freedom of choice" in selecting a message\[1\]\[34\].

2\. **Boltzmann Entropy:** A measure of thermodynamic disorder or the number of microstates in a physical system\[10\].

**Equivocation:** The conditional entropy of the message source given that the signal is known; it measures the average uncertainty or "ambiguity" remaining after a signal is received\[37\]\[38\].

**Integrated Information Theory (IIT):** A theory that quantifies information from the intrinsic perspective of a system, focusing on "meaning" as a cause–effect structure and measured by the metric Φ **(Phi)**\[16\].

**Loop-Closing Semantics:** A theory suggesting that the most basic form of semantic information is concerned with control (e.g., a thermostat using data to determine when to act)\[15\]\[40\].

**Noise:** Unwanted additions to a signal during transmission that interfere with the accurate reproduction of the original message\[23\].

**Redundancy:** The fraction of a message structure determined by statistical rules rather than free choice; it reduces information capacity but is essential for distinguishing signals from noise\[43\]\[44\].

**Semiosis:** The process of sign action or communication, which Deacon argues is founded on a three-tiered synthesis of Shannon’s communication theory, Boltzmann’s thermodynamics, and Darwin’s natural selection\[45\].

**Source Coding:** The process of "squishing" or compressing a message to remove unnecessary redundancy for more efficient transmission\[2\].

**Stochastic Process:** A fundamentally statistical or probabilistic process used to model information sources (like the English language) where choices depend on previous outcomes\[41\].

**Triz:** The "Theory of Inventive Problem Solving," a methodology for resolving contradictions in complex systems to increase "ideality"\[53\].

---
> [!info]- References
> [1] Assignment3ShannonAndWeaverModel.pdf
> [2] Claude Shannon his work and its legacy.pdf
> [6] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [7] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [8] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [9] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [10] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [11] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [12] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [15] Austen info.pdf
> [16] Shannon Information and Integrated Information - Message and meaning.pdf
> [20] Austen info.pdf
> [23] Claude Shannon his work and its legacy.pdf
> [26] Rioul - This is IT a primer on Shannon Entropy and Information.pdf
> [27] [Book] Shannon - Mathematical Theory of Communication.pdf
> [28] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [29] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [30] tw deacon - shanon boltzmann darwin - redefining information part II.pdf
> [31] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [32] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [33] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf
> [34] [Book] Shannon - Mathematical Theory of Communication.pdf
> [37] SHANNON.PDF
> [38] [Book] Shannon - Collected Papers of Claude E. Shannon.pdf
> [40] Austen info.pdf
> [41] Assignment3ShannonAndWeaverModel.pdf
> [43] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [44] [Book] Shannon - Mathematical Theory of Communication.pdf
> [45] 2008 - Shannon -Boltzmann — Darwin Redefining information (Part I) Re-conceptualizing information - Deacon - Cognitive Semiotics.pdf
> [53] [Book] Kahlen - Transdisciplinary Perspectives on Complex Systems New Findings and Approaches.pdf


FILE: 'Colin Eden.md'
---
exported: 2026-02-07T17:21:55.441Z
source: NotebookLM
type: chat
title: Colin Eden on 💬Keywords and Jargon
tags:
  - Keywords
  - Colin-Eden
author: Colin Eden
---
### Key Concepts, Principles, and Theories

**Methodologies and Frameworks**

• **SODA** (Strategic Options Development and Analysis)

• **JOURNEY** (JOintly Understanding, Reflecting, and NEgotiating strategY)

• **PSMs** (Problem Structuring Methods)

• **Soft Systems** / **Open Systems**

**Theoretical Underpinnings**

• **Theory of Personal Constructs** (George Kelly)

• **Subjective Reality** / **Social Construction of Reality**

• **Bounded Rationality**

• **Satisficing**

• **Procedural Justice**

• **Procedural Rationality**

• **Theories-in-Use** vs. **Espoused Theories**

**Strategic Management Concepts**

• **Emergent Strategizing**

• **Political Feasibility**

• **Strategic Intent**

• **Distinctive Competencies**

• **Business Model** / **Livelihood Scheme**

• **Stakeholder Management** (Power/Interest Grid)

• **Strategic Issue Management**

**Modelling and Analysis Terms**

• **Cognitive Mapping**

• **Cause Mapping**

• **Oval Mapping Technique (OMT)**

• **Tear-drops** (Hierarchical Clusters)

• **Potent Options**

• **Feedback Loops** (Vicious/Virtuous Circles)

• **Transitional Object**

\--------------------------------------------------------------------------------

### Glossary of Terms

**Business Model / Livelihood Scheme**A description of how an organization converts purposeful activity into revenue (profit) or validates its right to exist (public service). The **Business Model** applies to the private sector, while the **Livelihood Scheme** applies to public or not-for-profit organizations. It represents the link between **distinctive competencies** and the organization's **aspirations**\[1\],\[2\],\[3\],\[4\].

**Cognitive Mapping**A modeling technique based on **Personal Construct Theory** used to capture an individual's thinking about a problem in a diagrammatic format (a directed graph). It links concepts (nodes) with arrows to show causality and argumentation, typically moving from options at the bottom to goals at the top\[5\],\[6\],\[7\],\[8\].

**Cause Map**Often used interchangeably with cognitive map, but specifically refers to the aggregated or merged map of a group (as opposed to an individual). It represents the "strategy map" of a team, incorporating conflicting views and multiple perspectives\[9\],\[7\].

**Distinctive Competencies**Those particular strengths within an organization that are difficult to emulate and can be utilized to provide value to stakeholders. They are the systemic properties that underpin long-term success and differentiate the organization from others\[10\],\[11\],\[12\].

**Emergent Strategizing**The concept that an organization’s strategic future is often determined by patterns of decision-making, routines, and habits ("muddling through") rather than by a deliberate strategic plan. It reflects "theories-in-use" rather than "espoused theories"\[13\],\[14\],\[15\].

**Espoused Theories vs. Theories-in-Use**A distinction drawn from Argyris and Schon. **Espoused theories** are what people say they do (official statements), while **theories-in-use** are the beliefs that actually guide their behavior and actions. SODA seeks to capture theories-in-use\[16\],\[17\].

**Feedback Loops (Vicious and Virtuous Circles)**Cyclical chains of causality within a map where an effect feeds back to influence its cause. **Vicious circles** are degenerative loops (e.g., declining sales leading to less investment leading to worse quality leading to lower sales), while **virtuous circles** are regenerative. Identifying and managing these is critical for strategic control\[18\],\[19\],\[20\].

**Heads and Tails**Structural features of a cognitive map. **Heads** are concepts with no outgoing arrows (usually goals or aspirations). **Tails** are concepts with no incoming arrows (usually detailed options or inputs). Analyzing the ratio of heads to tails helps determine the complexity of the problem structure\[21\],\[22\].

**JOURNEY**An acronym for **JOintly Understanding, Reflecting, and NEgotiating strategY**. It represents the cyclical process of strategy making where the focus is on the social negotiation of a new order and the gaining of emotional and cognitive commitment from the management team\[23\],\[24\],\[25\].

**Oval Mapping Technique (OMT)**A low-technology group method where participants write ideas on oval-shaped cards and arrange them on a wall to create a group cause map. It allows for rapid structuring, clustering, and negotiation of strategic issues\[26\],\[27\],\[28\].

**Political Feasibility**The assessment of whether a strategy can actually be implemented given the power structures and interests within and around the organization. It emphasizes that a technically "correct" strategy is useless if it cannot garner the necessary support from power brokers\[29\],\[30\],\[31\].

**Potent Options**Actions or options at the bottom of a map hierarchy that have ramifications for a large number of goals or themes. They are "potent" because they offer high leverage, impacting multiple strategic issues simultaneously\[32\],\[33\],\[34\].

**Procedural Justice**The perception that the decision-making process is fair, even if the outcome is not what an individual wanted. It relies on the principles of **engagement** (involvement), **explanation** (understanding why decisions were made), and **expectation clarity**\[35\],\[36\],\[37\].

**Procedural Rationality**The extent to which the decision-making process appears to be logical, coherent, and defensible. It ensures that the procedure itself makes sense to the participants, helping to generate cognitive commitment\[38\],\[39\],\[40\].

**SODA (Strategic Options Development and Analysis)**A **Problem Structuring Method** designed to help groups deal with "messy" or complex problems. It uses cognitive mapping to capture individual views and merges them to facilitate negotiation and agreement on action\[41\],\[42\].

**Stakeholder Management (and Power/Interest Grid)**Going beyond analysis to actively managing relationships. The **Power/Interest Grid** is a tool to categorize stakeholders (e.g., as "Players," "Subjects," "Context Setters," or "Crowd") based on their ability to influence the organization and their interest in doing so, in order to devise specific management strategies\[43\],\[44\],\[45\].

**Tear-drops**A visual structure in a cognitive map where a cluster of arguments hangs from a single superordinate concept (usually a goal or issue label). It represents a hierarchical bundle of explanations and options supporting a specific point\[26\],\[46\],\[47\].

**Transitional Object**Refers to the cognitive or cause map when used as a tool in negotiation. The map becomes a tangible artifact that separates the problem from the person, allowing the group to critique and negotiate the model rather than attacking the individual who proposed the idea\[27\],\[46\],\[48\].

---
> [!info]- References
> [1] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [2] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [3] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [4] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [5] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [6] [Book] Eden et al - 1979 - Thinking in organizations - Macmillan.pdf
> [7] eden use of cognitive maps to structure problems.pdf
> [8] eden use of cognitive maps to structure problems.pdf
> [9] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [10] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [11] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [12] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [13] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [14] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [15] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [16] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [17] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [18] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [19] [Book] Eden et al - 1983 - Messing about in problems - Pergamon Press.pdf
> [20] eden use of cognitive maps to structure problems.pdf
> [21] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [22] eden use of cognitive maps to structure problems.pdf
> [23] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [24] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [25] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [26] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [27] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [28] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [29] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [30] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [31] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [32] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [33] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [34] eden use of cognitive maps to structure problems.pdf
> [35] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [36] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [37] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [38] Ackermann - Extending the scope of problem structuring methods.pdf
> [39] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [40] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [41] Ackermann - Extending the scope of problem structuring methods.pdf
> [42] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [43] [Book] Ackermann et al - 2005 - The practice of making strategy - SAGE.pdf
> [44] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [45] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [46] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [47] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf
> [48] [Book] Eden,Ackermann - 1998 - Making strategy - Sage Publications.pdf


FILE: 'Dave Snowden.md'
---
exported: '2026-01-31T20:09:08.287Z'
source: NotebookLM
type: chat
title: Dave Snowden on 💬Keywords and Jargon
tags:
  - Dave-Snowden
  - Keywords
author: Dave Snowden
---

The following analysis extracts the **key concepts, principles, and theories** found within the sources, presented as core keywords followed by a detailed glossary.

### **Core Keywords**

• **Cynefin Framework**\[1\]

• **Anthro-complexity**\[4\]

• **Naturalizing Sense-making**\[7\]

• **Multi-ontology**\[2\]

• **Safe-to-fail Probes**\[12\]

• **Dispositionality**\[1\]

• **Retrospective Coherence**\[14\]

• **Emergence**\[19\]

• **Human Sensor Networks**\[22\]

• **Micro-narratives**\[1\]

• **Exaptation**\[26\]

• **Scaffolding**\[29\]

• **Actant**\[30\]\[32\]

• **Vector Theory of Change**\[33\]

• **Bounded Applicability**\[36\]

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**Abduction (Abductive Reasoning)**The logic of "hunches" or "best explanations" based on available patterns and information\[39\]. It involves using abstraction and metaphor to allow novel connections between apparently unconnected things, which is essential for innovation and exaptation\[27\]\[40\].

**Actant**A term drawn from literary theory referring to any person or object that plays an active role in a narrative\[30\]. In social systems, material objects, technology, and rituals can function as actants by scaffolding the system\[30\]\[32\].

**Anthro-complexity**A field of study that distinguishes human complex systems from biological or mathematical ones\[4\]\[5\]. It argues that human systems possess unique layers of complexity due to **Identity, Intelligence, and Intention**\[6\]. Unlike ants, humans switch between identities based on context and can act intentionally against their own self-interest\[41\].

**Attractor**A pattern of play or behavior that forms when small stimuli (probes) resonate with agents in a complex system\[45\]. Management in complexity involves **amplifying beneficial attractors** and **dampening negative ones**\[45\]\[46\].

**Bounded Applicability**The principle that most management methods and tools have a limited domain of validity\[36\]\[37\]. "Best practice" is only legitimate in ordered systems; applying it to complex systems is a category error that leads to unintended consequences\[37\].

**Chaos (Chaotic Domain)**A state characterized by the absence of effective constraints and no perceivable relationship between cause and effect\[2\]. In this domain, the required strategy is to **Act — Sense — Respond** to establish immediate stability\[2\].

**Complex Adaptive Systems (CAS)**Systems composed of many interacting agents where the system and agents co-evolve over time\[10\]. These systems are **irreducible**, meaning the whole is more than the sum of its parts, and they lack linear material causality\[54\].

**Complicated Domain**A domain of "order" where cause and effect are separated by time and space but are discoverable through **expertise and analysis**\[2\]. This is the realm of "known unknowns" where multiple "good practices" are possible\[59\].

**Constructor Theory**A theory recently integrated into sense-making that describes transformations in terms of what is possible and what is impossible\[40\]\[62\]. It identifies **constructors** (entities that cause change without changing themselves) and **substrates** (the entities being transformed) to map construction tasks within a landscape\[63\].

**Disorder (Confused Domain)**The central domain of the Cynefin framework, representing the state of not knowing which of the other domains applies\[2\]. In this state, decision-makers typically regress to their personal preferred management style rather than the one required by the context\[66\].

**Dispositionality**The property of complex systems to have a propensity to move in certain directions without specific outcomes being predictable\[1\]. Because these systems are not causal, they must be managed by understanding the **evolutionary potential of the present**\[55\].

**Exaptation**A concept from evolutionary biology referring to the radical repurposing of an existing feature for a new use (e.g., feathers evolving for warmth and being exapted for flight)\[26\].

**Human Sensor Networks**A method of distributed ethnography that utilizes large numbers of people to act as independent observers\[22\]. By gathering independent interpretations of micro-narratives, organizations can detect **weak signals** and outliers (the "17%") that experts or algorithms might miss\[24\].

**Liminality**A threshold or "in-between" space where things are transitioning between domains\[75\]\[76\]. The Cynefin framework uses liminal zones to represent the phase shifts required to move knowledge from an unordered state to an ordered one\[77\].

**Micro-narratives**The raw material of human sense-making, consisting of fragmented anecdotes, stories, and experiences told in the native language of the observer\[1\]. These are captured and **self-signified** by the teller to provide objective data for analysis\[22\].

**Naturalizing Sense-making**An approach that uses the natural sciences (neuroscience, biology, thermodynamics) as a **constraint** on social theory\[7\]. It asks how we make sense of the world so we can act in it, based on how the human brain actually processes information through pattern matching\[7\].

**Retrospective Coherence**The phenomenon in complex systems where cause-and-effect relationships only appear logical after the event has occurred\[14\]. Because this coherence is only visible in hindsight, it cannot be used as a basis for predictive planning\[21\].

**Safe-to-fail Experiments**Small, parallel experimental probes used in the complex domain to test multiple conflicting hypotheses\[13\]. They are designed so that failure provides learning without causing catastrophic system collapse\[12\].

**Scaffolding**Temporary or resilient structures used to support the flow of information and guide learning in complex systems\[29\]. Scaffolding provides the **enabling constraints** necessary for order to emerge in uncertainty\[82\].

**Self-Signification**The practice where the originator of a narrative tags or indexes their own story using high-abstraction metadata\[22\]. This **disintermediates** the data, preventing the cognitive bias that occurs when a researcher or expert interprets another person's story\[80\].

**Vector Theory of Change**A theory of change for complex systems that measures the **direction and speed of travel** from the current state, rather than measuring progress toward a fixed, ideal future goal\[33\].

---
> [!info]- References
> [1] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [2] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [4] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [5] Cynefin-book-SAMPLE_Ed01.pdf
> [6] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [7] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [10] 100825 Origins of Cynefin.pdf
> [12] 044_ Making Sense of Human Systems an interview with Professor Dave Snowden.pdf
> [13] Cynefin Paper report.pdf
> [14] Snowden - Good fences make good neighbors 2011.pdf
> [19] 27036324 HBR snowden leaders decision making.pdf
> [21] cynefin in biomedical research.pdf
> [22] Cynefin vector theory of change.pdf
> [24] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [26] Cynefin-book-SAMPLE_Ed01.pdf
> [27] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [29] Cynefin-book-SAMPLE_Ed01.pdf
> [30] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [32] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [33] Cynefin vector theory of change.pdf
> [36] Cynefin-book-SAMPLE_Ed01.pdf
> [37] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [39] Cynefin-book-SAMPLE_Ed01.pdf
> [40] systems-10-00007 Snowden - The Substrate-Independence Theory.pdf
> [41] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [45] Snowden 2011 - Naturalising sense-making.pdf
> [46] Rettig.Snowden-ComplexityTheoryAndNarrativeResearch_notes.pdf
> [54] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [55] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [59] Dave-Snowden-IEA14.pdf
> [62] systems-10-00007 Snowden - The Substrate-Independence Theory.pdf
> [63] Snowden - As through the glass darkly a complex systems approach to futures.pdf
> [66] Snowden - Anticipatory Models for Counter-Terrorism.pdf
> [75] Cynefin-book-SAMPLE_Ed01.pdf
> [76] systems-10-00007 Snowden - The Substrate-Independence Theory.pdf
> [77] EU Managing Complexity (and chaos) in Times of Crisis.pdf
> [80] Snowden 2011 - Naturalising sense-making.pdf
> [82] systems-10-00007 Snowden - The Substrate-Independence Theory.pdf


FILE: 'David L Abel.md'
---
exported: '2026-01-31T20:21:32.387Z'
source: NotebookLM
type: chat
title: David L. Abel
tags:
  - David-L-Abel
  - Keywords
---
### Key Concepts, Principles, and Theories

• **Active Selection**\[1\]

• **Algorithmic Optimization**\[4\]

• **Assembly Theory (AT)**\[7\]

• **Biocybernetics**\[10\]

• **Biosemiotics**\[3\]

• **Choice Contingency**\[15\]

• **Computational Halting**\[18\]

• **Configurable Switch (CS) Bridge**\[21\]

• **Cybernetic Cut**\[22\]

• **Dynamic Incoherence (Physicodynamic Inertness)**\[26\]

• **F > P Principle (Formalism > Physicality)**\[29\]

• **Functional Sequence Complexity (FSC)**\[10\]

• **Genetic Selection (GS) Principle**\[33\]

• **Law of Physicodynamic Incompleteness**\[31\]\[36\]

• **Material Symbol Systems (MSS)**\[37\]

• **Ordered Sequence Complexity (OSC)**\[10\]

• **Prescriptive Information (PI)**\[42\]

• **Random Sequence Complexity (RSC)**\[10\]

• **Self-Ordering vs. Self-Organization**\[46\]

• **Universal Plausibility Principle (UPP)**\[49\]

\--------------------------------------------------------------------------------

### Glossary of Key Terms

**Active Selection:** The **purposeful choice** of a specific option from among real physical possibilities **in pursuit of a potential function** that does not yet exist\[2\]. This is distinguished from natural selection, which is a passive, secondary filter of already-existing fitness\[33\].

**Algorithmic Optimization:** The process of **refining a step-by-step procedure** (algorithm) through purposeful choices to achieve maximum functional efficiency or computational success\[5\].

**Assembly Theory (AT):** A model that attempts to **measure the "causation difficulty"** required to produce a given molecular ensemble\[7\]. The sources critique AT for failing to distinguish between mere physical complexity and the **orchestration of formal systems** required for life\[58\]\[59\].

**Choice Contingency:** A fundamental category of reality involving **selection from among real options** based on intent or rules rather than chance or physical necessity\[15\]. It is the source of all formal utility and cybernetic control\[17\].

**Computational Halting:** The successful **completion of a programmed operation** at a destination\[19\]. In biology, "halting" is often defined as the achievement of **homeostatic metabolism** or functional protein folding\[18\].

**Configurable Switch (CS) Bridge:** The mechanism by which **non-physical formalism is instantiated into physicality**\[21\]. It requires physical devices (logic gates) that are "dynamically inert," meaning their settings are not determined by physical laws but by **choice contingency**\[68\].

**Cybernetic Cut:** The **fundamental divide in reality** between the "near side" of **physicality** (governed by chance and necessity) and the "far side" of **formalism** (governed by choice and agency)\[22\].

**Dynamic Incoherence (Physicodynamic Inertness):** A state where the **physical properties of a system do not determine its configuration**\[26\]. For example, the four nucleotides in DNA can be polymerized in any order because the chemical bonds are identical, allowing the sequence to be determined by **formal rules** rather than physical law\[73\].

**F > P Principle (Formalism > Physicality):** The principle stating that **formalism precedes, organizes, and governs physicality**\[29\]. It holds that mathematical laws and prescriptive instructions are the primary source of organized reality\[76\]\[77\].

**Functional Sequence Complexity (FSC):** A specific subset of complexity found in **sequences that perform a function** or provide instructions\[10\]. Unlike random complexity, FSC is narrow and results from **non-random selection for utility**\[78\].

**Genetic Selection (GS) Principle:** The requirement that **selection for function must occur at the molecular level** (polynucleotide sequencing) _before_ phenotypic fitness exists for natural selection to favor\[33\]. This principle holds that **natural selection cannot explain the origin of genetic code**\[81\].

**Material Symbol System (MSS):** A communication system where **physical objects (tokens) are assigned arbitrary formal meanings**\[37\]. DNA is viewed as a literal MSS where nucleotides serve as **physical symbol vehicles** representing amino acid prescriptions\[39\].

**Ordered Sequence Complexity (OSC):** Sequences that are **highly redundant, predictable, and compressible** (e.g., a crystal or a polyadenosine polymer)\[10\]. OSC represents **low informational potential** and cannot program biological function\[5\].

**Prescriptive Information (PI):** Information that **instructs, programs, or produces nontrivial function** at its destination\[42\]. PI is uniquely **cybernetic** and originates only from choice-contingent causation\[89\].

**Random Sequence Complexity (RSC):** Sequences characterized by **maximum uncertainty and zero compressibility** (randomness)\[10\]. While mathematically "complex," RSC is **blind to function** and cannot organize biological systems\[34\].

**Self-Ordering:** Spontaneous physical phenomena (like vortices or crystals) that result from **invariant laws and physical constraints**\[46\]. They are **redundant and low-informational**, and they do not constitute "organization"\[93\].

**Self-Organization:** A term often used as a misnomer for self-ordering; the sources define it as a **"nonsense term"** because inanimate objects lack the **choice contingency** required to integrate formal systems\[46\].

**Universal Plausibility Principle (UPP):** A scientific standard requiring the **rejection of any hypothesis** that measures out with a **Universal Plausibility Metric (ξ) of less than 1.0**\[49\]. It is used to falsify models of spontaneous generation that are **statistically prohibitive**\[49\].

---
> [!info]- References
> [1] Abel - Assembly theory in life-origin models a critical review.pdf
> [2] Abel - Assembly theory in life-origin models a critical review.pdf
> [3] Abel - Assembly theory in life-origin models a critical review.pdf
> [4] Abel - Assembly theory in life-origin models a critical review.pdf
> [5] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [7] Abel - Assembly theory in life-origin models a critical review.pdf
> [10] Abel - Assembly theory in life-origin models a critical review.pdf
> [15] Abel - Assembly theory in life-origin models a critical review.pdf
> [17] Abel - The Three Fundamental Categories of Reality.pdf
> [18] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [19] Abel - Is Life Reducible to Complexity.pdf
> [21] Abel - Assembly theory in life-origin models a critical review.pdf
> [22] Abel - Assembly theory in life-origin models a critical review.pdf
> [26] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [29] Abel - Assembly theory in life-origin models a critical review.pdf
> [31] Abel - What is life.pdf
> [33] Abel - Assembly theory in life-origin models a critical review.pdf
> [34] Abel - Complexity self-organization and emergence at the edge of chaos in life origin models.pdf
> [36] Abel - Constraints vs Controls.pdf
> [37] Abel - Assembly theory in life-origin models a critical review.pdf
> [39] Abel_D_L_2011_Linear_Digital_Material_Sy.pdf
> [42] Abel - Assembly theory in life-origin models a critical review.pdf
> [46] Abel - Assembly theory in life-origin models a critical review.pdf
> [49] Abel - Assembly theory in life-origin models a critical review.pdf
> [58] Abel - Assembly theory in life-origin models a critical review.pdf
> [59] Abel - Assembly theory in life-origin models a critical review.pdf
> [68] Abel - Constraints vs Controls.pdf
> [73] Abel - Assembly theory in life-origin models a critical review.pdf
> [76] Abel - Assembly theory in life-origin models a critical review.pdf
> [77] Abel - The Cybernetic Cut and Configurable Switch Bridge.pdf
> [78] Abel - Is Life Reducible to Complexity.pdf
> [81] Abel - Assembly theory in life-origin models a critical review.pdf
> [89] Abel - Assembly theory in life-origin models a critical review.pdf
> [93] Abel - Self organisation vs self ordering events in Life origin models.pdf


FILE: 'Dee Hock.md'
---
exported: '2026-01-31T20:16:42.645Z'
source: NotebookLM
type: chat
title: Dee Hock on 💬Keywords and Jargon
tags:
  - Dee-Hock
  - Keywords
author: Dee Hock
---
### Key Concepts, Principles, and Theories

The following keywords, principles, and theories represent the core framework for navigating complexity and designing "chaordic" organizations as presented in the sources.

**Keywords**

• **Chaord/Chaordic:** A blend of **chaos** and **order** describing self-organizing, adaptive, and non-linear complex systems\[1\].

• **Holon:** An entity that is simultaneously a **whole** and a **part** of a larger system\[6\].

• **Bifurcation Point:** A moment of qualitative change where a system enters instability and potentially "leaps" to a higher level of complexity\[10\].

• **Attractor:** A force or condition that draws a system toward a specific pattern of behavior\[6\].

• **Indeterminacy:** The principle that the future of a complex system is **unknowable** because links between cause and effect are obscured\[14\].

• **Emergence:** The process by which a system naturally strives for ascending levels of coherence and complexity through **self-organization**\[18\].

• **Dissipation:** The cycle where a system "falls apart" to grow back together in a novel, more complex form\[17\].

• **Orgmind (Organizational Mind):** The collective consciousness or shared beliefs that serve as the ground state of a system\[17\].

• **Invisible Leader:** A shared **Purpose** that guides behavior when top-down control is absent\[28\].

\--------------------------------------------------------------------------------

**Core Theories**

1\. **Chaordic Systems Thinking (CST):** A lens that views organizations as dynamical flows traveling through "attractor landscapes" rather than fixed, linear structures\[13\]. It transcends traditional systems thinking by including the **interior** aspects (culture, intentions) alongside observable exterior behaviors\[35\].

2\. **Open Systems Thinking (OST):** A precursor to CST that views systems as seeking stability and equilibrium through feedback loops but is limited by a unilateral focus on the **exterior** manifestations of a system\[37\].

3\. **Complexity Science:** The study of complex adaptive systems that exist at the "edge of chaos," where order arises spontaneously from a web of interconnected relationships\[4\].

\--------------------------------------------------------------------------------

**Guiding Principles**

• **Distributive Governance/Power:** No function should be performed by a central part if a peripheral part can do it; power must be vested in the smallest unit possible\[45\].

• **Malleability and Durability:** Systems must be capable of constant, self-generated modification of form without sacrificing their essential nature\[49\].

• **Ownership as Participation:** Ownership should be held through irrevocable rights of participation rather than tradeable stock\[53\].

• **Induced vs. Compelled Behavior:** True leadership **educes** (draws out) behavior based on shared values, whereas tyranny **compels** behavior through authority and force\[29\].

• **The Will to Succeed, The Grace to Compromise:** The core ethical principle used to reconcile irreconcilable differences in a chaordic system\[61\].

\--------------------------------------------------------------------------------

### **Attached Glossary**

| Term | Definition |
| --- | --- |
| Attractor Basin | The region or "valley" in conceptual space where a system is drawn to follow a specific pattern of behavior[11]. |
| Butterfly Effect (SDIC) | "Sensitive Dependence on Initial Conditions"; the idea that minute changes in a complex system can amplify into enormous outcomes[65]. |
| Connectivity | The property asserting that a system is an unbreakable unity where no part can exist independently of the whole[14]. |
| Deep Dialogue | A mode of communication designed to surface the "hidden" mental processes and inconsistencies in thinking that prevent transformation[70]. |
| Far-From-Equilibrium (FFE) | A state of dynamic balance at the "edge of chaos" where a system is most susceptible to transformation and innovation[33]. |
| Holonic Capacity | The potential intrinsic in a system for self-transcendence, determined by its level of mindfulness and connectivity[76]. |
| Indeterminacy | The fundamental unknowability of the future in complex systems because links between cause and effect are obscured[14]. |
| Limiting Beliefs | Unchecked individual or collective assumptions and fears that sabotage innovation by building "old fears" into "new structures"[79]. |
| Necessity | The compelling, present reason for doing work; the condition in current affairs that demands change[84]. |
| PLUME | A set of practice principles for capturing results: Participatory, Learning, Useful, Multi-modal, and Emergent[88][89]. |
| Structure | The concrete logistics (roles, resources, action plans) that should only be designed after Necessity, Purpose, Principles, and People are established[90]. |

---
> [!info]- References
> [1] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [4] Dee Hock - The Chaordic Organization Review.pdf
> [6] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [10] Vaneijnatten 2004 chaordic systems thinking - learning organization.pdf
> [11] Vaneijnatten 2004 chaordic systems thinking - learning organization.pdf
> [13] vanEijnatten 2007 Chaordic Systems Thinking.pdf
> [14] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [17] vanEijnatten 2007 Chaordic Systems Thinking.pdf
> [18] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [28] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [29] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [33] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [35] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [37] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [45] Dee Hock - The Chaordic Organization Review.pdf
> [49] Dee Hock - The Chaordic Organization Review.pdf
> [53] Dee Hock - The Chaordic Organization Review.pdf
> [61] [Book] Hock - One from Many VISA and the Rise of Chaordic Organization.pdf
> [65] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [70] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [76] Chaordic Systems Thinking for organizational holnic renewal.pdf
> [79] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [84] Chaordic Stepping Stones Design Planning - Overview 2025.pdf
> [88] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [89] Chaordic Stepping Stones w.Template Harvest 2025.pdf
> [90] Chaordic Stepping Stones Design Planning - Overview 2025.pdf


FILE: 'Derek Cabrera.md'
---
exported: 2026-02-04T22:44:47.409Z
source: NotebookLM
type: chat
title: Derek Cabrera on 💬Keywords and Jargon
tags:
  - Derek-Cabrera
  - Keywords
author: Derek Cabrera
---
### Key Keywords

**DSRP Theory**, **Fourth Wave of Systems Thinking**, **Complex Adaptive Systems (CAS)**, **Emergence**, **Mental Models**, **Parallelism**, **Wicked Problems**, **VUCA**, **Metacognition**, **Cognitive Jigs**, **ST/DSRP Loop**, **Webs of Causality**, **Universal Reality Code**, **Intersubjectivity**, **Multivalent Logic**.\[1\]

\--------------------------------------------------------------------------------

### Attached Glossary

**Action-Reaction Relationships Rule (R):** One of the four DSRP rules stating that any idea or thing can **relate to other things or ideas**, defined by an **action (a) co-implying a reaction (r)**.\[7\]

**Atomic Structures:** The **four base structures of DSRP** (Distinctions, Systems, Relationships, Perspectives) which are information-agnostic and serve as the foundational building blocks of all thought.\[10\]\[11\]

**Complex Adaptive System (CAS):** A bottom-up phenomenon where **autonomous agents follow simple local rules**, leading to collective dynamics and **surprising emergent properties**.\[12\]

**Cognitive Jigs:****Molecular structures** made up of multiple atomic DSRP rules that are **content-agnostic** and repeatedly used to organize information, such as "Barbells", "P-circles", or "Part-parties".\[4\]

**Compound Structures (Frameworks):** Larger conceptual structures with a high ratio of **information-content to structure**, such as SWOT analysis or System Dynamics, which are built using atomic and molecular DSRP structures.\[10\]\[17\]

**Distinctions Rule (D):** One of the four DSRP rules stating that any idea or thing can be **distinguished from other ideas or things**, defined as an **identity (i) co-implying an other (o)**.\[7\]

**DSRP Theory:** A **universal theory of organization** positing that four simple cognitive rules (Distinctions, Systems, Relationships, Perspectives) underlie **complex cognition** and the organization of the **material world**.\[1\]

**Emergence:** An enigma of system behavior where the **dynamic interactions among parts** give rise to properties or outcomes that are absent if the parts act in isolation; the whole is always **exactly equal to (not greater than) the sum of its parts** when relational parts are included.\[21\]

**Fourth Wave of Systems Thinking:** An emerging paradigm that **unifies the field** by focusing on **universality, complexity, and cognition**, positing that systems thinking is an emergent property of the DSRP rules.\[2\]

**Mental Model (M):** A dynamic entity representing knowledge or meaning, defined as the **complex product (**⊗**) of Information (I) and Thinking/Organization (T)**, expressed as M\=I⊗T.\[28\]

**Metacognition:** The **awareness of one's own thinking processes**; in this context, it refers to the purposeful and conscious use of DSRP to structure information.\[26\]

**Multivalent Logic:** A logic that recognizes **multiple outcomes and nuance** ("shades of grey") rather than binary "either/or" classifications, allowing a thing to be simultaneously an identity, a part, a relationship, and a perspective.\[36\]

**Parallelism:** The degree of **alignment between mental models and the real world**; systems thinking aspires to make the probability of this match as high as possible.\[3\]

**Point-View Perspectives Rule (P):** One of the four DSRP rules stating that any thing or idea can be the **point (**ρ**) or the view (v) of a perspective**.\[9\]

**ST/DSRP Loop:** A continuous, recursive **feedback loop** where mental models are iteratively tested against real-world observables and refined based on informational feedback to **increase alignment with reality**.\[40\]

**Systems Rule (S):** One of the four DSRP rules stating that any idea or thing can be **split into parts or lumped into a whole**, defined as a **part (p) co-implying a whole (w)**.\[7\]

**Universal Reality Code:** The proposal that **DSRP is a code shared by both Mind (thinking) and Nature (reality)**, acting as a physico-cognitive bridge that allows the mind to decode information from reality.\[19\]

**VUCA:** An acronym for **Volatility, Uncertainty, Complexity, and Ambiguity**, describing the post-Cold War world context that generates "wicked problems" requiring systems thinking solutions.\[6\]\[39\]

**Webs of Causality (WoC):** A shift from linear cause-and-effect thinking to a network of **multiple interdependent causes** that interact to co-create outcomes, reflecting how real-world complex systems function.\[36\]

**Wicked Problems:** Seemingly **intractable, ill-structured, systemic issues** characterized by competing interests and multiple interacting systems that resist definitive solutions.\[51\]

---
> [!info]- References
> [1] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [2] Balan - how to improve systems thinking in aid.pdf
> [3] Cabrera - A Mathematical Theory of organizational DSRP as The Universal Reality Code.pdf
> [4] Cabrera - Developing Personal Mastery in Systems Thinking.pdf
> [6] Cabrera - Systems Thinking Flash Cards.pdf
> [7] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [9] Cabrera - Developing Personal Mastery in Systems Thinking.pdf
> [10] Cabrera - Developing Personal Mastery in Systems Thinking.pdf
> [11] Cabrera - The Four Waves of Systems Thinking.pdf
> [12] Balan - how to improve systems thinking in aid.pdf
> [17] Cabrera - The Four Waves of Systems Thinking.pdf
> [19] Cabrera - A Mathematical Theory of organizational DSRP as The Universal Reality Code.pdf
> [21] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [26] Cabrera Cabrera 2019 Reference Work Entry - What Is Systems Thinking.pdf
> [28] Cabrera - DSRP Theory - A Primer.pdf
> [36] 2020 A Literature Review of the Universal and Atomic Elements of Complex Cognition.pdf
> [39] systems-08-00006-v2.pdf
> [40] Cabrera - DSRP Theory - A Primer.pdf
> [51] Cabrera - From One Cause to Webs of Causality.pdf


FILE: 'Donella Meadows.md'
---
exported: '2026-01-31T20:04:55.622Z'
source: NotebookLM
type: chat
title: Donella Meadows on 💬Keywords and Jargon
tags:
  - Donella-Meadows
  - Keywords
author: Donella Meadows
---
Based on the provided sources, the following keywords represent the essential components of Donella Meadows' systems thinking and the findings of the **Limits to Growth** research.

### Key Concepts, Principles, and Theories (Keywords)

• **Leverage Points**\[1\]\[2\]

• **Feedback Loops** (Positive and Negative)\[3\]

• **Exponential Growth**\[7\]\[8\]

• **Overshoot and Collapse**\[9\]

• **Global Equilibrium**\[11\]\[13\]

• **Paradigms and Paradigm Shifts**\[14\]

• **Systemic Responsiveness**\[17\]

• **Delays**\[18\]\[19\]

• **Self-Organization**\[20\]\[21\]

• **Mental Models**\[22\]\[23\]

• **Dancing with Systems**\[24\]\[25\]

• **System Dynamics**\[26\]

\--------------------------------------------------------------------------------

### Attached Glossary

**Dancing with Systems**A behavioral framework for interacting with complex, unpredictable systems by abandoning the role of "omniscient conqueror" in favor of staying wide-awake, paying close attention, and responding to feedback\[24\]\[27\]. It involves "getting the beat," staying humble as a learner, and "error-embracing" through trial and error\[25\].

**Delays**Critical time lags in feedback loops relative to the rate of system change\[9\]\[31\]. Delays in information or response are common causes of **oscillations**, instability, and **overshoot**, as they prevent a system from reacting in time to approach limits smoothly\[10\].

**Exponential Growth**A pattern of growth where a quantity increases by a **constant percentage** of the whole in a constant time period\[8\]\[33\]. It is deceptive because it generates immense numbers very quickly and can lead a system to approach fixed limits with suddenness\[34\]\[35\].

**Feedback Loops**The basic structural elements of a system consisting of circular cause-and-effect relationships\[36\]. **Negative loops** are self-correcting mechanisms that keep a system within safe bounds, while **positive loops** are self-reinforcing, driving growth, explosion, or collapse\[3\].

**Global Equilibrium**A sustainable state where the **population and capital** are essentially stable, with forces tending to increase or decrease them kept in a carefully controlled balance\[13\]\[38\]. This state allows for limitless social and individual development as long as it does not require large flows of irreplaceable resources\[39\]\[40\].

**Leverage Points**Specific places within a complex system where a **small shift** in one thing can produce **massive changes** in behavior across the entire system\[1\]\[2\]. These points are often counterintuitive, and Meadows ranks them in increasing order of effectiveness, with system goals and mindsets/paradigms being the highest\[41\].

**Mental Models**Internal, ordered sets of assumptions and theories about how a complex system works\[22\]\[23\]. Meadows argues that because everything we know is "only a model," we must expose these models to the "open air" so others can challenge and improve our assumptions\[22\]\[45\].

**Overshoot and Collapse**A behavior mode where a system, driven by exponential growth and delayed feedback, temporarily **surpasses its sustainable limits** (carrying capacity)\[9\]. This leads to a sudden and uncontrollable decline in population and industrial capacity as the system's resource base is depleted or the environment is overwhelmed\[11\].

**Paradigm**The deepest set of beliefs and **unstated assumptions** about how the world works, which serve as the source of a system's goals, rules, and structures\[14\]. Intervening at the level of paradigm is a high-leverage action that can totally transform a system\[16\]\[49\].

**Self-Organization**The power of a system to change itself utterly by adding or deleting structures, loops, and rules\[20\]\[21\]. It is the strongest form of **system resilience**, allowing a system to survive change by changing its own internal configuration\[20\]\[50\].

**System Dynamics**A methodology developed at MIT for understanding the behavior of complex systems by identifying the circular, interlocking, and time-delayed relationships among their components\[26\]\[51\].

**Systemic Responsiveness**A modern leadership practice that shifts focus from enforcing mandates to **enabling the conditions for flow** and collaboration\[52\]. It involves "seeing" the architecture of the whole while remaining alive to relational patterns and emotional rhythms\[17\]\[53\].

---
> [!info]- References
> [1] D Meadows Places To Intervene 1997.pdf
> [2] Leverage_Points.pdf
> [3] D Meadows Places To Intervene 1997.pdf
> [7] [Book] Meadows - The Limits to Growth.pdf
> [8] [Book] Meadows - The Limits to Growth.pdf
> [9] D Meadows Places To Intervene 1997.pdf
> [10] Leverage_Points.pdf
> [11] [Book] Meadows - The Limits to Growth.pdf
> [13] [Book] Meadows - The Limits to Growth.pdf
> [14] D Meadows Places To Intervene 1997.pdf
> [16] Leverage_Points.pdf
> [17] Seeing Differently Insights from Donella Meadows.pdf
> [18] D Meadows Places To Intervene 1997.pdf
> [19] Leverage_Points.pdf
> [20] D Meadows Places To Intervene 1997.pdf
> [21] Leverage_Points.pdf
> [22] Meadows.pdf
> [23] [Book] Meadows - The Limits to Growth.pdf
> [24] Meadows.pdf
> [25] Seeing Differently Insights from Donella Meadows.pdf
> [26] [Book] Meadows - The Limits to Growth.pdf
> [27] Meadows.pdf
> [31] Leverage_Points.pdf
> [33] [Book] Meadows - The Limits to Growth.pdf
> [34] [Book] Meadows - The Limits to Growth.pdf
> [35] [Book] Meadows - The Limits to Growth.pdf
> [36] [Book] Meadows - The Limits to Growth.pdf
> [38] [Book] Meadows - The Limits to Growth.pdf
> [39] [Book] Meadows - The Limits to Growth.pdf
> [40] [Book] Meadows - The Limits to Growth.pdf
> [41] D Meadows Places To Intervene 1997.pdf
> [45] Meadows.pdf
> [49] D Meadows Places To Intervene 1997.pdf
> [50] Leverage_Points.pdf
> [51] [Book] Meadows - The Limits to Growth.pdf
> [52] Seeing Differently Insights from Donella Meadows.pdf
> [53] Seeing Differently Insights from Donella Meadows.pdf


FILE: 'Fred Emery.md'
---
exported: '2026-01-31T20:11:20.810Z'
source: NotebookLM
type: chat
title: Fred Emery on 💬Keywords and Jargon
tags:
  - Fred-Emery
  - Keywords
author: Fred Emery
---
### **Key Keywords**

**Open System (OST\[E\])**, **L22 Environment**, **Causal Texture**, **Turbulent Field**, **Directive Correlation**, **Design Principle 1 (DP1)**, **Design Principle 2 (DP2)**, **Redundancy of Functions**, **Redundancy of Parts**, **Six Criteria (Intrinsic Motivators)**, **Purposeful Systems**, **Ideal Seeking**, **Active Adaptation**, **Maladaptive Defenses**, **Search Conference**, **Participative Design Workshop**, **The Thin Red Line**, **Socio-Technical Systems**.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts, Principles, and Theories**

**Systems and Environmental Logic**

• **Open System (OST\[E\]):** A system that maintains a "steady state" through a continuous "throughput" of energy and information from its environment, allowing it to achieve negative entropy and spontaneous reorganization toward greater complexity\[1\].

• **L-Relations (The L-Matrix):** A set of four potentially lawful connections representing internal system processes (**L11**), the system acting on the environment via planning (**L12**), the environment acting on the system via learning (**L21**), and processes within the environment itself (**L22**)\[4\].

• **Causal Texture:** The extent and manner in which variables relevant to a system are causally related or interwoven within the environment itself\[7\].

• **Environmental Levels:** A taxonomy of environments including **Placid Randomized (Type I)** where goals are random; **Placid Clustered (Type II)** where goals band together; **Disturbed-Reactive (Type III)** where similar systems compete; and **Turbulent (Type IV)** where dynamic processes arise from the field itself\[10\].

• **Vortical Environment (Type V):** A theoretically limiting state where maladaptive responses to turbulence lead to "clinched" or frozen connectedness, often resulting in localized whirlpools of destruction\[59\].

• **Directive Correlation (DC):** A condition where two or more variables, such as a system and its environment, are in exact correspondence to achieve an adaptive goal from a specific starting point\[62\].

**Organizational Design Principles (Genotypes)**

• **Design Principle 1 (DP1) - Redundancy of Parts:** A bureaucratic design where responsibility for coordination and control is located at least one level above the work, treating individuals as replaceable "parts" of a machine\[65\].

• **Design Principle 2 (DP2) - Redundancy of Functions:** A democratic design where responsibility for coordination and control is located with those doing the work, and individuals possess a wider range of skills than they use at any one time\[65\].

• **Redundancy of Parts:** Building system reliability by adding easily replaceable, specialized components that require external control mechanisms\[66\].

• **Redundancy of Functions:** Building system reliability by increasing the multi-functionality of individual parts, enabling them to self-regulate and re-set their functions based on shared values\[66\].

**Human and Psychological Requirements**

• **Six Criteria (Intrinsic Motivators):** The psychological requirements for productive activity, including **Elbow Room** (autonomy), **Continual Learning**, **Variety**, **Mutual Support and Respect**, **Meaningfulness**, and a **Desirable Future**\[71\].

• **Purposeful Systems:** Systems that can produce the same outcome in different ways within the same environment and can choose both their ends and their means\[81\].

• **Ideal Seeking:** The human capacity to choose outcomes (ideals) that are approachable but unattainable, allowing for stability and continuity in turbulent fields\[84\].

• **The Four Ideals:** Values necessary for active adaptation: **Homonomy** (belonging/interdependence), **Nurturance** (cultivating health/beauty), **Humanity** (regarding people as superordinate), and **Beauty** (aesthetic order)\[84\].

• **Ecological Learning:** The innate human ability to directly extract meaningful information and invariants from the social and physical environment\[92\].

**Adaptation and Maladaptation**

• **Active Adaptation:** The process where purposeful systems deliberately influence their social field through ideal-seeking to transform a turbulent environment into a more stable state\[87\].

• **Maladaptive Defenses:** Passive responses to turbulence that attempt to reduce environmental complexity via **Superficiality** (denying depth), **Segmentation** (breaking into poorly integrated parts), or **Dissociation** (withdrawal from social bonds)\[98\].

• **Second-Order Maladaptation:** Advanced states of system failure characterized by **Dogmatism** (frozen learning), **Stalemate** (frozen planning), and **Polarization** (frozen internal relations)\[99\].

**Methodologies and Philosophy**

• **Search Conference (SC):** A participative planning method where a community scans its environment and system to create a "most desirable future" and strategic action plans\[4\].

• **Participative Design Workshop (PDW):** A structured process for participants to redesign their own organizational units from DP1 to DP2 based on the Six Criteria and multiskilling\[110\].

• **The Two-Stage Model:** The integration of the Search Conference (external adaptation) and the Participative Design Workshop (internal structural adaptation) to achieve sustainable change\[113\].

• **Socio-Technical Systems (STS):** The theory that an organization consists of interdependent social and technical subsystems that must be jointly optimized to achieve maximum efficiency and human satisfaction\[116\].

• **The Thin Red Line:** A philosophical lineage of **Contextualism** and **Realism** (tracing from Peirce and James to Asch and Emery) that rejects abstract universals in favor of material universals and the study of people-in-environments\[119\].

• **Puzzle Learning:** A form of learning appropriate for complex environments where the end goal is unknown and must be discovered piece by piece, as opposed to problem-solving which assumes a known solution\[123\]\[124\].

---
> [!info]- References
> [1] Emery - The Causal Texture of Organizational Environments.pdf
> [4] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [7] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [10] Emery - The Causal Texture of Organizational Environments.pdf
> [59] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [62] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [65] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [66] Fred Emery - The Second Design Principle Participation and the Democratization of Work.pdf
> [71] Emery 2000 - The Evolution of Open Systems to the 2 Stage Model.pdf
> [81] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [84] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [87] [Book] Emery - Towards a Social Ecology Contextual Appreciation of the Future in the Present.pdf
> [92] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [98] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [99] Baburoglu - The Vortical Environment  The fifth in the Emery-Trist Level of Organisational Environments.pdf
> [110] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [113] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [116] Emery - Modern Forms of Laissez Faire Organization.pdf
> [119] Emery 2000 - The Current Version of Emerys Open Systems Theory.pdf
> [123] The Search Conference - Rehm on Emery.pdf
> [124] The Search Conference - Rehm on Emery.pdf


FILE: 'Geoffrey Vickers.md'
---
exported: '2026-01-31T20:06:52.466Z'
source: NotebookLM
type: chat
title: Geoffrey Vickers on 💬Keywords and Jargon
tags:
  - Geoffrey-Vickers
  - Keywords
author: Geoffrey Vickers
---
### Keywords

**Appreciation**, **Appreciative System**, **Reality Judgment**, **Value Judgment**, **Instrumental Judgment**, **Norm-seeking**, **Relationship Maintenance**, **Governance**, **Stability**, **Weltanschauung (Worldview)**, **Soft Systems Methodology (SSM)**, **Responsibility**, **Institutional Behavior**, **Social Cohesion**, **Strategic Conversation**, **Moral Inversion**, **Technical Rationality**, **Lebenswelt (Lifeworld)**, **Accommodation**.

\--------------------------------------------------------------------------------

### Glossary of Key Concepts, Principles, and Theories

**Accommodation**In soft systems thinking, this refers to a state where a group of individuals with different worldviews reach an agreement to act together despite their conflicting interests\[1\]\[2\]. It is contrasted with **consensus**, which implies total agreement\[3\].

**Appreciation**A complex, three-step mental process through which individuals and organizations make sense of their environment\[4\]\[5\]. It involves the simultaneous judgment of facts (**Reality Judgment**) and their significance (**Value Judgment**) to determine an appropriate response (**Instrumental Judgment**)\[6\].

**Appreciative System**A mental and cultural mechanism consisting of categories for classifying and criteria for valuing experience\[9\]. It resides in a "readiness to see and value" situations in characteristic ways, acting as a filter for what is noticed and what is ignored\[9\]\[10\]. This system is recursive, as its settings are both used to make judgments and modified by the resulting experience\[11\]\[12\].

**Constraint and Enablement**A principle stating that all systems both enable action (allowing people to do what they otherwise could not) and constrain it (imposing limitations and responsibilities)\[13\]\[14\]. Vickers argued that the price of increasing enablements in the modern world is a necessary increase in constraints\[15\]\[16\].

**Double-Loop Learning**A learning process where error detection leads not just to a change in action, but to a fundamental modification of the underlying norms, policies, and objectives of the system\[17\].

**Five Levels of Control**A hierarchy of human behavior regulation proposed by Vickers, ranging from **Level 1 (Control by Releaser)** (innate response) to **Level 5 (Control by Self-Determination)** (individual and social ethical debate)\[18\]\[19\].

**Governance**The "art of maintaining stable relationships over time" within human systems\[14\]\[20\]. It is concerned with regulating the system to preserve its form and stability in the face of internal and external changes\[21\]\[22\].

**Human Activity Systems**Purposeful systems consisting of people who interpret the world through their individual worldviews and interact through social processes\[23\].

**Instrumental Judgment**A judgment concerning "what can be done" to reduce the mismatch between the current state of reality and the desired norm\[6\]. It is often described as "strategic choice"\[29\]\[30\].

**Lebenswelt (Lifeworld)**The "interacting flux of events and ideas" that human beings experience through time\[31\]. It serves as the experiential source from which appreciative judgments are formed\[32\].

**Moral Inversion**A cultural phenomenon where moral passion is displaced from the individual onto society and its institutions\[34\]\[35\]. In this state, individuals demand rights but reject the personal responsibility necessary to sustain the institutions providing those rights\[36\]\[37\].

**Norm-seeking**The principle that human regulative behavior is primarily about maintaining standards or "governing relations" through time, rather than just pursuing discrete, once-and-for-all goals\[38\].

**Reality Judgment**A judgment of fact concerning "what is the case" or the state of a system, both internally and in its external relations\[6\]. These judgments are not objective data but are selective and influenced by the observer's concerns\[43\]\[44\].

**Relationship Maintenance**The concept that human activity consists mainly of sustaining satisfactory relationships (with people, objects, or institutions) over time\[25\]. Vickers proposed this as a richer alternative to the "goal-seeking" model of organization\[25\]\[47\].

**Responsibility**The state of having accepted a commitment and the constraints it imposes\[48\]\[49\]. Vickers argued that responsibility—to oneself, one's roles, and the culture at large—is the fundamental regulator of human society\[50\]\[51\].

**Soft Systems Methodology (SSM)**An approach developed by Peter Checkland that uses systems models as epistemological devices to structure a debate about the world, rather than to describe the world as it is\[52\]\[53\]. It focuses on learning rather than optimization\[52\].

**Stability**The state where the key parameters of a system are maintained within critical limits\[14\]. In human systems, stability is the foundation of sustainability and depends on effective governance\[21\].

**Technical Rationality**A way of thinking that emphasizes scientific-analytic logic and a belief in technological progress, often ignoring the contextual, intuitive, and ethical dimensions of human problems\[8\].

**Value Judgment**A judgment concerning "what ought to be" or the significance of facts to the agent\[6\]. It involves comparing reality against norms and standards to determine acceptability\[28\]\[56\].

**Weltanschauung (Worldview)**The set of unexamined assumptions or the "in-built image of the world" that makes a particular human activity system meaningful to an observer\[57\]\[58\]. In SSM, exploring and changing these worldviews is the central task\[58\]\[59\].

---
> [!info]- References
> [1] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [2] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [3] Checkland 2005 - Webs of Significance - the work of Geoffrey Vickers.pdf
> [4] Appreciative systems.pdf
> [5] Appreciative systems.pdf
> [6] Appreciative systems.pdf
> [8] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [9] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [10] ebook_b718_unit7-reading-4.5_the-art-of-judgment_l3.pdf
> [11] Lewis 1991 - The decision making basis for information systems the contribution of Vickers appreciation.pdf
> [12] The Appreciative Cycle.pdf
> [13] [Book] Vickers - Making Institutions Work.pdf
> [14] Blunden 2000 - Enablements and constraints geoffrey vickers and the politics of stability.pdf
> [15] Blunden 2000 - Enablements and constraints geoffrey vickers and the politics of stability.pdf
> [16] Blunden 2005 - Geoffrey Vickers and a systemic approach to globalization.pdf
> [17] Heijden 2008 - Towards a framework to understand purpose in futures studies the role of Vickers Appreciative System.pdf
> [18] 4531518.pdf
> [19] Vickers 1973 - Values Norms and Policies.pdf
> [20] [Book] Vickers - The Vickers Papers.pdf
> [21] Blunden 2000 - Enablements and constraints geoffrey vickers and the politics of stability.pdf
> [22] Williams 2005 - Geoffrey Vickers Philosopher of Responsibility.pdf
> [23] Brocklesby 2007 - The Theoretical Underpinnings of Soft Systems Methodology - Comparing the work of Geoffrey Vickers and Humberto Maturana.pdf
> [25] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [28] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [29] Heijden 2008 - Towards a framework to understand purpose in futures studies the role of Vickers Appreciative System.pdf
> [30] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [31] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [32] Blackmore - Laerning for communication about climate change using Vickers apprecative inquiry.pdf
> [34] Williams 2005 - Geoffrey Vickers Philosopher of Responsibility.pdf
> [35] Williams 2005 - Geoffrey Vickers Philosopher of Responsibility.pdf
> [36] Blunden 2000 - Enablements and constraints geoffrey vickers and the politics of stability.pdf
> [37] [Book] Vickers - The Vickers Papers.pdf
> [38] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [43] Judgment from [Book] Vickers - The Vickers Papers.pdf
> [44] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [47] Vickers - relationship maintenance as an alternative to goal seeking.pdf
> [48] Appreciative systems.pdf
> [49] Williams 2005 - Geoffrey Vickers Philosopher of Responsibility.pdf
> [50] Adams 1994 - Communitarianism vickers and revisioning american public adminstration.pdf
> [51] [Book] Vickers - The Art of Judgment - A Study of policy making.pdf
> [52] The Appreciative Cycle.pdf
> [53] The Appreciative Cycle.pdf
> [56] 4531518.pdf
> [57] Brocklesby 2007 - The Theoretical Underpinnings of Soft Systems Methodology - Comparing the work of Geoffrey Vickers and Humberto Maturana.pdf
> [58] Brocklesby 2007 - The Theoretical Underpinnings of Soft Systems Methodology - Comparing the work of Geoffrey Vickers and Humberto Maturana.pdf
> [59] Brocklesby 2007 - The Theoretical Underpinnings of Soft Systems Methodology - Comparing the work of Geoffrey Vickers and Humberto Maturana.pdf


FILE: 'George Lakoff.md'
---
exported: 2026-02-07T17:22:22.486Z
source: NotebookLM
type: chat
title: George Lakoff on 💬Keywords and Jargon
tags:
  - Keywords
  - George-Lakoff
author: George Lakoff
---
Based on the provided sources, here are the key concepts, principles, and theories extracted from George Lakoff's works (_Don't Think of an Elephant!_, _Metaphors We Live By_, _The Political Mind_, and _Where Mathematics Comes From_).

### Keywords

**Cognitive Science & Philosophy**

• Embodied Cognition / The Embodied Mind

• The Cognitive Unconscious

• Experientialism (Experiential Realism)

• Objectivism (The Myth of)

• Subjectivism (The Myth of)

• Real Reason vs. Enlightenment Reason

**Linguistics & Semantics**

• Conceptual Metaphor

• Source Domain / Target Domain

• Framing

• Prototype Theory

• Radial Categories

• Image Schemas

• Polysemy

• Metonymy

**Political Theory**

• Strict Father Model

• Nurturant Parent Model

• Biconceptualism

• Hypocognition

• Systemic Causation

• Strategic Initiatives

• Privateering

**Mathematics**

• Mathematical Idea Analysis

• The 4Gs (Grounding Metaphors)

• The Basic Metaphor of Infinity (BMI)

• Arithmetization

• Discretization

• Closure

\--------------------------------------------------------------------------------

### Glossary of Key Concepts

General Cognitive Theory & Philosophy

• **Cognitive Unconscious:** The principle that approximately 98 percent of human thought (reasoning, inferences, structuring of concepts) is unconscious, automatic, and effortless. It contradicts the Enlightenment view that reason is fully conscious and controllable\[1\].

• **Embodied Cognition:** The theory that human concepts and reason are not abstract or transcendent but are shaped by the detailed nature of our bodies, brains, and everyday functioning in the world. Even abstract concepts are grounded in sensory-motor experiences\[1\].

• **Experientialism (Experiential Realism):** The philosophical alternative to Objectivism proposed by Lakoff. It posits that truth and meaning are not properties of an objective world independent of a knower, but arise from the interaction between an organism (with a specific body and brain) and its environment\[7\].

• **Objectivism (The Myth of):** The traditional philosophical view that the world consists of distinct objects with inherent properties and fixed relations, independent of human understanding. Lakoff argues this view fails to account for how human beings actually conceptualize the world via metaphor and prototypes\[7\].

• **Real Reason:** A view of rationality that acknowledges it is embodied, mostly unconscious, metaphorical, and emotional, as opposed to the "Old Enlightenment" view of reason as literal, disembodied, and purely logical\[12\].

Metaphor, Language, and Categorization

• **Conceptual Metaphor:** The mechanism by which we understand one conceptual domain (the **Target Domain**, usually abstract) in terms of another (the **Source Domain**, usually concrete). For example, understanding "Argument" in terms of "War"\[15\].

• **Framing:** The mental structures (frames) that shape how we see the world. Frames define problems and solutions; they are activated by language. To be accepted, truth must fit people's frames; if facts do not fit a frame, the facts are often rejected\[4\].

• **Image Schemas:** Simple, preconceptual structures (like CONTAINER, SOURCE-PATH-GOAL, LINK) that recur in everyday bodily experience and structure our abstract reasoning via metaphor\[20\].

• **Metonymy:** A cognitive process where one entity stands for another entity in the same domain (e.g., "The ham sandwich is waiting for his check," where the sandwich stands for the customer). It is a primary source of prototype effects\[23\]\[24\].

• **Prototypes:** The central or "best" examples of a category. Unlike classical categories defined by necessary and sufficient conditions, human categories (like "bird" or "chair") have a graded structure where some members are more central than others\[25\].

• **Radial Categories:** Complex categories that have a central subcategory and noncentral extensions that are motivated by (but not predictable from) the center (e.g., the category "Mother," which has a central biological model and extensions like "stepmother" or "adoptive mother")\[28\]\[29\].

Political Theory

• **Biconceptualism:** The phenomenon where a person possesses both conservative and progressive neural circuits (frames) in their brain, applying different moral systems to different issues (e.g., a "strict" view on foreign policy but a "nurturant" view on the environment)\[25\].

• **Hypocognition:** The lack of the ideas or frames needed to understand or express a concept. It is the absence of a relatively simple fixed frame that can be evoked by a word or two (e.g., progressives lacking a unified frame for "freedom" compared to conservatives)\[32\].

• **Nurturant Parent Model:** The moral worldview underlying progressive politics. It emphasizes empathy, responsibility for oneself and others, gender neutrality, and cooperation. It views the government's role as protecting and empowering citizens\[30\].

• **Privateering:** A frame constructed by Lakoff to describe the systematic destruction of the government's capacity to carry out moral missions, while using public funds to enrich private corporations (a specific, exploitative type of privatization)\[35\]\[36\].

• **Strict Father Model:** The moral worldview underlying conservative politics. It emphasizes authority, discipline, hierarchy, and the pursuit of self-interest. It views the world as dangerous and competitive, requiring a strong father figure to enforce morality\[34\].

• **Systemic Causation:** A mode of thought that recognizes outcomes as the result of complex, interacting systems (e.g., the environment, the economy) rather than the direct actions of individual actors. This contrasts with **Direct Causation**\[40\].

Mathematics

• **Basic Metaphor of Infinity (BMI):** A conceptual metaphor that allows the mind to conceptualize processes that go on indefinitely (like counting) as having a unique final resultant state (actual infinity). It projects the structure of completed processes onto unending ones\[43\]\[44\].

• **Conceptual Blending:** The cognitive mechanism of combining two distinct cognitive structures with fixed correspondences to create a new structure with emergent properties (e.g., the "Number Line" blends the concept of numbers with the concept of a geometric line)\[45\]\[46\].

• **Discretization:** The cognitive process (seen in the history of mathematics) of conceptualizing naturally continuous concepts (like space or motion) in terms of discrete entities (like sets of points) to apply arithmetic and logic to them\[47\]\[48\].

• **The 4Gs (Grounding Metaphors):** The four basic metaphors that ground arithmetic in physical experience: 1) Arithmetic Is Object Collection, 2) Arithmetic Is Object Construction, 3) The Measuring Stick Metaphor, and 4) Arithmetic Is Motion Along a Path\[49\]\[50\].

• **Mathematical Idea Analysis:** The discipline proposed by Lakoff and Núñez to analyze the cognitive structure of mathematical concepts, showing how they are grounded in sensory-motor experience and structured by metaphor\[51\]\[52\].

---
> [!info]- References
> [1] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [4] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [7] [Book] Lakoff - Metaphors We Live By.pdf
> [12] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [15] [Book] Lakoff - Metaphors We Live By.pdf
> [20] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [23] [Book] Lakoff - Metaphors We Live By.pdf
> [24] [Book] Lakoff - Women, Fire, and Dangerous Things What Categories Reveal about the Mind.pdf
> [25] [Book] Lakoff - Metaphors We Live By.pdf
> [28] [Book] Lakoff - Women, Fire, and Dangerous Things What Categories Reveal about the Mind.pdf
> [29] [Book] Lakoff - Women, Fire, and Dangerous Things What Categories Reveal about the Mind.pdf
> [30] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [32] [Book] Lakoff - Dont Think of an Elephant Know Your Values and Frame the Debate--The Essential Guide for Progressives.pdf
> [34] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [35] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [36] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [40] [Book] Lakoff - The Political Mind A Cognitive Scientists Guide to Your Brain and Its Politics.pdf
> [43] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [44] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [45] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [46] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [47] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [48] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [49] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [50] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [51] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf
> [52] [Book] Lakoff - Where Mathematics Come From How The Embodied Mind Brings Mathematics Into Being.pdf


FILE: 'Gregory Bateson.md'
---
exported: '2026-01-31T20:15:51.333Z'
source: NotebookLM
type: chat
title: Gregory Bateson on 💬Keywords and Jargon
tags:
  - Keywords
author: Gregory Bateson
---
The following list identifies the **foundational keywords** and a detailed **glossary of concepts, principles, and theories** as defined in the sources provided.

### Key Keywords

• **Abduction**\[1\]

• **Biosemiotics**\[4\]\[5\]

• **Circular Causality**\[6\]\[7\]

• **Creatura**\[8\]

• **Difference**\[11\]

• **Double Bind**\[15\]

• **Double Description**\[2\]

• **Ecology of Mind**\[20\]

• **Epistemology**\[23\]

• **Feedback**\[14\]

• **Logical Types**\[28\]

• **Pleroma**\[8\]

• **Recursion**\[14\]

• **Schismogenesis**\[32\]\[33\]

• **Stochastic Process**\[34\]\[35\]

• **Systemic Wisdom**\[25\]\[36\]

\--------------------------------------------------------------------------------

### Attached Glossary

• **Abduction:** A third inferential mode of reasoning (distinct from induction and deduction) that identifies **similar patterns or formal rules** across different realms of phenomena\[2\]. It is the "lateral extension" of abstract components of description to find the "pattern which connects"\[38\]\[39\].

• **Autocatalysis:** A process in which a system’s products serve as catalysts for its own continued production, often cited as a **bridge between physics and life**\[10\].

• **Biosemiotics:** An emerging field proposing that all living systems (animals, plants, and cells) engage in **semiosis**, the conversion of physical signals into meaningful signs\[4\]\[42\].

• **Circular Causality:** A cybernetic principle where cause and effect are not linear but part of a **feedback loop**; the system is self-corrective and its stability depends on the product of transformations around the circuit\[6\].

• **Creatura:** The world of the living and mental, governed and determined by **difference, distinction, and information**, rather than by force and impact\[8\].

• **Difference:** The elementary unit of information, described as "**a difference which makes a difference**"\[13\]. It is a non-substantial phenomenon not located in space or time\[46\]\[47\].

• **Double Bind:** A communicative situation where an individual is caught between **contradictory injunctions** at different logical levels, making any choice a source of punishment or failure\[15\]. It is characteristic of multiply coupled and embedded systems\[16\]\[48\].

• **Double Description:** A method of analysis that juxtaposes **two or more sources of information** to generate an insight of a higher logical type that neither source possessed alone (e.g., binocular vision creating depth)\[2\].

• **Ecology of Mind:** The insight that the organization of ecological systems is formally analogous to the organization of **mental processes**\[20\]. It views "mind" not as a thing, but as a pattern immanent in the complete message circuit of an organism and its environment\[50\].

• **Eidos:** The standardization of a culture’s **cognitive and informational aspects**, including its logical structures and systems of inference\[53\].

• **Epistemology:** For Bateson, this is the study of **how organisms know, think, and decide**; it is the interaction of the capacity to respond to difference with the material world\[23\].

• **Ethos:** The standardization of a culture’s **affective and emotional aspects**, referring to the "characteristic spirit" or prevalent tone of sentiment in a community\[53\].

• **Feedback (Negative vs. Positive):** Negative feedback is a self-corrective process towards **homeostasis** (stability)\[51\]\[59\]. Positive feedback is a regenerative process leading to **runaway** or escalation\[7\].

• **Heterarchy:** A non-transitive, network-like distribution of organizational layers (e.g., genetic, epigenetic, and environmental) where different levels coordinate rather than follow a strict top-down command\[61\]\[62\].

• **Information:** "News of a difference" sensed by a biological system\[13\]. It is defined as **improbability or restraint** within a circuit\[27\].

• **Logical Types:** A theory derived from Russell and Whitehead stating that there is a **discontinuity between a class and its members**\[28\]. Confusing these levels leads to paradox and pathology\[67\]\[68\].

• **Map and Territory:** The principle that a **representation (map) is not the thing it represents (territory)**; information is not energy, and descriptions are not the world itself\[47\].

• **Pleroma:** The world of non-living matter and physical forces described by physics and chemistry, in which there are **no descriptions or differences** that act as causes\[8\].

• **Recursion:** The process by which events or information **re-enter the system** that produced them, allowing for reflexivity and self-organization\[14\].

• **Schismogenesis:** A process of differentiation in behavior resulting from **cumulative interaction** between individuals\[32\]. It can be **symmetrical** (rivalry) or **complementary** (dominance/submission)\[73\]\[74\].

• **Stochastic Process:** A process that combines **randomness with selectivity**, allowing only certain outcomes to endure; it describes both biological evolution and human learning\[34\].

• **Tautology:** An aggregate of linked propositions where the **validity of the links** cannot be doubted, though the truth of the original premises is not claimed (e.g., Euclidean geometry)\[75\]\[76\].

---
> [!info]- References
> [1] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [2] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [4] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [5] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [6] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [7] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [8] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [10] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [11] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [13] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [14] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [15] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [16] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [20] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [23] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [25] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [27] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [28] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [32] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [33] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [34] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [35] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [36] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [38] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [39] Batesons serach for patterns which connect Ecology and Mind - his thinking on metaphors.pdf
> [42] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [46] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [47] Batesons Process Ontology for Psychological Practice.pdf
> [48] A Legacy for Living Systems - Gregory Bateson as Precursor to Biosemiotics.pdf
> [50] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [51] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [53] 656342.pdf
> [59] Gregory Bateson Niklas Luhmann and Ecology.pdf
> [61] Bioentropy aesthetics and meta-dualism the transdisciplinary ecology of Gregory Bateson.pdf
> [62] Diminishing Dualism - Gregory Bateson and the case for Heterarchy.pdf
> [67] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [68] Bateson 1972 - Llogical categories of learning and communication.pdf
> [73] (Biosemiotics 2) Associate Professor Jesper Hoffmeyer (auth.), Associate Professor Jesper Hoffmeyer (eds.) - A Legacy for Living Systems_ Gregory Bateson as Precursor to Biosemiotics-Springer Netherla.pdf
> [74] [Book] Gregory Bateson - Steps to an Ecology of Mind.pdf
> [75] Bioentropy aesthetics and meta-dualism the transdisciplinary ecology of Gregory Bateson.pdf
> [76] Harries-Jones Peter - A Recursive Vision Ecological Understanding and Gregory Bateson 1995.pdf


FILE: 'Harish Jose.md'
---
exported: 2026-02-09T20:56:46.818Z
source: NotebookLM
type: chat
title: "Key Keywords• Cybernetics: Autopoiesis1, Second-Or..."
tags:
  - Harish-Jose
  - Keywords
---
### **Key Keywords**

• **Cybernetics:** Autopoiesis\[1\], Second-Order Cybernetics\[2\], Law of Requisite Variety\[3\]\[4\], Informational Closure\[5\]\[6\], Transduction\[7\], Re-entry\[8\]\[9\].

• **Systems Thinking:** Emergence\[10\]\[11\], Systems Approach\[12\]\[13\], Boundaries\[13\], POSIWID\[16\]\[17\].

• **Lean / Toyota Production System (TPS):** Kaizen\[18\]\[19\], Jidoka\[20\]\[21\], Just-in-Time (JIT)\[22\]\[23\], Gemba (Genchi Genbutsu)\[24\], Respect for Humanity\[28\].

• **Philosophy:** Existentialism\[31\]\[32\], Pragmatism\[33\], Constructivism\[36\], Phenomenology\[39\]\[40\].

• **Complexity:** Nonlinearity\[11\], Complex Adaptive Systems (CAS)\[43\]\[44\], Ambiguity\[45\]\[46\].

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**Abduction (Batesonian):** A reasoning process focused on pattern recognition across contexts and "double descriptions" to understand systemic relationships rather than linear cause-and-effect\[47\].

**Autopoiesis:** A term for "self-generation" describing living systems that produce and maintain their own components and identity through a continual recursive process\[1\]\[50\].

**Boundaries:** Artificial distinctions drawn by an observer to separate a "system" from its "environment"; these are not objective features but depend on the observer's purpose and values\[51\].

**Complex Adaptive Systems (CAS):** Open, non-linear systems composed of heterogeneous, autonomous agents that adapt to their environment through local interactions without a central controller\[43\]\[54\].

**Constructivism:** The philosophical stance that reality is not passively perceived but actively constructed by an observer based on their biological structure, history, and social interactions\[36\].

**Double-Loop Learning:** A process involving a reflective phase that challenges and modifies underlying mental models and policies to correct errors, rather than just adjusting actions within existing rules\[56\].

**Gemba (Genchi Genbutsu):** The "actual place" where value is created or action occurs; the principle of "going and seeing" to grasp first-hand facts before making decisions\[25\].

**Informational Closure:** The cybernetic principle that cognitive systems do not "receive" information from the outside; instead, they are internally closed and interpret external disturbances (perturbations) as informative based on their own internal structure\[5\].

**Jidoka:** Often called "autonomation," it is the principle of building quality into a process by ensuring that a system or machine stops automatically when an abnormality is detected\[20\]\[21\].

**Kaizen:** Incremental and continuous improvement toward an ideal state; it is viewed as a "thinking system" for developing human potential rather than just a set of cost-cutting tools\[18\].

**Law of Requisite Variety (Ashby’s Law):** A fundamental law stating that "only variety can absorb variety," meaning a regulator or controller must possess as much internal variety (flexibility/responses) as the variety of disturbances coming from the environment\[3\].

**POSIWID:** An acronym for "The Purpose of a System is What it Does," a principle used to cut through stated intentions and focus on the actual, observable patterns of behavior produced by a system\[16\].

**Re-entry:** In Spencer-Brown’s logic, the act of a distinction folding back on itself, creating a self-referential or recursive loop that allows a system to observe its own act of observing\[8\].

**Second-Order Cybernetics:** The "cybernetics of cybernetics" or the study of observing systems; it includes the observer in the description of the system and emphasizes responsibility for the realities we construct\[2\].

**Transduction:** The process by which an external signal is transformed and made sense of by an observer; it highlights that meaning is enacted internally rather than extracted from the environment\[7\].

**Ultrastability:** The capacity of a system to maintain its viability by using feedback to change its internal organization or behavior fields when essential variables are threatened by environmental shifts\[70\]\[71\].

**Variety Engineering:** The management of complexity by either attenuating (filtering) overwhelming external variety or amplifying internal variety to match the environmental demands\[3\].

\--------------------------------------------------------------------------------

Is there a specific domain—like the **cybernetics of management** or the **philosophical roots of Lean**—that you would like to map out further?

---
> [!info]- References
> [1] Harish Jose.md
> [2] Harish Jose.md
> [3] Harish Jose.md
> [4] Harish Jose.md
> [5] Harish Jose.md
> [6] Harish Jose.md
> [7] Harish Jose.md
> [8] Harish Jose.md
> [9] Harish Jose.md
> [10] Harish Jose.md
> [11] Harish Jose.md
> [12] Harish Jose.md
> [13] Harish Jose.md
> [16] Harish Jose.md
> [17] Harish Jose.md
> [18] Harish Jose.md
> [19] Harish Jose.md
> [20] Harish Jose.md
> [21] Harish Jose.md
> [22] Harish Jose.md
> [23] Harish Jose.md
> [24] Harish Jose.md
> [25] Harish Jose.md
> [28] Harish Jose.md
> [31] Harish Jose.md
> [32] Harish Jose.md
> [33] Harish Jose.md
> [36] Harish Jose.md
> [39] Harish Jose.md
> [40] Harish Jose.md
> [43] Harish Jose.md
> [44] Harish Jose.md
> [45] Harish Jose.md
> [46] Harish Jose.md
> [47] Harish Jose.md
> [50] Harish Jose.md
> [51] Harish Jose.md
> [54] Harish Jose.md
> [56] Harish Jose.md
> [70] Harish Jose.md
> [71] Harish Jose.md


FILE: 'Harold Nelson.md'
---
exported: 2026-02-07T16:12:41.913Z
source: NotebookLM
type: chat
title: Harold Nelson on 💬Keywords and Jargon
tags:
  - Harold-Nelson
  - Keywords
author: Harold Nelson
---
Based on the provided sources, here are the key concepts, principles, and theories organized into keywords and a detailed glossary.

### **Keywords**

**Foundations of Design**

• The First Tradition

• The Third Culture of Inquiry

• The Ultimate Particular

• Desiderata

• Service Relationship

• The Real, The True, and The Ideal

• _Phronesis_ (Practical Wisdom)

**Systemics and Complexity**

• Systemic Design (vs. Systems Design)

• Wicked Problems

• Emergence (Compositional vs. Created)

• The Whole (Holism)

• Requisite Variety

• Leverage Points

• Interconnectedness / Entanglement

**Design Cognition and Epistemology**

• Design Judgment (Appreciative, Instrumental, Framing)

• Intermediate-Level Knowledge (Strong Concepts)

• Reflection-in-Action

• Sensemaking

• Comprehensivity

• Mistake Mystique

• Designerly Ways of Knowing

**Methodologies and Frameworks**

• Systemic Model of the Design Situation (Design / For / Within)

• Giga-mapping / Synthesis Mapping

• Dialogic Design

• Affordances

• Concept-Driven Research

• Research through Design

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**Affordances**Functional and relational aspects of an object that frame, without determining, the possibilities for action in relation to that object. In the context of technology, affordances push, pull, enable, and constrain how objects shape action for socially situated subjects\[1\],\[2\].

**Appreciative Judgment**A concept derived from Geoffrey Vickers, referring to the capacity to understand a situation by discerning what is background (reality judgments/facts) and what is foreground (value judgments/norms). It is the mental setting through which designers perceive and interpret the "flux" of reality to make design decisions\[3\],\[4\],\[5\].

**Comprehensivity**The ability to comprehend the world broadly and deeply. It is a facility in questioning, conceptualizing, interpreting, and acting to build a multi-perspectival, integrated understanding of how the world works. It strives for learning that is “macro-comprehensive and micro-incisive”\[6\],\[7\].

**Desiderata**The "inclusive whole" of desires, needs, and intentions. Unlike "problems," which trigger reactive behavior, desiderata trigger proactive design behavior. It is the impulse to move toward an ideal or desired state rather than just away from a negative state\[8\],\[9\].

**Design Judgment**The decision-making faculty used in design to navigate complexity and uncertainty where no "correct" answer exists (unlike logic or math). It relies on "knowing" that is inseparable from the "knower" and includes framing, compositional, and navigational judgments\[10\],\[11\],\[12\].

**The First Tradition**The assertion that design is the oldest and most distinct tradition of human inquiry and action, predating and distinct from the traditions of Science (the True) and Art/Humanities (the Beautiful). It is inquiry for the sake of action\[13\],\[14\],\[15\].

**Giga-mapping**A visual mapping technique used in Systemic Design to cope with fragmented data and complexity. It involves creating an "information cloud" or extensive map across multiple layers and scales to help designers grasp real-life problems and boundary critiques\[16\],\[17\].

**Guarantor-of-Design (g.o.d.)**A metaphysical concept referring to the source of confidence or authority a designer relies upon to justify their actions in the absence of absolute truth. Since design creates the "not-yet-existing," it lacks the proofs of science; the designer must find a guarantor (internal or external) to bridge the gap between conjecture and action\[18\],\[19\].

**Intermediate-Level Knowledge / Strong Concepts**A form of design knowledge that resides between specific design instances (particular artifacts) and generalized theories. "Strong Concepts" are generative design ideas that cut across application domains and speak of interactive behavior rather than static appearance (e.g., "social navigation")\[20\],\[21\],\[22\].

**Leverage Points**Places within a complex system where a small shift in one thing can produce big changes in everything. Identifying these points is a primary goal of systemic intervention\[23\],\[24\].

**Mistake Mystique**A concept from Buckminster Fuller referring to the value of attending to errors and gaps in understanding. It views mistakes not as failures but as essential feedback for refining ignorance and advancing comprehension\[25\],\[26\].

**Requisite Variety**A principle from cybernetics (Ashby) stating that the internal diversity (variety) of a control system must match or exceed the variety of the system it wishes to regulate. In design, it implies that a design solution must be sufficiently complex to handle the complexity of the environment it inhabits\[27\],\[28\].

**Service Relationship**The fundamental social contract of design. Unlike art (self-expression) or science (objective observation), design is an intentional relationship where the designer acts on behalf of a "client" (the other) to help bring their desiderata into reality. It is distinct from "helping" or "fixing"\[29\],\[30\],\[31\].

**Strong Concepts**_See Intermediate-Level Knowledge._

**Systemic Design (vs. Systems Design)**

• **Systemic Design:** A design field where systems thinking and theory are integrated with advanced design methods to effect change in complex social/sociotechnical systems. It is "design-led" and focuses on wicked problems\[32\],\[33\].

• **Systems Design:** Often refers to systems engineering or the design of systems as objects (e.g., software architecture)\[32\].

**Systemic Model of the Design Situation**A framework proposed by Sigrun Lurås that divides the design context into three intertwined systems to help designers manage complexity:

1\. **The System We Design:** The specific artifact or intervention.

2\. **The System We Design** **For****:** The context of use and the situation seeking change.

3\. **The System We Design** **Within****:** The framework conditions (resources, culture, regulations) that limit and enable the design team\[34\],\[35\].

**Teleological Systems**Systems that are purpose-driven or goal-oriented. Design deals primarily with teleological systems (human activity systems) rather than natural systems (which may have function but not "purpose" in the human sense)\[36\],\[37\].

**The Ultimate Particular**The specific, unique outcome of a design process. While science seeks the "universal" (what is true everywhere) and the "general," design aims for the "ultimate particular"—a specific composition of elements unique to a specific time, place, and situation\[38\],\[39\].

**Wicked Problems**A class of problems (defined by Rittel & Webber) that are indeterminate, have no definitive formulation, no stopping rule, and no true/false solution—only "better or worse." They are the core domain of systemic design\[40\],\[41\],\[42\].

---
> [!info]- References
> [1] Clarke - Thesis - Its not rocket science.pdf
> [2] Intro - How Artifacts Afford.pdf
> [3] Design judgement.pdf
> [4] Luras - Systems Intertwined a systemic view of the design situation.pdf
> [5] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [6] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [7] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [8] Design as Being in Service.pdf
> [9] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [10] Design as Being in Service.pdf
> [11] Design judgement.pdf
> [12] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [13] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [14] Nelson - The Design Way Chapt 1.pdf
> [15] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [16] Jones - Systemic Design Systems Handbook.pdf
> [17] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [18] Nelson - Systemic Design as Born from the Berkeley Bubble Matrix.pdf
> [19] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [20] Lowgren - Strong Concepts - Intermediate Level Knowedge in Interaction Design Research.pdf
> [21] Lowgren - Strong Concepts - Intermediate Level Knowedge in Interaction Design Research.pdf
> [22] Wakkary - unselfconscious.pdf
> [23] Jones Editorial Contexts Engaged Design Scholarship in Contexts A Journal of Applied Complexity.pdf
> [24] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [25] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [26] Collaborating for Comprehensivity by CJ Fearnley.pdf
> [27] Jones - Systemic Design Systems Handbook.pdf
> [28] Jones - Systemic Design Systems Handbook.pdf
> [29] Design as Being in Service.pdf
> [30] Nelson - Design as Being in Service.pdf
> [31] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [32] Jones - Systemic Design Systems Handbook.pdf
> [33] Nelson - Systemic Design as Born from the Berkeley Bubble Matrix.pdf
> [34] Luras - Systems Intertwined a systemic view of the design situation.pdf
> [35] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf
> [36] Nelson 2003 - The Legacy of C West Churchman.pdf
> [37] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [38] Clarke - Thesis - Its not rocket science.pdf
> [39] [Book] Nelson - The Design Way intentional change in an unpredictable world.pdf
> [40] Clarke - Thesis - Its not rocket science.pdf
> [41] Jones - Systemic Design Systems Handbook.pdf
> [42] mafiadoc.com_systemic-design-in-complex-contexts_59f6fecb1723dd464e46a48f.pdf


FILE: 'Herb Simon.md'
---
exported: '2026-01-31T20:22:32.925Z'
source: NotebookLM
type: chat
title: Herb Simon on 💬Keywords and Jargon
tags:
  - Herb-Simon
  - Keywords
author: Herb Simon
---
Based on the provided sources, the following are the key concepts, principles, and theories organized as keywords and a comprehensive glossary.

### **Keywords**

**Bounded Rationality**\[1\], **Satisficing**\[4\]\[5\], **Hierarchy**\[6\], **Near-Decomposability**\[6\], **Heuristic Search**\[11\]\[12\], **Means-Ends Analysis**\[13\]\[14\], **Science of Design**\[15\], **Ill-Structured Problems (ISP)**\[18\], **Diagrammatic Representation**\[21\]\[22\], **Artifact**\[23\]\[24\], **Procedural Rationality**\[25\]\[26\], **Watchmaker Parable**\[27\]\[28\].

\--------------------------------------------------------------------------------

### **Glossary**

• **Architecture of Complexity:** The principle that complex systems in nature and society are generally **hierarchic**, consisting of subsystems that further divide into smaller parts until a basic elementary level is reached\[29\].

• **Artifact:** An object or phenomenon that is **man-made** as opposed to natural, characterized by being molded by human goals or purposes to its environment\[32\].

• **Bounded Rationality:** The principle that human rationality is limited by the **mind’s capacity** to formulate and solve complex problems, which is small compared to the size of real-world problems\[2\].

• **Chunk:** A familiar unit of information stored in memory (e.g., a word or chess pattern). **Short-term memory** is limited to approximately seven (or five) chunks\[21\].

• **Computational Efficiency:** The relative ease and speed with which an information-processing system can find a solution, often depending on the **representation** of the data (e.g., diagrams vs. text)\[1\].

• **Diagrammatic Representation:** A method of organizing information by **location in a plane**, which often makes information explicit and reduces search costs compared to sequential text\[21\].

• **Docility:** The human propensity to depend on social influence and to accept information and advice from others, which is critical for **organizational identification**\[42\]\[43\].

• **Heuristic Search:** A selective **trial-and-error process** guided by "rules of thumb" (heuristics) that allows a system to explore only a tiny fraction of a massive problem space\[11\].

• **Ill-Structured Problem (ISP):** A problem that lacks a definite criterion for testing a solution or a well-defined set of generators for alternatives. Most "real-life" design tasks are initially ill-structured\[18\].

• **Inner vs. Outer Environment:** An artifact is an **interface** between an inner environment (the substance and organization of the artifact itself) and an outer environment (the surroundings in which it must operate to achieve a goal)\[24\].

• **Means-Ends Analysis:** A problem-solving heuristic where the system identifies **differences** between the current state and the goal state and selects **operators** (actions) relevant to reducing those differences\[13\].

• **Near-Decomposability:** A property of hierarchic systems where interactions **within** a subsystem are much stronger and faster than interactions **between** subsystems. This allows for the simplification of the system’s behavior for analysis\[6\].

• **Procedural Rationality:** Rationality viewed from the standpoint of the **process** or deliberation used to reach a decision, rather than just the substantive result\[25\].

• **Satisficing:** A decision-making strategy that seeks an alternative that is **"good enough"** relative to an aspiration level, rather than searching for the absolute optimum\[4\].

• **Science of Design:** A body of analytic and formalizable doctrine concerned with how things **ought to be** to attain goals, distinct from natural sciences which focus on how things _are_\[16\].

• **Sentential Representation:** Information organized as a **sequence** of propositions (like text), requiring linear search to locate matching conditions for problem solving\[21\].

• **Watchmaker Parable:** A story of two watchmakers (Hora and Tempus) used to illustrate that systems composed of **stable subassemblies** (hierarchies) evolve much faster than those built from scratch without intermediate stable forms\[27\].

---
> [!info]- References
> [1] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf
> [2] [Book] Simon - Administrative Behavior.pdf
> [4] [Book] Simon - Administrative Behavior.pdf
> [5] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [6] Simon - Can there be a science of complex systems.pdf
> [11] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf
> [12] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [13] [Book] Simon - Models of Discovery And Other Topics in the Methods of Science.pdf
> [14] [Book] Simon - Human Problem Solving.pdf
> [15] Simon - Design and problem solving.pdf
> [16] Simon - Panmorphic crisis.pdf
> [18] Simon - The Structure of Ill Structured Problems.pdf
> [21] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf
> [22] Larkin Simon 87 - Why a diagram is sometimes worth ten thousand words.pdf
> [23] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [24] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [25] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [26] simon on bounded rationality.pdf
> [27] Simon - the organization of complex systems.pdf
> [28] Simon 2002 - Near decomposability and the speed of evolution.pdf
> [29] Simon - managerial decision making.pdf
> [32] [Book] Simon - The Sciences of the Artificial, 3rd Edition.pdf
> [42] [Book] Simon - Reason in Human Affairs.pdf
> [43] [Book] Simon - Administrative Behavior.pdf


FILE: 'Horst Rittel.md'
---
exported: 2026-02-07T17:22:50.740Z
source: NotebookLM
type: chat
title: Horst Rittel on 💬Keywords and Jargon
tags:
  - Keywords
  - Horst-Rittel
author: Horst Rittel
---
Based on the provided source materials, here are the key concepts, principles, and theories extracted in the form of keywords, followed by a glossary defining them within the context of Klaus Krippendorff’s and Horst Rittel’s work.

### **Keywords**

• **Epistemology & Cybernetics:** Constructivism, Second-Order Cybernetics, Recursive Understanding, Self-Reference, Viability, Trivial vs. Non-Trivial Machines.

• **Methodology:** Content Analysis, Abductive Inference, Data Making, Analytical Constructs, Context/Environment, Reliability (Replicability), Semantic Validity.

• **Design & Planning:** The Semantic Turn, Human-Centered Design, Wicked Problems, Affordances, Argumentation, Second-Order Understanding.

• **Communication & Ethics:** Otherness, I-Thou Relations, Dialogue, Emancipation, Re-entry.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**Foundational Theories**

**Constructivism**The epistemological premise that reality is not discovered as an independent fact but is brought forth through human communication, language, and observation. "We are creating systems by describing a portion of the world in that way"\[1\].

**Second-Order Cybernetics (Cybernetics of Cybernetics)**A shift from observing systems (first-order) to observing the _observers_ of systems. It requires the inclusion of the observer within the domain of observation\[2\],\[3\]. In this view, "systems evolve in interaction between Observer and reality which co-determine one another"\[3\].

**Recursive Understanding (Re-entry)**The principle that social theories are not just descriptions of static objects but communications that enter the society they describe, altering it. "Social theories can be said to re-enter the very practices they claim to describe and change their truths right in front of the theorists' eyes"\[4\],\[5\].

**Wicked Problems**A class of problems in planning and design that cannot be definitively formulated or solved. Unlike "tame" problems (like chess or equations), wicked problems have "no stopping rule," and solutions are not true-or-false, but "good-or-bad"\[6\],\[7\]. Every solution to a wicked problem is a "one-shot operation" leaving traces that cannot be undone\[8\].

**The Semantic Turn**A paradigm shift in design moving from technology-centeredness (focusing on function and manufacture) to human-centeredness (focusing on meaning). It is based on the axiom: "Humans do not see and act on the physical qualities of things, but on what they mean to them"\[9\],\[10\].

**Methodological Principles**

**Content Analysis**Defined as "a research technique for making replicable and valid inferences from texts (or other meaningful matter) to the contexts of their use"\[11\]. It rejects the container metaphor (that content is "inside" the text) in favor of making inferences about unobserved phenomena\[12\],\[13\].

**Abductive Inference**The specific logic used in content analysis, distinct from induction or deduction. It involves moving from one empirical domain (text/data) to another logically distinct domain (context) via an analytical construct\[14\],\[15\]. It is reasoning from "particulars to particulars"\[16\].

**Analytical Construct**A model or set of rules derived from known stable correlations in the context. It bridges the gap between the available text and the target of the inference (the answer to the research question)\[17\],\[18\].

**Data Making**The recognition that data are not "found" in nature but are created by the researcher through specific procedures of unitizing (making distinctions) and sampling. Data are the "primitives" for analysis, but they must be constructed to be analyzable\[19\],\[20\].

**Semantic Validity**The extent to which the categories and analytical constructs used in research accurately describe meanings and uses within the chosen context. It checks whether the "analytical categories accurately describe meanings in the chosen context"\[21\],\[22\].

**Concepts of Interaction and Design**

**Affordances**Borrowed from J.J. Gibson, this refers to what the environment "offers the animal, what it provides or furnishes, either for good or ill"\[23\]. In design, it refers to the perceived possibilities for action that an artifact presents to a user\[24\],\[25\].

**Trivial vs. Non-Trivial Machines**A distinction used to critique behavioral research. A **trivial machine** yields the same output for the same input (historical independence). A **non-trivial machine** (like a human being) has internal states that change, making its output historically dependent and unpredictable\[26\]. Treating humans as trivial machines is an "inhuman theory"\[27\].

**I-Thou vs. I-It Relations**Derived from Martin Buber, this distinguishes between treating the "Other" as an object for manipulation (I-It) or as a partner in dialogue (I-Thou). In I-Thou relations, understanding means "bootstrapping oneself in the presence of the radical otherness of Others"\[28\],\[29\].

**Second-Order Understanding (in Design)**The ability of a designer to understand the understanding of others (stakeholders). It contrasts with the "God's eye view" of first-order understanding. It involves making room for stakeholders' different worlds and logics\[30\],\[31\].

**Context (Environment)**The "surrounding conditions, antecedent, coexisting, or consequent" to the text or data\[32\],\[20\]. While data are available to the analyst, the context is not; it must be constructed by the analyst to make the data meaningful\[33\].

---
> [!info]- References
> [1] On Systems Thinking - Krippendorff.pdf
> [2] Krippendorff - The Dialogic Reality of Meaning.pdf
> [3] On Systems Thinking - Krippendorff.pdf
> [4] Krippendorff - A second-order Cybernetics of Otherness.pdf
> [5] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [6] Rittel-Dilemmas-General-Theory-Planning-1973.pdf
> [7] Rittel-Dilemmas-General-Theory-Planning-1973.pdf
> [8] Rittel-Dilemmas-General-Theory-Planning-1973.pdf
> [9] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [10] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [11] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [12] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [13] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [14] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [15] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [16] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [17] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [18] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [19] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [20] [Book] Krippendorff - Content Analysis an introduction to its methodology.pdf
> [21] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf
> [22] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [23] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [24] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [25] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [26] Krippendorff - A second-order Cybernetics of Otherness.pdf
> [27] Krippendorff - A second-order Cybernetics of Otherness.pdf
> [28] Krippendorff - A second-order Cybernetics of Otherness.pdf
> [29] [Book] Krippendorff - On Communicating Otherness, Meaning, and Information.pdf
> [30] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [31] [Book] Krippendorff - The Semantic Turn a new foundation for design.pdf
> [32] Krippendorff - The Dialogic Reality of Meaning.pdf
> [33] [Book] Krippendorff - Content Analysis An Introduction to Its Methodology.pdf


FILE: 'Humberto Maturana.md'
---
exported: '2026-02-01T00:12:23.041Z'
source: NotebookLM
type: chat
title: Humberto Maturana on 💬Keywords and Jargon
tags:
  - Humberto-Matruana
  - Keywords
author: Humberto Maturana
---

Based on the provided sources, particularly the works of Humberto Maturana, Francisco Varela, and their commentators (such as Mingers, Paucar-Caceres, and Reynolds), here are the key concepts, principles, and theories organized into keywords and a detailed glossary.

### **Keywords**

• **Core Systems Theory:** Autopoiesis, Allopoietic Systems, Organization vs. Structure, Structural Determinism, Structural Coupling, Operational Closure, Structural Plasticity.

• **Cognition and Epistemology:** The Observer, Distinctions, Objectivity-in-Parenthesis (Constitutive Ontology), Objectivity-without-Parenthesis (Transcendental Ontology), Multiversa, Effective Action, Consensual Domains.

• **Language and Social Interaction:** Languaging, Conversation, Coordination of Coordinations of Action, Social Phenomena, Biology of Love, Mutual Acceptance.

• **Applied/Comparative Theory:** Soft Systems Methodology (SSM), Critical Systemic Thinking, Problem Structuring, Second-Order Cybernetics.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts and Principles**

**I. Biological and Systemic Foundations**

**Autopoiesis (Self-Production)**A characterization of living systems as networks of processes of production (transformation and destruction) of components. An autopoietic system produces its own components, which in turn regenerate the network that produced them, constituting the system as a concrete unity in space\[1\]\[2\]. It is a system closed in its dynamics of states; it stays alive only as long as its structural changes conserve its autopoiesis\[3\].

**Allopoietic Systems**Systems that produce something other than themselves (e.g., a car or a factory). Their organization is defined by the product they produce, unlike autopoietic systems which produce themselves\[4\]\[5\].

**Organization**The specific relations between components that define a system as a member of a particular class (giving it its identity). For a system to maintain its identity (e.g., to remain a living being), its organization must remain invariant\[6\]\[7\].

**Structure**The actual components and the specific relations between them that constitute a particular unity in a given space and realize its organization. Unlike organization, the structure of a system can change (plasticity) without the system losing its identity, provided the organization is maintained\[6\]\[8\].

**Structural Determinism**The principle that a system operates according to the internal dynamics of its structure. Nothing external can "instruct" or determine the changes within a system; external agents can only "trigger" structural changes that are determined by the system's own structure at that moment\[9\].

**Structural Coupling**A history of recurrent interactions between two or more structure-determined systems (or a system and its medium) leading to congruent structural changes. As long as the systems do not disintegrate, they drift together, shaping each other's environments without determining each other's internal states\[13\].

**Operational Closure**The characteristic of the nervous system (and autopoietic systems) wherein it operates as a closed network of interactions. The system does not have "inputs" and "outputs" in the traditional information-processing sense; rather, it interacts with its own internal states. Environmental perturbations only modulate the system's constant maintenance of internal correlations\[9\].

**Perturbation**An interaction that triggers a change of state in a system without destroying it. The specific effect of a perturbation is defined by the structure of the receiving system, not by the perturbing agent\[21\]\[22\].

**II. Cognition, The Observer, and Reality**

**The Observer**A human being operating in language who makes distinctions. The observer is the necessary constitutive condition for the existence of anything explained; "Everything said is said by an observer"\[23\].

**Distinction**The fundamental cognitive operation by which an observer specifies an entity by separating it from a background. Existence arises from the act of distinction\[28\].

**Cognition**Cognition is not the representation of an independent reality "out there." Instead, it is effective action (or behavior) in a domain of existence. Living is a process of cognition\[1\].

**Objectivity-in-Parenthesis (Constitutive Ontology)**An explanatory path where the observer accepts that reality is constituted by their operations of distinction. It recognizes that we cannot make reference to an independent reality to validate our explanations. This leads to the recognition of a **Multiversa** (many equally legitimate realities) rather than a single Universe\[34\].

**Objectivity-without-Parenthesis (Transcendental Ontology)**An explanatory path where the observer assumes the existence of a single objective reality independent of their own operations. In this view, a claim of knowledge often becomes a "demand for obedience" because it claims access to the absolute "truth"\[38\]\[39\].

**Illusion vs. Perception**Because living systems are structurally determined, an observer cannot distinguish in the immediate experience between a perception (valid experience) and an illusion. The distinction is made only secondarily through reference to another experience or observer\[13\].

**III. Language, Ethics, and Social Systems**

**Languaging**A process that occurs in the flow of consensual coordinations of coordinations of behavior (or doings). Language is not a system of symbols used to communicate information about the world; rather, it is a manner of living together in a flow of recurrent interactions\[42\].

**Conversations**A flow of coordinations of actions and emotions between observers. Human cultures and societies are constituted as networks of conversations\[45\].

**Biology of Love / Mutual Acceptance**Maturana defines love biologically as the emotion (body disposition) that specifies the domain of actions where living systems coordinate their actions in a manner that entails mutual acceptance. This is the foundational emotion for social phenomena\[48\]\[49\].

**Social Phenomena**Phenomena that arise from recurrent interactions between organisms based on mutual acceptance (love). If the emotion is not mutual acceptance (e.g., coercion), the interaction is not social\[50\]\[51\].

**Ethics**In the realm of constitutive ontologies (Objectivity-in-Parenthesis), ethics arises from the awareness that we are responsible for the realities we bring forth. It involves asking whether our actions promote dynamics of mutual acceptance\[52\].

**IV. Application and Synthesis**

**Problem Solving (Autopoietic View)**For an autopoietic system, a "problem" is a perturbation it must compensate for to maintain its identity. Solving a problem means undergoing structural changes that allow the system to continue its autopoiesis\[55\].

**Co-Ontogenic Structural Drift**The process by which structurally coupled systems (e.g., members of a social group) undergo interlocked histories of structural change, creating a shared consensual domain\[56\]\[57\].

**Soft Systems Methodology (SSM) & Autopoiesis**Checkland’s SSM, which views reality as socially constructed and problematic, resonates with Maturana’s "Objectivity-in-Parenthesis." SSM stages can be viewed as operations of distinction where stakeholders bring forth different realities based on their "Weltanschauungen" (worldviews)\[28\].

**Teleology vs. Drifting**Unlike Churchman’s systems approach, which is teleological (goal-oriented/purposeful), Maturana’s autopoiesis is non-teleological. Living systems do not have "purposes"; they drift in a continuous present, maintaining their organization. Purpose is an attribution made by an observer\[60\]\[61\].

---
> [!info]- References
> [1] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [2] A bridge for 2 views checklnds ssm maturana ontology of the observer.pdf
> [3] Maturana - Metadesign.pdf
> [4] Matura-CognitiveStrategies.pdf
> [5] cognitive theories of maturana.pdf
> [6] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [7] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [8] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [9] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [13] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [21] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [22] [Book] Maturana - Tree of knowledge.pdf
> [23] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [28] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [34] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [38] Maturana 1988 - The search for objectivity.pdf
> [39] Maturana 1988 - The search for objectivity.pdf
> [42] Maturana - Metadesign.pdf
> [45] Bond Maturana Technology and Art Is a Biology of Technology Possible.pdf
> [48] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [49] Maturana 1988 - The search for objectivity.pdf
> [50] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [51] Maturana 1988 - The search for objectivity.pdf
> [52] A bridge SSM and Maturanas Ontology of the Observer 12March2019.pdf
> [55] Matura-CognitiveStrategies.pdf
> [56] Maturana 1988 - The search for objectivity.pdf
> [57] [Book] Maturana - Tree of knowledge.pdf
> [60] Retmolds - Churchman and Maturana enriching the notion of self organization for social design.pdf
> [61] [Book] Maturana - Autopoesis and cognition.pdf


FILE: 'Hylton Boothroyd.md'
---
exported: '2026-01-31T20:17:52.557Z'
source: NotebookLM
type: chat
title: Hylton Boothroyd on 💬Keywords and Jargon
tags:
  - Hylton-Boothroyd
  - Keywords
author: Hylton Boothroyd
---
Based on the provided sources, the following are the key concepts, principles, and theories that define Hylton Boothroyd's philosophy of **articulate intervention** and the broader rethinking of the Operational Research (OR) process.

### **Key Keywords**

• **Action Programmes**\[1\]

• **Articulate Reflection**\[4\]

• **Theories and Proposals**\[7\]

• **Differential Regard**\[10\]

• **Latent vs. Active Content**\[13\]

• **Abstract Technology**\[1\]

• **Heuristic Power**\[18\]

• **Cascade of Consequences**\[14\]

• **Piecemeal Engineering**\[23\]\[24\]

• **Environmental Consistency Confidence**\[25\]\[26\]

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts and Theories**

**Abstract Technology**The methods of OR/Systems Analysis described as formal, precise, or mathematical models (such as linear programming or simulation) that represent real or imagined systems\[1\]. Boothroyd views these as tools for answering **"what-if"** questions rather than as machines for automatic decision-making\[27\].

**Action Programme**Boothroyd's central concept for human activity, defined as an **ongoing stream of conduct** by individuals or groups\[1\]. Each programme is "theory-saturated" and "proposal-saturated," meaning it possesses a set of beliefs and intentions that adapt over time but retain a stable "core"\[1\].

**Articulate Intervention (AI)**The practice of joining an "action programme" (a client organization) to provide **structured reflection before action**\[4\]. It involves using language to lift hidden assumptions to a level where they can be debated and improved\[35\].

**Cascade of Consequences**The principle that any action leads to an **indefinitely large chain of outcomes** proliferating into the future, many of which are unintended or unconceptualized\[14\].

**Critical Rationalism**The philosophical foundation (based on Karl Popper) which posits that all knowledge consists of **conjectures** that remain valid only until they are refuted or falsified\[40\]. Boothroyd applies this to OR by insisting that all analytical recommendations are **temporarily valid** and subject to review\[43\].

**Differential Regard**The principle that the significance or "goodness" of an action is **not an absolute property** but depends entirely on the specific "action programme" from which it is viewed\[10\]. There is no universal "best" action across all conflicting viewpoints\[12\]\[47\].

**Environmental Consistency Confidence (ECC)**A theory in financial risk management (Mainelli) that uses statistical correlation to determine if outcomes are consistent with the environmental activity\[25\]\[26\]. It restores **statistical logic** to the core of risk management to identify the limits of environmental comprehension\[25\]\[48\].

**Heuristic Power**The capacity of an action programme or research tradition to **prompt new theories and actions** in advance of specific problems\[18\]. A "progressive" programme exhibits high heuristic power, while a "degenerate" one merely adds auxiliary hypotheses to hide its failures\[19\].

**Latent vs. Active Content**The distinction between the **indefinitely large background** of hidden thoughts and beliefs (latent) and the specific subset of assumptions consciously selected for articulation and analysis (active/boxed)\[13\].

**Piecemeal Engineering**Popper's proposed method for the social sciences, advocating for **small, critical adjustments** to social institutions based on trial and error, rather than "Utopian" large-scale blueprints\[23\].

**Proposals**A component of articulation describing **"what ought to be."** They represent attitudes, values, ethics, and plans\[7\]. Unlike theories, proposals reflect volition and cannot be derived logically from facts alone\[8\].

**Theories**A component of articulation describing **"what is."** They are passive descriptions of the properties of things, people, or institutions and have the logical status of unrefuted conjectures\[7\].

**Weltanschauung (Worldview)**A term central to Soft Systems Methodology (Checkland) referring to the **individual's perspective** that makes a particular human activity system meaningful\[58\]. Different observers will produce different, yet equally valid, accounts of the same system based on their worldview\[60\].

---
> [!info]- References
> [1] 2010 Articulate Intervention Revisited.pdf
> [4] 2010 Articulate Intervention Revisited.pdf
> [7] 2010 Articulate Intervention Revisited.pdf
> [8] 2010 Articulate Intervention Revisited.pdf
> [10] 2010 Articulate Intervention Revisited.pdf
> [12] [Book] Boothroyd - Articulate Intervention.pdf
> [13] 2010 Articulate Intervention Revisited.pdf
> [14] 2010 Articulate Intervention Revisited.pdf
> [18] 2010 Articulate Intervention Revisited.pdf
> [19] [Book] Boothroyd - Articulate Intervention.pdf
> [23] The history and ideas of critical rationalism the philosophy of Karl Popper and its implications for OR.pdf
> [24] The history and ideas of critical rationalism the philosophy of Karl Popper and its implications for OR.pdf
> [25] Risk-case-study.md
> [26] Risk-case-study.md
> [27] 2010 Articulate Intervention Revisited.pdf
> [35] 2010 Articulate Intervention Revisited.pdf
> [40] 2010 Articulate Intervention Revisited.pdf
> [43] 2010 Articulate Intervention Revisited.pdf
> [47] Boothroyd Scanned.pdf
> [48] Risk-case-study.md
> [58] 2010 Articulate Intervention Revisited.pdf
> [60] [Book] Tomlinson - Rethinking the Process of Operational Research  Systems Analysis.pdf


FILE: 'Ian Mitroff.md'
---
exported: 2026-02-07T17:23:26.567Z
source: NotebookLM
type: chat
title: Ian Mitroff on 💬Keywords and Jargon
tags:
  - Keywords
  - Ian-Mitroff
author: Ian Mitroff
---
Based on the provided sources, here is a breakdown of the key concepts, principles, and theories regarding Unbounded Systems Thinking, Crisis Management, and Problem Solving as developed by Ian Mitroff, Harold Linstone, and their collaborators.

### **Keywords**

• **Problem Types:** Mess, Exercise, Wicked Problem, Ill-Structured Problem.

• **Errors:** Type III Error (E3), Type IV Error (E4), Type I & II Errors.

• **Multiple Perspectives (TOP):** Technical (T), Organizational (O), Personal (P).

• **Methodologies:** Strategic Assumption Surfacing and Testing (SAST), Dialectical Inquiry, Sweeping In, Stakeholder Analysis.

• **Inquiry Systems:** Leibnizian, Lockean, Kantian, Hegelian (Dialectical), Singerian (Unbounded).

• **Crisis Management:** Crisis-Prone vs. Crisis-Prepared, Signal Detection, Systemic Risk.

• **Psychodynamics:** Splitting, Projection, Unreality, Jungian Typology.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts and Theories**

**1\. The Nature of Problems**

• **Mess:** A system of external conditions and dynamic, interacting problems. A mess is not merely the sum of its parts; problems are abstractions extracted from messes by analysis. Therefore, problems cannot be solved in isolation; they must be managed as a whole system\[1\],\[2\],\[3\].

• **Exercise:** A bounded, well-structured puzzle (often found in textbooks) where the formulation is clear, all necessary information is provided, and a single correct solution exists. Exercises are distinct from real-world problems\[4\],\[5\],\[6\].

• **Wicked Problem:** A problem that is unique, ill-defined, and has no definitive formulation or "stopping rule" (you never know when you are fully done). Every solution to a wicked problem generates new problems\[7\],\[8\],\[9\].

• **Ill-Structured Problem:** A problem wherein the definition, the alternatives, and the outcomes are not clearly known. Structuring these problems is the primary task of decision-making\[10\],\[11\].

**2\. Errors in Inquiry**

• **Error of the Third Kind (E3):** The error of solving the _wrong_ problem precisely. This occurs when one formulates a problem incorrectly (e.g., viewing a social problem as a purely technical one) and then applies rigorous methods to solve that incorrect formulation\[12\],\[13\],\[14\],\[15\].

• **Error of the Fourth Kind (E4):** The _intentional_ error of solving the wrong problem. This occurs when a stakeholder deliberately misleads others or forces a wrong definition of a problem upon them for political, ideological, or financial gain (e.g., "dirty rotten strategies")\[14\],\[16\].

• **Type I and Type II Errors:** Traditional statistical errors. Type I is rejecting a true hypothesis (false positive); Type II is accepting a false hypothesis (false negative). These errors come _after_ a problem has been formulated\[12\],\[17\].

**3\. The Multiple Perspectives Perspective (TOP)**

• **Technical Perspective (T):** A worldview based on science, technology, and logic. It focuses on cause-and-effect, data, models, optimization, and efficiency. It views systems as mechanisms and seeks objective truth\[18\],\[19\],\[20\].

• **Organizational Perspective (O):** A worldview based on social entities and institutions. It focuses on process, power, myths, standard operating procedures (SOPs), and political expediency. Truth is often consensual or process-dependent\[18\],\[21\],\[20\].

• **Personal Perspective (P):** A worldview based on the individual. It focuses on intuition, leadership, charisma, self-interest, and the unique psychological makeup of stakeholders. It emphasizes the subjective and ethical dimensions\[18\],\[22\],\[23\].

• **Polyocular Vision:** The ability to view a complex system through multiple perspectives (T, O, and P) simultaneously to gain a holistic understanding that no single perspective can provide\[24\].

**4\. Methodologies for Problem Structuring**

• **Strategic Assumption Surfacing and Testing (SAST):** A methodology designed to uncover and challenge the hidden assumptions underlying policy decisions. It asserts that the validity of a plan depends on the validity of the assumptions about the stakeholders involved\[10\],\[25\].

    ◦ **Assumption:** The "presumed properties of stakeholders." You cannot have an assumption without a stakeholder\[26\],\[27\].    ◦ **Importance/Certainty Matrix:** A tool used in SAST to plot assumptions. The critical zone is **High Importance/Low Certainty**, identifying assumptions that are vital to success but factually shaky\[28\],\[29\].
• **Dialectical Inquiry:** An inquiry system based on conflict (Hegelian). It posits that truth emerges from the intense debate between two diametrically opposed views (Thesis and Antithesis) to form a Synthesis. It is used to challenge the "One Best Way" approach\[10\],\[30\],\[31\].

• **Stakeholder Analysis:** The process of identifying all parties who affect or are affected by a decision. It is the entry point for surfacing assumptions in SAST\[26\],\[32\].

**5\. Systems Thinking and Inquiry Systems**

• **Unbounded Systems Thinking (UST):** A "Singerian" approach that assumes "everything interacts with everything." It rejects the isolation of disciplines and asserts that solving complex problems requires "sweeping in" variables from ethics, psychology, and the environment\[33\],\[34\],\[35\].

• **Sweeping In:** The process of expanding the boundaries of a problem to include variables (like ethics or mood) that traditional technical analysis excludes as "externalities"\[33\],\[36\].

• **Singerian Inquiry System:** A meta-system that validates knowledge based on its ability to solve problems and ethics. It views the "is" (science) and the "ought" (ethics) as inseparable\[37\],\[38\].

• **Machine Age Thinking:** A worldview characterized by reductionism (breaking things into parts), analysis, and the belief in a deterministic, predictable universe. It is contrasted with Systems Age thinking\[39\],\[40\].

**6\. Crisis Management and Psychodynamics**

• **Crisis-Prone vs. Crisis-Prepared:** Crisis-prone organizations rely on defence mechanisms (denial, disavowal) and prepare only for crises they have already faced. Crisis-prepared organizations anticipate a wide "family" of crises and think systemically\[41\],\[42\],\[43\].

• **Signal Detection:** The ability of a system to sense early warning signs (weak signals) of an impending crisis before it occurs. It is often blocked by organizational filters\[44\],\[45\].

• **Splitting:** A psychodynamic defence mechanism where the world is sharply divided into "all good" or "all bad" (e.g., "us vs. them"). It simplifies complex messes into dangerous oversimplifications\[46\].

• **Unreality:** The deliberate creation of arguments, images, and myths that distort or replace ordinary reality (e.g., "reality TV," fake news). It is a form of Type IV error\[47\].

• **Jungian Typology in Problem Solving:** The use of Carl Jung’s personality types (Sensing vs. Intuitive; Thinking vs. Feeling) to understand how different people define problems differently. For example, "Sensing-Thinking" types prefer technical details, while "Intuitive-Feeling" types prefer broad, humanistic patterns\[18\],\[48\],\[49\].

---
> [!info]- References
> [1] Mitroff - Crises as Ill Structured Messes.pdf
> [2] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [3] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [4] Mitroff 1974 - On systemic problem solving and the error of the third kind.pdf
> [5] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [6] [Book] Mitroff - Smart Thinking for Crazy Times.pdf
> [7] [Book] Linstone - Decision Making for Technology Executives.pdf
> [8] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [9] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [10] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [11] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [12] Mitroff - Crises as Ill Structured Messes.pdf
> [13] Mitroff 1974 - On systemic problem solving and the error of the third kind.pdf
> [14] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [15] [Book] Mitroff - Smart Thinking for Crazy Times.pdf
> [16] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [17] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [18] Mitroff Three Perspectives.pdf
> [19] [Book] Linstone - Decision Making for Technology Executives.pdf
> [20] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [21] [Book] Linstone - Decision Making for Technology Executives.pdf
> [22] [Book] Linstone - Decision Making for Technology Executives.pdf
> [23] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [24] [Book] Linstone - Decision Making for Technology Executives.pdf
> [25] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [26] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [27] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [28] Mitroff - Assumptional Analysis A methodology for strategic problem solving.pdf
> [29] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [30] [Book] Mitroff - Creating a dialectical social science - concepts methods and models.pdf
> [31] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [32] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [33] [Book] Linstone - Decision Making for Technology Executives.pdf
> [34] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [35] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [36] [Book] Mitroff,Linstone - 1993 - The unbounded mind - Oxford University Press.pdf
> [37] Mitroff - Crises as Ill Structured Messes.pdf
> [38] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [39] [Book] Mitroff - Smart Thinking for Crazy Times.pdf
> [40] [Book] Mitroff - Smart Thinking for Crazy Times.pdf
> [41] Mitroff - Crises as Ill Structured Messes.pdf
> [42] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [43] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [44] Mitroff - Crises as Ill Structured Messes.pdf
> [45] Mitroff - Crises as Ill Structured Messes.pdf
> [46] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf
> [47] [Book] Mitroff - Dirty Rotten Strategies How We Trick Ourselves and Others into Solving the Wrong Problems Precisely.pdf
> [48] [Book] Mitroff - Business Strategies for a Messy World Tools for Systemic Problem-Solving.pdf
> [49] [Book] Mitroff - Technology Run Amok Crisis Management in the Digital Age.pdf


FILE: 'J. Gerard Wolff.md'
---
exported: '2026-01-31T20:05:37.249Z'
source: NotebookLM
type: chat
title: J. Gerard Wolff
tags:
  - J.-Gerard-Wolff
  - Keywords
---
### Keywords

**Information Compression (IC)**, **SP Theory of Intelligence**, **Multiple Alignment**, **Unification**, **Unsupervised Learning**, **Simplicity and Power**, **DONSVIC**, **Minimum Length Encoding (MLE)**, **SP-pattern**, **SP Machine**, **SP-Neural**.

\--------------------------------------------------------------------------------

### Glossary

• **Absolute Probability:** A value calculated for each multiple alignment based on the length of the code derived from it, where shorter codes indicate higher absolute probability\[1\]\[2\].

• **Atomic Symbol:** A mark that can be matched in an all-or-nothing manner with any other symbol and has no intrinsic meaning\[3\].

• **C-symbols (Contents Symbols):** Symbols within a pattern that represent the substance or contents of the knowledge being stored\[6\].

• **Chunking-with-codes:** A basic variant of information compression where a repeating pattern (chunk) is identified, unified, and replaced by a relatively short name or code\[9\].

• **Class-Inclusion Hierarchy:** A grouping of entities into classes where attributes from higher-level classes are inherited by lower-level classes to avoid redundant storage\[10\].

• **Compression Difference (CD):** The compression score of a multiple alignment calculated by subtracting the size of the encoded data from the size of the raw data\[14\].

• **DONSVIC:** An acronym for **Discovery of Natural Structures Via Information Compression**, a principle stating that structures judged as "natural" are typically those that yield high compression\[17\].

• **ID-symbols (Identification Symbols):** Symbols that serve to identify a pattern or mark its boundaries, distinguishing it from others in a set\[7\].

• **ICMAUS:** An acronym for **Information Compression by Multiple Alignment, Unification and Search**, the conceptual core of the SP theory\[22\].

• **Information Compression (IC):** The unifying theme of the SP theory, achieved by reducing informational redundancy while retaining descriptive power\[17\].

• **Minimum Length Encoding (MLE):** A principle that guides learning by aiming to minimize the sum of the size of the grammar and the size of the data encoded in terms of that grammar\[3\].

• **Multiple Alignment:** A central concept in SP (adapted from bioinformatics) that involves arranging patterns so that matching symbols are aligned to reveal redundancy and facilitate compression\[17\].

• **Pattern Assembly:** The neural analogue of an Old pattern in the SP theory, hypothesised to be a collection of interconnected neurons similar to a Hebbian cell assembly\[31\].

• **Run-Length Coding:** A technique where a pattern that repeats contiguously is reduced to a single instance with a marker showing the number of repetitions\[10\].

• **Schema-plus-correction:** A compression technique where a recurring pattern is stored as a "schema" and variations are stored as "corrections" to that schema\[10\].

• **Simplicity and Power (SP):** The concepts defining the name of the theory; information compression increases simplicity while retaining non-redundant expressive power\[36\].

• **SP Machine:** A proposed high-parallel computing system realized through the SP theory, with applications in AI and data storage\[17\].

• **SP-Neural:** A preliminary version of the SP theory expressed in terms of neurons, their interconnections, and inter-communications\[33\].

• **SP-pattern:** An array of atomic symbols in one or two dimensions used to represent all kinds of knowledge within the SP system\[3\].

• **Unification:** The simple merging of two or more identical patterns, or parts of patterns, to create a single instance and reduce redundancy\[43\].

• **Unsupervised Learning:** A process in the SP system where Old patterns are derived by compressing New information received via senses without the aid of a teacher\[3\].

---
> [!info]- References
> [1] ISBN0955072603_e3.pdf
> [2] JGW3A_WE.PDF
> [3] 1306.3888.pdf
> [6] ISBN0955072603_e3.pdf
> [7] ISBN0955072603_e3.pdf
> [9] ISBN0955072603_e3.pdf
> [10] Wolff - SP Theory of Intelligence as a Foundation for the development of artificial general intelligence.pdf
> [14] 1306.3888.pdf
> [17] 1306.3888.pdf
> [22] AIREV3A.PDF
> [31] 1306.3888.pdf
> [33] Wolff - SP Theory of Intelligence as a Foundation for the development of artificial general intelligence.pdf
> [36] 1306.3888.pdf
> [43] 2005 - Jerry Wolff on Medical Diagnosis.pdf


FILE: 'James Ladyman.md'
---
exported: 2026-02-07T16:13:11.706Z
source: NotebookLM
type: chat
title: James Ladyman on 💬Keywords and Jargon
tags:
  - James-Ladyman
  - Keywords
author: James Ladyman
---
Based on the provided sources, here are the key concepts, principles, and theories extracted from the works of Ladyman, Ross, Wiesner, Vitale, and Wolff.

### **Keywords**

**Metaphysics & Ontology**

• Ontic Structural Realism (OSR)

• Rainforest Realism (Real Patterns)

• Information-Theoretic Structural Realism (ITSR)

• Principle of Naturalistic Closure (PNC)

• Primacy of Physics Constraint (PPC)

• Scale Relativity of Ontology

• Locators

**Complexity Science & Information Theory**

• Statistical Complexity

• Logical Depth

• Effective Complexity

• Algorithmic Compressibility

• The "Middle Path" (Between Order and Randomness)

• ICMUP (Information Compression via Matching and Unification of Patterns)

• Non-equilibrium / Thermodynamic Openness

• Feedback (Recursion)

• Self-Organisation

**Relational Philosophy (Networkologies)**

• The Oneand

• Networkological Calculus (Node, Link, Ground, Level)

• Refraction

• Disparation

• Intermodulation (Metacursion)

• Plurilectics

• Worldtwisting

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**I. Principles of Naturalized Metaphysics**

• **Principle of Naturalistic Closure (PNC):** A methodological principle stating that metaphysics must be motivated exclusively by attempts to unify hypotheses and theories that are taken seriously by contemporary science. It rejects "armchair" metaphysics based on intuition or common sense\[1\],\[2\].

• **Primacy of Physics Constraint (PPC):** The rule that special sciences (e.g., biology, psychology) must not posit entities or processes that contradict the laws of fundamental physics. However, this does not imply that special sciences are _reducible_ to physics; they describe real patterns that physics may not capture\[3\],\[2\].

• **Ontic Structural Realism (OSR):** The metaphysical view that the world is composed of structural relations rather than self-subsistent individuals. In this view, "things" (like particles or objects) are secondary to the relations that define them. It can be summarized as: "There are no things. Structure is all there is"\[4\],\[5\].

• **Rainforest Realism:** An ontology that admits a "lush" variety of existing things (e.g., markets, traffic jams, biological species) provided they qualify as "Real Patterns." It rejects the idea that only the smallest physical particles are "real," allowing for existence at multiple scales of resolution\[6\],\[7\].

• **Real Patterns:** An entity exists if it is a "real pattern." A pattern is real if it is (1) **Projectible** (it supports probabilistic predictions better than random guessing) and (2) **Compressible** (it can be described more efficiently than a raw bit-map of its physical constituents). This concept is adapted from Daniel Dennett but formalized mathematically\[8\],\[9\].

**II. Complexity Science & Measurement**

• **Complex System (Physical Account):** Defined by Ladyman and Wiesner as "an ensemble of many elements which are interacting in a disordered way, resulting in robust organisation and memory"\[10\],\[11\].

• **The "Middle Path" (Chaordic):** The concept that complexity exists in a regime between total order (crystals) and total randomness (ideal gases). Complexity requires a mixture of structure and disorder\[12\],\[13\].

• **Statistical Complexity:** A measure of complexity that quantifies the amount of information a system stores about its past that is relevant to predicting its future. Unlike Algorithmic Complexity (which is maximal for random strings), Statistical Complexity is low for both perfectly ordered and perfectly random systems, peaking in the "middle" complex regime\[14\],\[15\].

• **Logical Depth:** A measure of complexity based on the difficulty of creation. It is defined as the execution time required for a universal Turing machine to run the shortest program that produces the object. Complex objects (like DNA) have high logical depth because they require a long history to evolve\[12\],\[16\].

• **ICMUP (Information Compression via the Matching and Unification of Patterns):** A theory proposed by J.G. Wolff suggesting that mathematics, science, and human cognition function by compressing information. This is achieved by finding repeating patterns and merging them to reduce redundancy\[17\],\[18\].

• **Effective Complexity:** A measure introduced by Murray Gell-Mann that quantifies the length of a concise description of a system's _regularities_, ignoring the random features. It seeks to separate the signal (structure) from the noise\[19\],\[20\].

**III. Relational Philosophy (Networkologies)**

• **The Oneand:** A term coined by Vitale to describe emergence as "one-and"—meaning any unity is always itself _plus_ its relations and potentials. It signifies that nothing is ever fully isolated or "closed"\[21\],\[22\].

• **Disparation:** The logic of "symmetry-breaking" or the production of difference. It describes the conditions (such as tension or imbalance) that cause a system to differentiate and give rise to new aspects\[23\],\[24\].

• **Refraction:** The process by which abstract potentials (forces) interact with concrete obstacles or forms, "bending" or modifying them to produce qualitatively new outcomes. It is how emergence potentiates itself by differing from itself\[25\],\[26\].

• **Intermodulation:** A form of interaction that is adaptive and mutually transformative. Unlike simple mechanical interaction, intermodulation involves systems modifying each other’s internal states and potentials, often through feedback\[27\],\[28\].

• **Plurilectics:** A post-dialectical logic of time and process proposed by Vitale. Unlike Hegelian dialectics which seek synthesis, plurilectics describes a multi-directional, branching unfolding of time where the past and future interpenetrate the present (Worldtwisting)\[29\],\[30\].

• **Networkological Calculus:** A formal system for diagramming emergence using four primary concepts: **Node** (something noded/grasped), **Link** (relation), **Ground** (context/background), and **Level** (emergent networking)\[31\],\[32\].

**IV. Features of Complex Systems (The "Conditions and Products")**

• **Conditions:** The prerequisites for complexity to arise.

    ◦ _Numerosity:_ Many interacting components\[33\].    ◦ _Disorder/Diversity:_ Lack of central control; components differ\[33\].    ◦ _Feedback:_ Outputs loop back to inputs (recursion)\[33\].    ◦ _Non-equilibrium:_ The system is open to energy/information flow\[33\].
• **Products:** The emergent results of the conditions.

    ◦ _Spontaneous Order:_ Structure arises without a blueprint\[34\].    ◦ _Robustness:_ Stability under perturbation\[34\].    ◦ _History/Memory:_ The system stores information about the past\[34\].    ◦ _Adaptive Behaviour:_ The system modifies behavior based on the environment\[34\].

---
> [!info]- References
> [1] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [2] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [3] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [4] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [5] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [6] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [7] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [8] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [9] [Book] Ladyman - Every Thing Must Go Metaphysics Naturalized.pdf
> [10] Ladyman - What is a Complex System.pdf
> [11] what is a complex system.pdf
> [12] Ladyman - What is a Complex System.pdf
> [13] Ladyman 2012 - What is a complex system.pdf
> [14] Ladyman - What is a Complex System.pdf
> [15] Ladyman 2012 - What is a complex system.pdf
> [16] what is a complex system.pdf
> [17] sp_phil_maths_2017-12-06.pdf
> [18] sp_phil_maths_2017-12-06.pdf
> [19] Ladyman 2012 - What is a complex system.pdf
> [20] what is a complex system.pdf
> [21] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [22] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [23] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [24] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [25] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [26] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [27] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [28] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [29] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [30] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [31] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [32] [Book] Vitale - Logics of Emergence Relational Philosophy.pdf
> [33] Ladyman - On Complexity.pdf
> [34] Ladyman - On Complexity.pdf


FILE: 'James Wilk.md'
---
exported: 2026-02-07T17:23:58.278Z
source: NotebookLM
type: chat
title: James Wilk on 💬Keywords and Jargon
tags:
  - Keywords
  - James-Wilk
author: James Wilk
---
### **Key Concepts and Principles**

**Core Theories:**

• Metamorphology

• E2 Epistemology (The "New" Epistemology)

• Cybernetics (The Science of Justified Intervention)

• Clinical Epistemology

• Ternality Theory

**Fundamental Principles:**

• Flux-and-Constraint (vs. Cause-and-Effect)

• Negative Explanation ("Why this rather than that?")

• Benevolent Skepticism

• Utilization

• The "Bottom Line"

• The Interdependence of Observer and Observed

**Operational Concepts:**

• Minimalist Intervention

• Video Descriptions (The Observation/Description Frame)

• Context-Markers

• Pattern Intervention

• Recontextualization / Decontextualization

• "Cake Theory"

• The "Museum Theory" (rejected concept)

\--------------------------------------------------------------------------------

### **Glossary of Terms**

**Benevolent Skepticism**

A clinical stance in which the interventionist doubts the necessity of the client’s problem and the validity of the client's "imperatives" (rules about what must or cannot happen)\[1\]. It involves a refusal to believe that the client is broken or that the problem is unsolvable, instead assuming that the desired outcome is possible immediately if the right constraints are lifted\[1\]\[2\].

**Cake Theory**

A metaphorical concept regarding the nature of reality. It posits that a person's subjective reality—provided it is veridical (truthful)—is not a distorted "photograph" of reality, but a real, edible "slice" of the larger objective "cake"\[3\]\[4\]. Subjective reality is objectively real but represents a selected subset of the infinite possibilities available in the total objective reality\[4\]\[5\].

**Clinical Epistemology**

A discipline applied to psychotherapy that analyzes the effect of a therapist's and client's presuppositions (implicit assumptions about the nature of the mind and reality) on therapeutic outcomes\[6\]. It involves bringing about results by altering these presuppositions to create a context for effective change\[6\]\[7\].

**Constraint (and Flux-and-Constraint)**

The central explanatory mechanism in E2 Epistemology. Unlike the traditional view where stability is the norm and change requires a cause, this view assumes that random "flux" is the natural state of the universe\[8\]. Therefore, the persistence of any pattern (stability) requires explanation, which is found in "constraints" that prevent other possibilities from occurring\[11\]\[12\]. Change is achieved not by applying force, but by lifting or inserting constraints to release a new pattern\[13\]\[14\].

**Context-Markers**

Specific, abstracted aspects of communication or the environment (such as a tone of voice, a physical object, or a setting) that signal to participants which "context" they are currently in\[15\]. Because context determines the meaning of behavior, manipulating context-markers (e.g., obliterating them or introducing new ones) can instantly transform the meaning and nature of an interaction\[16\].

**E2 Epistemology (The "New" Epistemology)**

A cybernetic epistemology based on the notions of form, pattern, information, and context, as opposed to the traditional "E1" epistemology based on substance, force, energy, and lineal cause-and-effect\[20\]. In E2, reality is viewed as a "fluid, infinitely multi-dimensional world of endless possibilities" where outcomes are determined by the filtering of complexity rather than causal chains\[8\].

**Metamorphology**

The "science of change" or transformation\[26\]\[27\]. It is a field of scientific study that investigates how to identify the shortest route from one stable state of a system to another\[28\]. It encompasses the General Theory of Intervention and provides the theoretical basis for Minimalist Intervention\[29\]\[30\].

**Minimalist Intervention (MI)**

A technology for creating rapid, major transformations with absolute precision by identifying the smallest possible action (a "nudge" or catalyst) required to flip a system from an existing state to a desired state\[31\]. It relies on filtering complexity to find the specific "idiosyncratic constraints" that, if altered, make the problem impossible and the solution inevitable\[31\].

**The "Museum Theory" of Reality**

A rejected conventional view which posits that the world is a fixed, law-governed system divided into static categories or "departments" (e.g., biological, economic, psychological)\[37\]\[38\]. Minimalist intervention rejects this view, arguing instead that reality is infinitely re-describable and not bound by these artificial labels\[39\]\[40\].

**Negative Explanation**

A mode of scientific explanation used in metamorphology that asks "Why this _rather than_ that?"\[41\]\[42\]. Instead of looking for positive causes of an event, it explains a state-of-affairs by specifying the constraints that preclude all other theoretical possibilities\[41\]\[43\].

**Pattern Intervention**

A method of changing a problematic behavior by altering the invariant sequence or form of the pattern itself\[44\]\[45\]. Since a pattern relies on consistency (redundancy), varying any element of the pattern—such as frequency, duration, location, or intensity—can disrupt the "mold" or "template" of the problem, forcing the system to reorganize\[46\].

**Recontextualization**

A form of context intervention where one context is transformed into another by introducing new context-markers or re-employing existing ones to signal a new definition of the situation\[49\]\[50\].

**Utilization**

A principle derived from Milton Erickson and cybernetics, involving the use of the client’s existing resources, beliefs, behaviors, and idiosyncrasies to build a bridge to the desired outcome\[51\]. It rejects the idea of fighting "resistance" and instead uses whatever the client brings (even the symptom itself) as the raw material for the solution\[51\]\[54\].

**Video Description (Observation/Description Frame)**

A rigorous description of a situation restricted to direct observables that could be recorded by a video camera with a soundtrack\[55\]. This technique is used to strip away interpretations ("meanings," "abstractions," and "diagnoses") to reveal the concrete "doing" and "viewing" of a situation, which is the only level at which scientific verification and effective intervention can occur\[58\].

---
> [!info]- References
> [1] [Book] Wilk - Shifting Contexts.pdf
> [2] [Book] Wilk - Shifting Contexts.pdf
> [3] James Wilk.pdf
> [4] James Wilk.pdf
> [5] James Wilk.pdf
> [6] [Book] Wilk - Shifting Contexts.pdf
> [7] [Book] Wilk - Shifting Contexts.pdf
> [8] James Wilk.pdf
> [11] James Wilk.pdf
> [12] James Wilk.pdf
> [13] James Wilk.pdf
> [14] James Wilk.pdf
> [15] James Wilk.pdf
> [16] James Wilk.pdf
> [20] James Wilk.pdf
> [26] James Wilk.pdf
> [27] James Wilk.pdf
> [28] James Wilk.pdf
> [29] James Wilk.pdf
> [30] James Wilk.pdf
> [31] James Wilk.pdf
> [37] James Wilk.pdf
> [38] James Wilk.pdf
> [39] James Wilk.pdf
> [40] James Wilk.pdf
> [41] James Wilk.pdf
> [42] Wilk - Kaleidoscopic Change.pdf
> [43] Wilk 1999 - An introduction to metamorphology.pdf
> [44] James Wilk.pdf
> [45] [Book] Wilk - Shifting Contexts.pdf
> [46] James Wilk.pdf
> [49] James Wilk.pdf
> [50] James Wilk.pdf
> [51] James Wilk.pdf
> [54] [Book] Wilk - Shifting Contexts.pdf
> [55] James Wilk.pdf
> [58] [Book] Wilk - Shifting Contexts.pdf


FILE: 'John Flach.md'
---
exported: 2026-02-07T16:13:52.021Z
source: NotebookLM
type: chat
title: John Flach on 💬Keywords and Jargon
tags:
  - John-Flach
  - Keywords
author: John Flach
---
Based on the provided sources, here are the key concepts, principles, and theories extracted in the form of keywords, followed by a detailed glossary defining these terms within the context of **Cognitive Systems Engineering (CSE)** and **Ecological Psychology**.

### Keywords

**Theoretical Foundations**

• Triadic Semiotics (vs. Dyadic)

• Meaning Processing (vs. Information Processing)

• Radical Empiricism / Monism

• Control Theory (Closed-Loop Dynamics)

• Complexity Theory

• Ecological Psychology

• Systems Thinking

**Core Principles**

• Circular Causality

• Abduction (Logic of Discovery)

• Requisite Variety (Ashby’s Law)

• Muddling Through (Incrementalism)

• Direct Perception / Direct Manipulation

• Deep Structure

• Self-Organization

**Methodologies & Frameworks**

• Cognitive Systems Engineering (CSE)

• Work Domain Analysis (WDA)

• Abstraction Hierarchy (AH)

• Decision Ladder / SRK Framework (Skills, Rules, Knowledge)

• Ecological Interface Design (EID)

• Signal / Sign / Symbol

\--------------------------------------------------------------------------------

### Glossary of Key Concepts

**Abduction**

A form of logic described by Charles Sanders Peirce, distinct from deduction and induction. It is the pragmatic "logic of discovery" or "best guess" used to navigate uncertainty. In a closed-loop system, abduction involves generating a hypothesis (action) and testing it against the environment (feedback) to correct beliefs. It is the engine of learning and "muddling through"\[1\].

**Abstraction Hierarchy (AH)**

A theoretical framework used in Work Domain Analysis to map the "deep structure" of a system. It organizes constraints into nested levels, typically ranging from **Functional Purpose** (Why the system exists) and **Values/Priorities** (metrics of success), down to **Physical Function** and **Physical Form** (How the system is implemented). It allows analysts to understand the relationship between the physical means and the functional ends\[5\].

**Affordance**

A concept from James Gibson referring to the possibilities for action provided by the environment to an agent. Affordances are real properties of the ecology relative to the organism (e.g., a chair "affords" sitting to a human, but not to an elephant). Meaning is found in the discovery of these affordances\[9\].

**Circular Causality (Closed-Loop Dynamics)**

A principle from cybernetics and control theory rejecting linear cause-and-effect (stimulus-response). Instead, it posits that perception and action are coupled: an agent acts to perceive, and perceives to act. In this loop, "error" is not a failure but essential information (feedback) required to reduce the discrepancy between a goal and the current state\[13\].

**Deep Structure**

The invariant constraints and regularities of a work domain (such as physical laws, social rules, or system logic) that exist independently of the user's mental model. The goal of design is to make this deep structure visible to the user so they can adapt to novel situations\[16\].

**Ecological Interface Design (EID)**

A design framework aimed at making the constraints of a work domain (the Deep Structure) visible in the interface. EID seeks to allow operators to rely on powerful perceptual skills (**Skill-based** and **Rule-based** behaviors) rather than slow, effortful analytical thinking (**Knowledge-based** behavior) by visualizing relationships and physical laws (e.g., mass balance, energy flow)\[19\].

**Meaning Processing**

An alternative to the "Information Processing" metaphor. Whereas information processing views the mind as a computer calculating symbolic inputs, meaning processing views cognition as the struggle to align **Awareness** (Mind) with **Situational Constraints** (Matter). It is defined by three dimensions: **Affording** (possibilities), **Specifying** (information/patterns), and **Satisfying** (values/goals)\[22\].

**Muddling Through**

A strategy for dealing with "wicked" or complex problems where optimal solutions are impossible to calculate in advance. It involves **Incrementalism**—making small, reversible changes, monitoring feedback for error/surprise, and adjusting. It relies on feedback loops rather than perfect foresight\[25\].

**Requisite Variety**

A law from cybernetics (Ashby’s Law) stating that "only variety can destroy variety." To control a complex system, the controller (or interface) must have a repertoire of responses (variety) at least as nuanced as the problems presented by the system. If the system is complex, the interface cannot be overly simple without losing control\[28\].

**Signals / Signs / Symbols**

A distinction by Rasmussen regarding how information is interpreted based on the level of cognitive control:

• **Signals:** Sensory data processed as continuous variables for automated motor control (Skill-based).

• **Signs:** Cues that trigger associative rules or recipes for action (Rule-based).

• **Symbols:** Information used for conscious reasoning and analytical problem solving (Knowledge-based)\[31\].

**SRK Framework (Skills, Rules, Knowledge)**

A taxonomy of human performance developed by Jens Rasmussen:

• **Skill-based (S):** Automated, unconscious, smooth sensory-motor performance (e.g., riding a bike).

• **Rule-based (R):** Associative behavior based on "if-then" recipes or stored procedures.

• **Knowledge-based (K):** Slow, serial, analytical problem solving used in novel situations when rules fail.Effective design supports S and R levels to free up cognitive resources for K\[35\].

**Triadic Semiotics**

A model of meaning derived from C.S. Peirce, contrasting with the **Dyadic** (Saussure) model.

• **Dyadic:** Sign ↔ Idea (Meaning is in the head).

• **Triadic:** Object (Ecology) ↔ Sign (Interface) ↔ Interpretant (Agent).In the triadic view, meaning is an objective relation between the agent's capabilities and the environment's affordances, mediated by the interface\[38\].

**Work Domain Analysis (WDA)**

The first phase of Cognitive Work Analysis. It focuses on mapping the _constraints_ of the system (what _can_ be done) rather than the _tasks_ (what _is_ done). It is event-independent, making it useful for designing systems that can handle unanticipated events\[41\].

---
> [!info]- References
> [1] Flach - Playing twenty questions with nature the surprise version.pdf
> [5] Do Conversations Exist.pdf
> [9] Flach - Playing twenty questions with nature the surprise version.pdf
> [13] Flach - Playing twenty questions with nature the surprise version.pdf
> [16] Norman 2015 - DesignX Complex sociotechnical systems.pdf
> [19] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf
> [22] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf
> [25] Flach 2011 - Complexity learning to muddle through.pdf
> [28] Flach 2011 - Complexity learning to muddle through.pdf
> [31] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf
> [35] Do Conversations Exist.pdf
> [38] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf
> [41] Flach 2015 - The Semiotic contxt for Systems Engineering.pdf


FILE: 'John Warfield.md'
---
exported: 2026-02-07T17:24:27.178Z
source: NotebookLM
type: chat
title: John Warfield on 💬Keywords and Jargon
tags:
  - Keywords
  - John-Warfield
author: John Warfield
---
Based on the provided sources, here are the key concepts, principles, and theories regarding John Warfield's Systems Science and Structural Modeling, presented as a keyword list followed by a detailed glossary.

### **Key Concepts and Keywords**

• **Foundations:** The Fundamental Triangle (Human Being, Thought, Language), Second-Order Thought, Linguistic Adjustments, Mental Models, The Domain of Science Model (DOSM).

• **Theories & Laws:** The Twenty Laws of Complexity, Law of Triadic Compatibility, Law of Requisite Variety (Ashby), Law of Gradation, Friedman’s Theorem (Non-conservation of consistency), Harary’s Theorem (Assured model consistency), Theorem of Necessity.

• **Methodologies:** Work Program of Complexity (WPOC), Interactive Management (IM), Interpretive Structural Modeling (ISM), Structural Integration Modeling (SIM), Nominal Group Technique (NGT), Basic Structural Modeling (BSM).

• **Group Pathologies:** Spreadthink, Groupthink, Clanthink, Structural Underconceptualization, Killer Assumptions.

• **Artifacts & Structures:** Problematique, Intent Structure, Priority Structure, Options Field, DELTA Chart, Influence Structure, Digraph (Directed Graph), Binary Matrix.

• **Infrastructure:** Corporate Observatorium, Situation Room, Context Statement.

\--------------------------------------------------------------------------------

### **Glossary of Terms**

**Basic Structural Modeling (BSM)**A component of structural modeling focused on abstract mathematical concepts (graphs, digraphs, logic) that carry no empirical or substantive information. It provides the rigorous mathematical foundation for interpreting structures\[1\],\[2\].

**Corporate Observatorium**A specialized facility or "situation room" designed to provide "continuing visibility" of the work products (charts, graphs, designs) generated during the Work Program of Complexity. It is used to educate implementers and maintain organizational coherence over time\[3\],\[4\],\[5\].

**Discovery & Resolution**The two primary phases of the **Work Program of Complexity**.

• **Discovery** consists of _Description_ (generating and clarifying the problem set) and _Diagnosis_ (structuring the problems to understand relations).

• **Resolution** consists of _Design_ (creating alternatives) and _Implementation_ (executing the design)\[6\],\[7\].

**Domain of Science Model (DOSM)**A model identifying the four distinct domains required for any science: Foundations, Theory, Methodology, and Applications. It emphasizes the flow of experience from the "Arena" (applications) back to the Foundations\[8\].

**Friedman’s Theorem of Non-Conservation of Model Consistency**A theorem stating that without rigorous constraints, the consistency of a model tends to degrade as it becomes more complex. This highlights the danger of unstructured group discussion and the necessity of mathematical aid\[9\],\[10\].

**Harary’s Theorem of Assured Model Consistency**A theorem used in ISM which guarantees that if a matrix is filled according to specific logical rules (like transitivity), the resulting structural model will be logically consistent. This allows the software to infer relationships and save the group time\[9\],\[10\].

**Interactive Management (IM)**The overarching system of management designed to resolve complexity. It integrates a group of knowledgeable people, a facilitator, specific methodologies (like ISM and NGT), and a computer support system to carry out the Work Program of Complexity\[11\],\[12\],\[13\].

**Interpretive Structural Modeling (ISM)**A computer-assisted learning process that enables a group to structure complex issues. It uses a **binary matrix** and **transitive logic** to help participants decide on relationships (e.g., "Does A aggravate B?") between pairs of elements. The output is a graphical model (digraph) representing the group's collective understanding\[14\],\[15\],\[16\].

**Killer Assumptions**Unjustified beliefs (e.g., "complexity is in the system, not the mind") which, if held by a group or leader, will "greatly inhibit the likelihood that human beings can resolve complexity"\[17\],\[18\].

**Law of Gradation**A law of complexity stating that knowledge and design should be "graded in stages," moving from the simplest stage to the most comprehensive. It suggests that humans cannot grasp the full complexity of a system instantly but must approach it incrementally\[19\],\[20\].

**Law of Requisite Variety**Derived from W.R. Ashby, this law states that the variety (complexity/capability) of the controlling system (or solution) must be at least as great as the variety of the system being controlled (or the problem)\[9\],\[21\].

**Law of Triadic Compatibility**A behavioral law stating that human conceptualization is most effective when dealing with sets of three items. It implies that to be "mind compatible," complex hierarchies should be broken down so that at any level, there are roughly three components (or indices related to the number 3), aiding short-term memory\[19\],\[22\].

**Linguistic Adjustments**The proposal that ordinary prose is inadequate for describing complex systems due to its linear nature. Warfield argues for a "metalanguage" (natural language) combined with an "object language" (mathematics/graphics) to create a valid "science of description"\[23\],\[24\].

**Nominal Group Technique (NGT)**A structured process for generating ideas (elements) from a group. It involves silent generation of ideas in writing, round-robin recording, serial clarification of ideas, and a voting process to select the most important items for further structuring\[25\],\[26\].

**Problematique**A specific type of interpretive structural model that displays the system of problems (or "mess") in a situation. It typically uses the relationship "aggravates" or "influences" to show how problems are interconnected, often revealing cycles of causality\[6\],\[27\].

**Spreadthink**A group pathology where the individual views of group members regarding the importance of problems are "spread all over the map." Data shows that without a methodology like ISM, groups rarely agree on the relative importance of issues, hindering collective action\[28\],\[29\].

**Structural Integration Modeling (SIM)**A component added by researchers (Simpson) to Warfield’s framework. SIM focuses on aligning the abstract mathematics of BSM with the empirical needs of ISM, often creating "Abstract Relation Types" (ART) to ensure the right math is used for the right linguistic relationship\[30\],\[31\].

**Transitivity**A logical property (If A relates to B, and B relates to C, then A relates to C) used by ISM software. It allows the computer to _infer_ answers to questions, significantly reducing the number of queries a group must answer to build a structure\[32\],\[33\].

**Work Program of Complexity (WPOC)**The "action image" or operational process of Warfield's Systems Science. It is a sequence of steps (Description, Diagnosis, Design, Implementation) designed to move a group from a state of confusion to a structured plan of action\[6\],\[34\],\[25\].

---
> [!info]- References
> [1] Simpson - Applied Natural Language Relationships.pdf
> [2] Simpson - Basic Structural Modeling.pdf
> [3] 17071793.pdf
> [4] 17071793.pdf
> [5] [Book] Warfield - An Introduction to Systems Science.pdf
> [6] 17071793.pdf
> [7] [Book] Warfield - An Introduction to Systems Science.pdf
> [8] Dialogic Design Science An Approach for Co-Creating Visionary Anticipation.pdf
> [9] 17071793.pdf
> [10] Warfield - Measuring Complexity.pdf
> [11] Laouris 2017 - Structured Democratic Dialogue.pdf
> [12] Simpson - Augmented Interactive Management.pdf
> [13] Warfield - What questions have been answered to study complexity.pdf
> [14] 04309336.pdf
> [15] Simpson - Augmented Interactive Management.pdf
> [16] Simpson - Structural Modeling Framework.pdf
> [17] Simpson - John Warfields System Science Principles and Laws.pdf
> [18] [Book] Warfield - An Introduction to Systems Science.pdf
> [19] Simpson - Complexity reduction A pragmatic approach.pdf
> [20] Simpson - John Warfields System Science Principles and Laws.pdf
> [21] Warfield 1999 - Twenty Laws of Complexity science applicable in organisations.pdf
> [22] Simpson - John Warfields System Science Principles and Laws.pdf
> [23] 17071793.pdf
> [24] Warfield 2004 - Linguistic adjustments.pdf
> [25] 25192047.pdf
> [26] Janes 1988 - Interpretive structural modelling a methodology for structuring complex issues.pdf
> [27] warfield 1999 - problematique.pdf
> [28] Warfield 1999 - Twenty Laws of Complexity science applicable in organisations.pdf
> [29] warfield 2007 - Spreadthink explaining ineffective groups.pdf
> [30] Simpson - Applied Natural Language Relationships.pdf
> [31] Simpson - Structural Modeling Framework.pdf
> [32] Simpson - Augmented Interactive Management.pdf
> [33] Simpson - Object Relations Clusters for Systems Analysis.pdf
> [34] 25192047.pdf


FILE: 'MC Jackson.md'
---
exported: '2026-02-01T00:27:15.044Z'
source: NotebookLM
type: chat
title: MC Jackson on 💬Keywords and Jargon
tags:
  - Keywords
  - MC-Jackson
author: MC Jackson
---

Based on the provided sources, the following is a comprehensive extraction of the key concepts, principles, and theories central to Systems Thinking, specifically focusing on the evolution from Total Systems Intervention (TSI) to Critical Systems Practice (CSP).

### **Part 1: Key Concepts and Keywords**

**Meta-Methodologies and Frameworks**

• **Total Systems Intervention (TSI):** A meta-methodology for creative problem solving that uses metaphors to select specific systems methodologies\[1\].

• **Critical Systems Practice (CSP):** The contemporary evolution of TSI, utilizing the **EPIC** framework (Explore, Produce, Intervene, Check) to guide intervention\[2\],\[3\].

• **System of Systems Methodologies (SOSM):** A classification matrix (grid) used to group problem contexts and match them with appropriate systems methodologies\[4\],\[5\].

**Core Theoretical Principles**

• **Critical Systems Thinking (CST):** The underpinning philosophy advocating for **Critical Awareness**, **Social Awareness**, **Pluralism**, and **Human Improvement/Emancipation**\[6\],\[7\],\[8\].

• **Complementarism:** The belief that different methodologies express different rationalities and should be used in partnership rather than isolation\[6\].

• **Pluralism:** The use of different systems theories, methodologies, and methods in combination to address complex problems\[9\],\[10\].

• **Habermas’s Human Interests:** The classification of human cognitive interests into **Technical** (control), **Practical** (understanding), and **Emancipatory** (freedom), which align with Hard, Soft, and Critical systems approaches respectively\[11\],\[12\].

**Systemic Metaphors (The "Lenses")**

• **Machine:** Organization as a closed, efficient mechanism\[13\].

• **Organism:** Organization as an open system focused on survival and adaptability\[14\].

• **Brain:** Organization focused on learning and cybernetics\[15\].

• **Culture:** Organization as shared meanings and values\[16\].

• **Coalition/Political:** Organization as a power struggle between interest groups\[17\],\[18\].

• **Psychic Prison:** Organization as a trap of mental models or oppression\[19\].

• **Carnival:** A postmodern metaphor emphasizing diversity and exception\[20\].

**The Problem Context (The SOSM Grid Dimensions)**

• **Simple vs. Complex Systems:** The nature of the system being observed\[21\].

• **Unitary vs. Pluralist vs. Coercive:** The relationship between the participants/stakeholders\[21\],\[22\].

\--------------------------------------------------------------------------------

### **Part 2: Glossary of Concepts, Principles, and Theories**

**A. General Systems Concepts**

**Boundary Judgments**The definition of what is included or excluded from a system analysis. Critical Systems Heuristics (CSH) argues that boundaries are not fixed in reality but are social constructs determined by the observer's values and knowledge\[23\],\[24\].

**Emergence**The concept that a system exhibits properties as a whole that are not present in its individual parts; "the whole is greater than the sum of its parts"\[25\].

**Feedback**A process where the behavior of one element feeds back to influence the element that initiated the behavior. This is central to System Dynamics and Cybernetics\[26\]. **Negative Feedback** stabilizes a system (balance), while **Positive Feedback** amplifies change (growth/decline)\[27\],\[28\].

**Homeostasis**The maintenance of a steady state or identity in a changing environment, a concept replacing the physics-based notion of equilibrium in biological and social systems\[29\],\[30\].

**Recursion**The principle that viable systems contain viable systems within them, and are themselves contained within wider viable systems, like nesting boxes\[31\].

\--------------------------------------------------------------------------------

**B. The Methodologies (The "Tools")**

**1\. Hard Systems Thinking (Functionalist/Type A)**

• **Definition:** Approaches (like Systems Engineering or Operational Research) that assume clear goals (unitary) and objective reality. They focus on optimization and efficiency\[32\],\[33\].

• **Key Concept:****Means-End Rationality**—The systematic pursuit of the most efficient means to achieve a defined end\[34\].

**2\. System Dynamics (SD) (Functionalist/Type A)**

• **Definition:** A methodology for understanding the behavior of complex systems over time using stocks, flows, and feedback loops\[35\],\[36\].

• **Key Concept:****Structure Causes Behavior**—The dynamic behavior of a system is principally caused by its internal structure and feedback loops rather than external events\[36\].

• **Key Concept:****System Archetypes**—Recurring patterns of structure (e.g., "limits to growth") that occur in various organizations\[37\].

**3\. Organizational Cybernetics / Viable System Model (VSM) (Functionalist/Type A)**

• **Definition:** A diagnostic tool based on the structure of the human nervous system, used to ensure an organization is "viable" (able to survive)\[38\],\[39\].

• **Key Concept:****Variety Engineering**—Managing the complexity (variety) of the environment by amplifying the system's management capabilities and attenuating the environment's complexity (based on Ashby's Law of Requisite Variety)\[40\].

• **Key Components:** Systems 1 (Operation), 2 (Coordination), 3 (Control), 4 (Intelligence/Future), and 5 (Policy/Identity)\[41\],\[42\].

**4\. Strategic Assumption Surfacing and Testing (SAST) (Interpretive/Type B)**

• **Definition:** A methodology for tackling "wicked problems" by revealing and challenging the underlying assumptions of different stakeholders\[43\].

• **Key Principle:****Adversarial/Dialectical**—The belief that the best way to test an assumption is to oppose it with a counter-assumption to generate a synthesis\[44\].

**5\. Interactive Planning (IP) (Interpretive/Type B)**

• **Definition:** A methodology that involves stakeholders in designing a desirable future and inventing ways to bring it about\[45\].

• **Key Concept:****Idealized Design**—Designing a system as if it were being created from scratch, subject only to being technologically feasible and operationally viable, to dissolve "messes" (systems of problems)\[46\].

**6\. Soft Systems Methodology (SSM) (Interpretive/Type B)**

• **Definition:** A learning-based approach for situations where goals are not defined. It compares the "real world" with conceptual models of "human activity systems"\[47\],\[48\].

• **Key Concept:****CATWOE**—A mnemonic for defining a system's root definition: **C**ustomers, **A**ctors, **T**ransformation, **W**eltanschauung (Worldview), **O**wners, **E**nvironmental constraints\[49\].

• **Key Concept:****Rich Pictures**—Cartoon-like representations of problem situations used to capture culture, conflict, and relationships\[50\].

**7\. Critical Systems Heuristics (CSH) (Emancipatory/Type C)**

• **Definition:** A methodology for uncovering the normative (value-based) content of system designs to ensure fairness and empower the affected\[51\].

• **Key Concept:****The 12 Boundary Questions**—A checklist distinguishing between those involved (planners) and those affected (witnesses), asking "what is" versus "what ought to be" regarding power, expertise, and legitimacy\[52\],\[53\].

**8\. Team Syntegrity (Emancipatory/Type C)**

• **Definition:** A structural approach to organizing non-hierarchical communication and democratic decision-making based on the geometry of an icosahedron\[54\],\[55\].

• **Key Principle:****Synergy + Tensegrity**—Creating a structure where information flows freely to all participants without a central controller, preventing information collapse\[54\].

\--------------------------------------------------------------------------------

**C. The Meta-Methodologies (The Process)**

**Total Systems Intervention (TSI)**An earlier meta-methodology designed to help practitioners select the right method. It operates in three phases:

1\. **Creativity:** Using metaphors (e.g., machine, brain, coalition) to view the organization from different angles\[1\],\[56\].

2\. **Choice:** Using the SOSM (Simple/Complex vs. Unitary/Pluralist/Coercive) to select the appropriate methodology (e.g., choosing SSM for a complex-pluralist problem)\[57\],\[58\].

3\. **Implementation:** Using the chosen methodology to effect change\[58\].

**Critical Systems Practice (CSP) and the EPIC Framework**The evolution of TSI into a more flexible, iterative cycle:

1\. **Explore (E):** Exploring the situation of interest using five systemic perspectives (mechanical, interrelationships, organismic, purposeful, societal/environmental) to identify primary issues\[59\].

2\. **Produce (P):** Producing an intervention strategy by appreciating the variety of systems approaches and choosing the appropriate methodologies/methods\[59\].

3\. **Intervene (I):** Flexibly using the chosen methodologies to engage with the situation\[59\].

4\. **Check (C):** Evaluating improvements and reflecting on the learning gained about the systems approaches used\[59\].

**Systemic Perspectives (in CSP)**Used during the "Explore" phase to view complexity:

• **Mechanical:** Viewing the system as a machine to identify efficiency issues\[59\].

• **Interrelationships:** Viewing connections and feedback loops (related to System Dynamics)\[60\].

• **Organismic:** Viewing the system as a living entity adapting to an environment (related to Cybernetics/VSM)\[59\].

• **Purposeful:** Viewing the system through the eyes of stakeholders with different goals (related to Soft Systems)\[59\].

• **Societal/Environmental:** Viewing the system's impact on fairness and the wider environment (related to Critical/Emancipatory systems)\[59\],\[61\].

---
> [!info]- References
> [1] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [2] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [3] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [4] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [5] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [6] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [7] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [8] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [9] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [10] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [11] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [12] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [13] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [14] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [15] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [16] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [17] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [18] [Book] Jackson - Systems Approaches to Management.pdf
> [19] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [20] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [21] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [22] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [23] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [24] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [25] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [26] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [27] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [28] [Book] Jackson - Systems Approaches to Management.pdf
> [29] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [30] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [31] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [32] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [33] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [34] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [35] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [36] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [37] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [38] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [39] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [40] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [41] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [42] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [43] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [44] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [45] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [46] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [47] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [48] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [49] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [50] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [51] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [52] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [53] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [54] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [55] [Book] Jackson - Critical Systems Thinking and the Management of Complexity Responsible Leadership for a Complex World.pdf
> [56] [Book] Jackson - Systems Approaches to Management.pdf
> [57] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [58] [Book] Jackson - Creative Problem Solving - Total Systems Intervention.pdf
> [59] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [60] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf
> [61] [Book] Jackson - Critical Systems Thinking - A practitioners guide.pdf


FILE: 'MOM.md'
---
exported: '2026-01-31T23:08:24.073Z'
source: NotebookLM
type: chat
title: MOM on 💬Keywords and Jargon
tags:
  - Keywords
author: MOM
---

Based on the conversations within the "Meeting of Minds" (MoM) group provided in the sources, I have extracted the key concepts, principles, and theories. The group differentiates heavily between "Systems Thinking" (as a transdisciplinary, multi-perspectival practice) and "Systematic/Process Thinking" (reductionist or mechanistic approaches).

Below are the **Keywords** followed by an **Attached Glossary** derived directly from the participants' definitions and debates.

### **Keywords**

**Core Concepts:**

• Transdisciplinary Practice

• Observer Dependency (Second-Order Cybernetics)

• POSIWID (Purpose Of The System Is What It Does)

• Mental Models vs. Reality

• Emergence

• Boundary Judgements

• Requisite Variety

• Mess (vs. Difficulty/Puzzle)

**MoM Group Principles:**

• Rigour & Vigour

• The 3 A's (Accurate, Accessible, Actionable)

• The 4 E's (Efficacy, Efficiency, Effectiveness, Ethics)

• The 3 C's (Curiosity, Creativity, Courage)

**Methodologies & Frameworks:**

• Critical Systems Thinking (CST)

• Viable System Model (VSM)

• Soft Systems Methodology (SSM)

• Critical Systems Heuristics (CSH)

• SODA (Strategic Options Development and Analysis)

**Critiques & Dichotomies:**

• Systemic vs. Systematic

• Process Thinking vs. Systems Thinking

• Producer-Focused Ideas (PFI)

• Machine Metaphor / Mechanical Systems

\--------------------------------------------------------------------------------

### **Glossary of Concepts and Principles**

**1\. Foundational Systems Concepts**

• **Systems Thinking (ST):** Described not as a single method, but as a "transdisciplinary practice" that thinks in wholes to inquire into, understand, and improve "purposeful human activity systems" (PHAS)\[1\]. It is a "meta-discipline" that embraces a family of interconnected ideas rather than a monopoly of one idea\[2\].

• **System vs. Reality:** A fundamental principle held by the group is that systems do not exist in the real world; they are "mental constructs" used to make sense of reality\[3\],\[4\]. A system is the "observation," not the thing being observed\[5\].

• **POSIWID:** An acronym for "The Purpose Of The System Is What It Does." It distinguishes between _purposeful_ behavior (intended activity by the actor) and _purposive_ behavior (a purpose attributed to a system by an observer)\[6\],\[7\]. It suggests that purpose is an emergent property rather than a fixed label\[8\].

• **Observer Dependency:** Drawing from Second-Order Cybernetics, this concept asserts that the variety of an observed system is dependent on the observer\[9\]. One cannot separate the observer from the observation; "anything said is said by an observer"\[10\].

• **Requisite Variety (Ashby's Law):** The principle that only variety can destroy (or absorb) variety\[11\]. To manage a complex system, the regulatory mechanism must have a variety (number of states/responses) equal to or greater than the system being controlled\[12\],\[13\].

• **Emergence:** Properties or behaviors that arise from the interactions of the parts of a system that cannot be predicted by analyzing the parts in isolation\[14\]. However, the group notes that identifying emergence is often an act of the observer selecting specific patterns\[15\].

• **Mess:** A term (derived from Ackoff) describing a system of problems that are interacting; they cannot be solved in isolation, only managed or dissolved\[1\],\[16\].

**2\. Meeting of Minds (MoM) Principles & Heuristics**

• **Rigour and Vigour:** A core tenet proposed by Harald Kreher. **Rigour** relates to the logic, purity, and theory of the discipline. **Vigour** relates to the application, practice, and spreading of wisdom. A practitioner needs both\[17\],\[1\].

• **The 3 A's:** A standard for communicating Systems Thinking proposed by Liam Mahon. Concepts must be **Accurate** (theoretically sound), **Accessible** (understandable to non-academics), and **Actionable** (useful in practice)\[18\],\[19\].

• **The 4 E's:** A value criteria ladder for assessing systems, often prioritized in this order: **Efficacy** (does it work?), **Efficiency** (resources used), **Effectiveness** (does it achieve value?), and **Ethics** (is it right?)\[20\],\[21\]. Some members add _Elegance_ or _Economy_ as additional E's\[22\],\[23\].

• **The 3 C's:** Traits required for learning and inquiry: **Curiosity**, **Creativity**, and **Courage**\[24\],\[25\].

• **Competence in Deployment:** The ability to know what, where, why, and how to use specific systems approaches, moving beyond "tool usage" to "tool making" or selecting the right approach for the context\[26\],\[27\].

**3\. Methodologies and Frameworks**

• **Critical Systems Thinking (CST):** An approach championed by Mike Jackson that employs "multi-methodology." It involves making an informed choice of systems methodologies (like VSM, SSM, etc.) based on their strengths and weaknesses to address different aspects of complexity\[28\],\[29\].

• **Viable System Model (VSM):** Based on Stafford Beer's work, it models the organizational structure required for an entity to maintain independent existence (viability)\[1\],\[30\]. It emphasizes recursion (systems within systems) and communication channels\[31\],\[32\].

• **Soft Systems Methodology (SSM):** Associated with Peter Checkland, this is a learning process for dealing with messy, ill-defined situations (Human Activity Systems) by comparing "real world" actions with conceptual models\[33\],\[34\].

• **Critical Systems Heuristics (CSH):** Associated with Werner Ulrich, this uses boundary questions (what is vs. what ought to be) to uncover the selectivity and value judgments inherent in any system design, focusing on those affecting vs. those affected\[35\],\[36\].

• **SODA (Strategic Options Development and Analysis):** A method using cognitive mapping to manage complex problems by exploring the different perspectives and meanings held by stakeholders\[37\].

**4\. Critiques and Dichotomies**

• **Systemic vs. Systematic:**

    ◦ _Systematic_ refers to methodical, step-by-step, linear thinking (often associated with process thinking or checklists)\[38\],\[39\].    ◦ _Systemic_ refers to thinking in terms of wholes, interrelationships, and feedback loops\[38\].    ◦ The group argues that while _Systematic_ consulting sells closed solutions to open problems, _Systemic_ consulting addresses the dynamic ecosystem\[38\],\[39\].
• **Process Thinking vs. Systems Thinking:** A major critique of the "Vanguard Method" (John Seddon) and Lean/Six Sigma. The group argues these are reductionist "process improvement" methods masquerading as Systems Thinking because they view organizations as mechanistic input-output machines rather than complex, purposeful systems\[40\],\[41\],\[42\].

• **Producer-Focused Ideas (PFI):** A term coined by Victor Newman to describe "bad ideas" or "quick fixes" sold by consultants/gurus. These ideas adhere to the surface mind, create a false sense of superiority, and avoid deep critique\[43\].

• **Cynefin (Critique):** The group is highly critical of the Cynefin framework (Dave Snowden), describing it as a categorization tool that confuses the observer's state of knowledge with the ontology of the system. They argue it often ignores the history of systems thinking (like cybernetics) and lacks a rigorous scientific spine\[44\],\[45\],\[46\].

• **DSRP (Critique):** Derek Cabrera's "Distinctions, Systems, Relationships, Perspectives." The group views this as "severe reductionism," attempting to strip rich systems traditions down to four abstract concepts, ignoring the different "language games" and theoretical foundations of established approaches\[47\],\[48\].

---
> [!info]- References
> [1] mom-all-csv.csv
> [2] mom-all-csv.csv
> [3] mom-all-csv.csv
> [4] mom-all-csv.csv
> [5] mom-all-csv.csv
> [6] mom-all-csv.csv
> [7] mom-all-csv.csv
> [8] mom-all-csv.csv
> [9] mom-all-csv.csv
> [10] mom-all-csv.csv
> [11] mom-all-csv.csv
> [12] mom-all-csv.csv
> [13] mom-all-csv.csv
> [14] mom-all-csv.csv
> [15] mom-all-csv.csv
> [16] mom-all-csv.csv
> [17] mom-all-csv.csv
> [18] mom-all-csv.csv
> [19] mom-all-csv.csv
> [20] mom-all-csv.csv
> [21] mom-all-csv.csv
> [22] mom-all-csv.csv
> [23] mom-all-csv.csv
> [24] mom-all-csv.csv
> [25] mom-all-csv.csv
> [26] mom-all-csv.csv
> [27] mom-all-csv.csv
> [28] mom-all-csv.csv
> [29] mom-all-csv.csv
> [30] mom-all-csv.csv
> [31] mom-all-csv.csv
> [32] mom-all-csv.csv
> [33] mom-all-csv.csv
> [34] mom-all-csv.csv
> [35] mom-all-csv.csv
> [36] mom-all-csv.csv
> [37] mom-all-csv.csv
> [38] mom-all-csv.csv
> [39] mom-all-csv.csv
> [40] mom-all-csv.csv
> [41] mom-all-csv.csv
> [42] mom-all-csv.csv
> [43] mom-all-csv.csv
> [44] mom-all-csv.csv
> [45] mom-all-csv.csv
> [46] mom-all-csv.csv
> [47] mom-all-csv.csv
> [48] mom-all-csv.csv


FILE: 'Max Boisot.md'
---
exported: '2026-01-31T20:22:12.421Z'
source: NotebookLM
type: chat
title: Max Boisot on 💬Keywords and Jargon
tags:
  - Keywords
  - Max-Boisot
author: Max Boisot
---
Based on the provided materials, the work of Max Boisot and his collaborators establishes a comprehensive framework for a **political economy of information**, treating knowledge as a dynamic asset that shapes organizational and societal evolution.

### **Key Keywords**

**I-Space**, **Social Learning Cycle (SLC)**, **Codification**, **Abstraction**, **Diffusion**, **Data/Information/Knowledge Distinction**, **Ashby Space**, **Requisite Variety**, **Gaussian vs. Paretian Ontology**, **Scalable Abduction**, **Markets**, **Bureaucracies**, **Clans**, **Fiefs**, **Entropy**, **Adaptive Tension**, **Boundary Objects**, **Network Capitalism**.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts, Principles, and Theories**

**1\. Core Informational Elements**

• **Data:** Discernible differences between physical states (energy, space, or time) that register with an agent\[1\].

• **Information:** Significant regularities extracted from data that have the capacity to modify an agent’s expectations or prior knowledge\[3\].

• **Knowledge:** A set of dispositions or expectations held by an agent that allows them to act in adaptive ways upon the physical world\[6\].

• **Codification:** The data-processing activity of creating and clarifying categories to distinguish phenomena and reduce "fuzziness"\[9\].

• **Abstraction:** The process of reducing the number of categories required to represent a phenomenon by identifying associations or correlations between them\[9\].

• **Diffusion:** The movement of information through a population of agents; its speed and reach are determined by the message's level of codification and abstraction\[14\].

**2\. The Information Space (I-Space)**

• **I-Space Framework:** A three-dimensional conceptual tool that maps knowledge assets based on their degree of **codification**, **abstraction**, and **diffusion**\[5\].

• **Paradox of Value:** The principle that structuring knowledge (codification/abstraction) increases its **utility** but also increases its **diffusibility**, which—once shared—erodes its **scarcity** and economic value\[19\].

• **Social Learning Cycle (SLC):** The six-stage process through which knowledge evolves in the I-Space: **Scanning** (detecting signals), **Problem Solving** (codifying), **Abstraction** (generalizing), **Diffusion** (sharing), **Absorption** (learning-by-doing), and **Impacting** (embedding in practice)\[23\].

**3\. Complexity and Strategic Management (The Ashby Space)**

• **Ashby’s Law of Requisite Variety:** The cybernetic principle that "only variety can destroy variety," meaning a system’s internal complexity must match its environmental complexity to be adaptive\[26\].

• **The Ashby Space:** A diagnostic map that partitions the environment into three regimes—**Ordered**, **Complex**, and **Chaotic**—based on the variety of external stimuli versus internal response capability\[30\].

• **Gaussian vs. Paretian Ontology:****Gaussian** refers to a world of stable averages and independent events; **Paretian** refers to a world of interdependent events, extreme outcomes, and power-law distributions\[33\].

• **Scalable Abduction:** An inferential logic used in complex regimes to reach the "best explanation" by examining heterogeneous facts to suggest a theory, specifically looking for "butterfly events" that scale up\[36\].

**4\. Institutional and Cultural Archetypes**

• **Bureaucracy:** A culture that handles structured (codified/abstract) information but restricts its diffusion to maintain central control\[39\].

• **Market:** A structure that operates with highly structured, highly diffused information (e.g., prices)\[39\].

• **Clan:** A non-hierarchical group that transacts via uncodified, concrete information shared only within an "in-group"\[40\].

• **Fief:** A structure based on uncodified, concrete information held by a single charismatic individual or small center of power\[39\].

• **Network Capitalism:** An institutional form (notably in China) that modernization produces when it decentralizes through **clans** rather than through **markets**\[46\].

**5\. Physical and Biological Principles**

• **Principle of Least Action:** The tendency of natural systems to minimize the consumption of energy, space, and time; in Boisot’s work, this is achieved by substituting data and information for physical resources\[49\].

• **Entropy:** The measure of disorder or the erasure of differences; Boisot identifies **Thermodynamic Entropy** (erasure of states), **Shannon Entropy** (erasure of symbols), and **Cognitive Entropy** (erasure of interpretive context)\[52\]\[53\].

• **Dissipative Structures:** Systems that maintain order by importing free energy and exporting entropy; Boisot applies this to institutional processes that absorb cognitive energy\[54\].

• **Boundary Objects:** Abstract or concrete entities (like a detector design) that allow heterogeneous groups to coordinate and "trade" knowledge without full consensus on all details\[57\].

---
> [!info]- References
> [1] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [3] [Book] Boisot - Explorations in Information Space.pdf
> [5] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [6] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [9] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [14] [Book] Boisot - Collisons and Collaboration - 2011.pdf
> [19] Boisot - exploiting the information space - a strategic perspective on information systems.pdf
> [23] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [26] 2006 Boisot, McKelvey(06)-Counter-terrorism as Neighborhood Watch.pdf
> [30] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [33] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [36] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [39] Boisot - exploiting the information space - a strategic perspective on information systems.pdf
> [40] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [46] Boisot,Child - 1996 - From Fiefs to Clans and Network Capitalism - Administrative Science Quarterly(Journal Article).pdf
> [49] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [52] [Book] Boisot - 1995 - Information space - Routledge.pdf
> [53] [Book] Boisot - Explorations in Information Space.pdf
> [54] 2010 Boisot, McKelvey(10)-Integrating Modernist and Postmodernist Perspectives on Organizations-A Complexity Science Bridge.pdf
> [57] Boisot - exploiting the information space - a strategic perspective on information systems.pdf


FILE: 'Mike McMaster.md'
---
exported: 2026-02-07T17:26:27.795Z
source: NotebookLM
type: chat
title: Mike McMaster on 💬Keywords and Jargon
tags:
  - Keywords
  - Mike-McMaster
aliases: ["Glossary of Key Concepts: The Praxis of Intelligent Organizations"]
linter-yaml-title-alias: "Glossary of Key Concepts: The Praxis of Intelligent Organizations"
author: Mike McMaster
---
I have extracted the key concepts from the sources in the form of keywords below. I have also initiated the creation of a **tailored report** that serves as the comprehensive, attached glossary you requested. You will be able to view this detailed glossary in your Studio tab shortly.

### **Keywords**

• **Complex Adaptive Systems (CAS)**

• **Organizational Intelligence**

• **Emergence**

• **Self-Organization**

• **Distributed Intelligence**

• **Strategic Intent**

• **Socially Constructed Reality**

• **Effective Complexity**

• **Chunking / Compression**

• **Human Capital (HC)**

• **Structural Capital**

• **Relational Capital**

• **Attractors / Selection Influences**

• **Pacing and Leading**

• **Framing**

• **Rapport**

• **Transition Period**

• **The Learning Loop**

• **Sensory Grounding**

• **Praxis**

# Glossary of Key Concepts: The Praxis of Intelligent Organizations

1. Foundational Complexity Theories

The following concepts establish the rigorous scientific and philosophical framework required to navigate the "Praxis Equation." These are the load-bearing theories that underpin the transition from mechanistic management to intelligent organizational design.

• **Complex Adaptive Systems (CAS):** These are intelligent, self-generating systems—ranging from biological organisms to multinational corporations—that survive by selecting and compressing information from their environment. In human organizations, the primary adaptive mechanism is the use of language and interpretation. The capacity of a CAS is measured specifically by the number of internal models of interpretation it can generate and hold; survival depends on the ability to maintain multiple, often conflicting, models simultaneously to account for environmental volatility.

• **Emergence:** This is the non-linear process by which new entities, laws, or phenomena come into existence through the interaction of existing elements, without the need for external input. Emergence cannot be explained by breaking a system into parts or using linear cause-effect models. It is the generative source of innovation and teamwork, occurring when the interplay of constituent parts produces a "whole" that is not recognizable as any single component.

• **The Arrow of Time:** This concept defines the progression of time as a movement toward increasing complexity or disorder (chaos). Using a motion picture metaphor: if the "film" shows a system moving toward greater complexity, higher organization, or increased chaos, it is running forward; if the system moves toward simplicity, the film is running backward. In organizations, time inevitably drives an accumulation of connections that must be managed to prevent the system from exceeding its own ability to process information.

• **Structural Coupling:** This represents the naturally occurring, integrated relationship between human beings and the larger universe, including social institutions. Individual intelligence is not an isolated trait but emerges from and occurs within the social institutions of a society. Consequently, as the institutions and organizations of a society become more intelligent, the individuals within them gain a expanded capacity for intelligence.

2. The Dynamics of "Accidents" and Patterns

Organizational evolution is dictated by the persistence of specific combinations of events and ideas. These "accidents" create the structural regularities of the current and future enterprise.

|Concept|Definition|Organizational Significance|
|---|---|---|
|**Undistinguished Accidents**|Combinations of elements or events that occur but fail to connect or integrate with the existing environment.|These represent failed initiatives or experiments that are destroyed by existing influences because they lack the necessary relationship to the "whole" required for persistence.|
|**Frozen/Embedded Accidents**|Accidental combinations that persist, integrate, and become part of the system’s permanent, regular structure.|These function as critical "branching points" in evolution. Once an accident becomes embedded (e.g., a core technology or legal structure), it limits the number of possible future states, dictating the organization's future trajectory.|
|**Principle of Embedded Accidents**|The theory that accidents persist not by chance, but because they "match" the space provided by the existing ecology.|For an event to "stick," it must connect to the existing social or economic regularities in a way that alters the whole. Understanding these allows executives to view current protocols as results of prior accidents rather than absolute truths.|

3. Principles of Intelligence and Information Compression

Intelligent organizations function by mastering the processing and simplification of information to enable effective action within an expanding universe of data.

**Principle of Compression** The process of using language to create brief, reliable distinctions that represent complex events. Compression is the heart of knowledge; it allows individuals to categorize vast amounts of data into usable patterns, making the world intelligible without being overwhelmed by intricate detail.

**Effective Complexity** The proficiency to understand the complex nature of a phenomenon and apply compressed models to produce successful results. This is strictly contrasted with a "Complicated" state, which refers to descriptions that are too long or contain too many disordered elements for effective use. To be effective, the complexity of a description must be reduced to its fundamental elements.

**The Principle of Increasing Complexity** The evolutionary trade-off where a system gains richness and diversity at the inevitable cost of simplicity. While emergent levels are more complex, organizations can maintain a "unique simplicity" by utilizing patterns of generalization to manage new connections and higher levels of organization.

**Shifting Focus from Material to Information** The transition from viewing the world as physical matter bound by forces to viewing it as fields of energy, information, and social construction. In this paradigm, even the most tangible organizational assets are seen as embodiments of thinking and the interplay of information interpreted through "wired-in" social practices.

4. Operational Framework for Organizational Transformation

Transformation requires moving away from "cookbooks" toward a rigorous application of design principles that support learning and self-generation.

The Praxis Equation

The essential marriage of theory and practice. **Directive for Action:** Execute management as a continuous, iterative process where theory determines action, and action—through rigorous testing and feedback—further refines and determines theory.

Source Documents (Core Texts)

The essential cognitive infrastructure required to maximize collective intelligence. **Directive for Action:** Construct core texts that function as primary cognitive infrastructure. These must define three minimum elements: fundamental values to guide personal behavior, strategic statements that uniquely define the business, and organizational design principles to guide the flow of energy and information.

Non-linear Hierarchies (Nested Levels)

Multiple, overlapping, and flexible structures based on complexity thresholds rather than command-and-control. **Directive for Action:** Distinguish between "nested levels" of complexity. A new level must emerge only when a "threshold of complexity" is passed—specifically when the time spent communicating interrupts the work more than it contributes to it. These levels must provide coordination without interfering with the operations of lower levels.

Action Learning

The primary vehicle for development within an intelligent system. **Directive for Action:** Mandate development through experimentation on real-world issues and reflection on experiences as they occur. Managers must shift from traditional training toward a specialized competence in level-specific dialogue and "learning by doing."

Distributed Intelligence

The design metaphor of the brain/nervous system, replacing centralized authority with distributed capability. **Directive for Action:** Implement the four fundamental design principles: (1) distribute accountability, information, and knowledge broadly; (2) increase internal and external connections to expand intelligence capacity; (3) decrease authority in favor of engagement and dialogue to enroll self-generating energy; and (4) foster shared understanding as the critical force behind coordinated action.

5. Socially Constructed Reality and Culture

Organizations maintain identity and navigate survival through the following social mechanisms:

• **Socially Constructed Reality:** The "whole" created and maintained by stories, metaphors, and social interaction. This provides a transparent picture of reality that allows complex communities to function without being paralyzed by thousands of intricate rules.

• **Organizational Culture:** The organization’s "own way of being," similar to an individual's personality. Its primary function is to support survival within its society by determining which actions are acceptable and who is permitted to participate.

• **New Guiding Metaphors:** As current social reality is constructed by language, new metaphors (e.g., living systems vs. machines) are essential correlates to modern science. These metaphors challenge the notion of a single "given" reality, opening the door for new organizational possibilities.

6. Alphabetical Quick-Reference Index

• **Action Learning:** Development through experimentation on real issues and reflection on the results.

• **Arrow of Time, The:** The observation that systems move forward toward greater complexity/chaos and backward toward simplicity.

• **Complex Adaptive Systems (CAS):** Intelligent systems that survive by generating and holding multiple models of interpretation.

• **Distributed Intelligence:** A design metaphor spreading accountability and knowledge throughout the system like a nervous system.

• **Effective Complexity:** The ability to understand complex phenomena and apply that knowledge; the opposite of being "complicated."

• **Emergence:** The non-linear process where new phenomena arise from the interaction of existing elements.

• **Frozen/Embedded Accidents:** Accidental combinations that persist, acting as branching points that limit future possibilities.

• **New Guiding Metaphors:** Linguistic tools required to create a social reality aligned with modern scientific thought.

• **Non-linear Hierarchies:** Nested levels of complexity that provide coordination without interference or command-and-control.

• **Organizational Culture:** An organization's unique personality and way of being that supports its survival.

• **Praxis Equation, The:** The continuous, iterative marriage of theoretical understanding with practical application.

• **Principle of Compression:** The use of language to reduce complex events into brief, reliable distinctions.

• **Principle of Embedded Accidents:** The rule that accidents persist only when they "match" the existing social or economic ecology.

• **Principle of Increasing Complexity:** The evolutionary trade-off where systems gain richness while sacrificing simplicity.

• **Shifting Focus from Material to Information:** The paradigm shift toward viewing organizations as flows of information and interpretation.

• **Socially Constructed Reality:** A shared picture of the "whole" created by stories, metaphors, and everyday social interaction.

• **Source Documents:** Core texts (Values, Strategy, Design Principles) providing the cognitive infrastructure for decision-making.

• **Structural Coupling:** The naturally occurring interdependence between humans, their social institutions, and the universe.

• **Undistinguished Accidents:** Combinations of events that fail to integrate or persist within the existing environment.


FILE: 'Nassim Nicholas Taleb.md'
---
exported: '2026-01-31T20:06:15.168Z'
source: NotebookLM
type: chat
title: Nassim Nicholas Taleb on 💬Keywords and Jargon
tags:
  - Keywords
  - Nicholas-Taleb
author: Nassim Nicholas Taleb
---
### Key Keywords

**Antifragility**, **Fragility**, **Robustness**, **The Triad**, **Black Swan**, **Convexity**, **Concavity**, **Barbell Strategy**, **Via Negativa**, **Iatrogenics**, **Skin in the Game**, **Precautionary Principle**, **Extremistan**, **Mediocristan**, **Green Lumber Fallacy**, **Turkey Problem**, **Optionality**, **Heuristics**, **Path Dependence**, **Environmental Consistency Confidence**.

\--------------------------------------------------------------------------------

### Attached Glossary of Key Concepts, Principles, and Theories

**Agency Problem**A situation in which a manager (agent) has the upside while transferring the downside or risks to the owners or society, leading to hidden fragility\[1\].

**Antifragility**A property of systems that actually **benefit from shocks, volatility, and disorder**\[2\]\[3\]. Unlike the robust, which remains the same, the antifragile improves with stress (e.g., the mythological Hydra)\[2\]\[4\].

**Barbell Strategy**A dual strategy that combines two extremes (extreme safety and extreme risk-taking) while **avoiding the "middle"**\[5\]\[6\]. This setup caps potential losses while leaving the upside open\[7\].

**Black Swan**Large-scale, unpredictable events of massive consequence that are retrospectively explainable but prospectively uncomputable\[8\]\[9\]. The "Turkey" is the observer who is both surprised and harmed by a Black Swan\[8\].

**Convexity and Concavity (Nonlinearity)**

• **Convexity:** A response where gains accelerate as a variable increases; this represents **antifragility** (a "smile")\[10\]\[11\].

• **Concavity:** A response where harm accelerates with intensity; this represents **fragility** (a "frown")\[10\]\[11\].

**Environmental Consistency Confidence (Mainelli)**An approach to risk management asserting that if an organization can predict incidents and losses based on statistical correlations with its environment, it possesses comprehension and control\[12\]\[13\].

**Extremistan vs. Mediocristan**

• **Extremistan:** A domain dominated by "fat tails" and Black Swans where a single observation can disproportionately impact the total (e.g., wealth, book sales)\[14\].

• **Mediocristan:** A domain dominated by thin tails where individual variations cancel out in the aggregate (e.g., human weight, height)\[14\]\[17\].

**Green Lumber Fallacy**The mistake of confusing **narrative knowledge** (theories, definitions) with **practical knowledge** (know-how and results)\[18\]\[19\]. Named after a trader who successfully traded "green lumber" while believing it was literally wood painted green\[20\].

**Heuristics**Simple, practical rules of thumb that are easier to implement than complex models\[21\]\[22\]. They are often evolved collective wisdom that is more robust than top-down theory\[23\]\[24\].

**Iatrogenics****Harm caused by the healer**\[6\]\[25\]. It refers to situations where a medical or policy intervention intended to help actually causes more damage than the original problem due to a denial of the system’s natural antifragility\[25\]\[26\].

**Lindy Effect**The principle that for nonperishable things (ideas, books, technologies), **additional life expectancy is proportional to their current age**\[27\]\[28\]. The longer something has been around, the longer it is expected to last\[29\].

**Optionality**The property of having the "right but not the obligation" to take a certain course of action\[30\]. It allows one to benefit from the positive side of uncertainty without being destroyed by the negative\[31\]\[32\].

**Path Dependence**A property where the **sequence of events matters** and the results of a process are sensitive to the route taken\[33\]. In human minds, it refers to the sequence of ideas where the first one often dominates\[34\].

**Precautionary Principle**A theory of decision-making stating that if an action carries a risk of **systemic ruin** (irreversible, global harm), it must be avoided regardless of potential benefits\[35\]\[36\]. The burden of proof of safety falls on the proposer\[35\].

**Skin in the Game**The ethical requirement that decision-makers must **share in the downside** of their actions\[37\]\[38\]. It is considered the only true mitigator of fragility and the only way to avoid transferring risks to others\[39\]\[40\].

**The Triad**A foundational classification system mapping things along a spectrum of three properties: **Fragile, Robust, and Antifragile**\[41\]\[42\].

**Turkey Problem**The failure to recognize that a period of safety or "consistent" data does not guarantee future safety, much like a turkey who uses 1,000 days of being fed to conclude the butcher is its best friend, right until Thanksgiving\[43\]\[44\].

**Via Negativa**The principle of **improvement through subtraction**\[28\]\[45\]. It posits that we know what is wrong with more certainty than what is right; therefore, removing fragilities is more robust than adding features\[46\]\[47\].

---
> [!info]- References
> [1] [Book] Taleb - Antifragile.pdf
> [2] [Book] Taleb - Antifragile.pdf
> [3] [Book] Taleb - Antifragile.pdf
> [4] [Book] Taleb - Antifragile.pdf
> [5] [Book] Taleb - Antifragile.pdf
> [6] [Book] Taleb - Antifragile.pdf
> [7] [Book] Taleb - Antifragile.pdf
> [8] [Book] Taleb - Antifragile.pdf
> [9] [Book] Taleb - Antifragile.pdf
> [10] [Book] Taleb - Antifragile.pdf
> [11] [Book] Taleb - Antifragile.pdf
> [12] Risk-case-study.md
> [13] Risk-case-study.md
> [14] [Book] Taleb - Antifragile.pdf
> [17] [Book] Taleb - Antifragile.pdf
> [18] [Book] Taleb - Antifragile.pdf
> [19] [Book] Taleb - Antifragile.pdf
> [20] [Book] Taleb - Antifragile.pdf
> [21] [Book] Taleb - Antifragile.pdf
> [22] [Book] Taleb - Antifragile.pdf
> [23] [Book] Taleb - Antifragile.pdf
> [24] [Book] Taleb - Antifragile.pdf
> [25] [Book] Taleb - Antifragile.pdf
> [26] [Book] Taleb - Antifragile.pdf
> [27] [Book] Taleb - Antifragile.pdf
> [28] [Book] Taleb - Antifragile.pdf
> [29] [Book] Taleb - Antifragile.pdf
> [30] [Book] Taleb - Antifragile.pdf
> [31] [Book] Taleb - Antifragile.pdf
> [32] [Book] Taleb - Antifragile.pdf
> [33] [Book] Taleb - Antifragile.pdf
> [34] [Book] Taleb - Fooled by randomness.pdf
> [35] taleb - pp2.pdf
> [36] taleb - pp2.pdf
> [37] [Book] Taleb - Antifragile.pdf
> [38] [Book] Taleb - Antifragile.pdf
> [39] [Book] Taleb - Antifragile.pdf
> [40] [Book] Taleb - Antifragile.pdf
> [41] [Book] Taleb - Antifragile.pdf
> [42] [Book] Taleb - Antifragile.pdf
> [43] [Book] Taleb - Antifragile.pdf
> [44] [Book] Taleb - Antifragile.pdf
> [45] [Book] Taleb - Antifragile.pdf
> [46] [Book] Taleb - Antifragile.pdf
> [47] [Book] Taleb - Antifragile.pdf


FILE: 'Neil Postman.md'
---
exported: '2026-01-31T20:01:38.050Z'
source: NotebookLM
type: chat
title: Neil Postman on 💬Keywords and Jargon
tags:
  - Keywords
  - Neil-Postman
author: Neil Postman
---
### Key Concepts, Principles, and Theories

• **Media as Epistemology**\[1\]\[2\]

• **Technopoly**\[3\]

• **The Medium is the Metaphor**\[1\]\[6\]

• **Age of Show Business**\[1\]

• **Semantic Environment**\[9\]\[10\]

• **Crazy Talk vs. Stupid Talk**\[9\]

• **Information Glut (Anti-Information Deficiency Syndrome - AIDS)**\[13\]\[14\]

• **Scientism**\[15\]

• **Meta-semantics**\[18\]\[19\]

• **The Loving Resistance Fighter**\[15\]

• **Propaganda (Postman's Definition)**\[22\]\[23\]

• **Post-Truth Epistemology**\[24\]\[25\]

• **Reification**\[9\]

• **Knowledge Monopolies**\[28\]

• **The Ascent of Humanity**\[29\]\[30\]

\--------------------------------------------------------------------------------

### Attached Glossary

**Age of Show Business:** A cultural stage, dominated by television, where **all public discourse (politics, religion, news) is transformed into entertainment**\[7\]\[8\]. In this age, the "Now... this" philosophy separates events from each other, rendering them incoherent and stripping them of serious context\[31\]\[32\].

**Age of Typography:** A period characterized by a **print-based culture** where discourse was generally coherent, serious, and rational\[33\]. This age fostered the "Typographic Mind," which valued **logic, sequence, detachment, and objectivity**\[34\].

**Crazy Talk:** Language that may be **entirely effective** in its delivery but serves **unreasonable, evil, or overwhelmingly trivial purposes**\[12\]\[35\]. It is characterized by an **attack on reason** and the creation of an irrational context for human interaction\[12\]\[36\].

**Information Glut (AIDS):** A state of **cultural Anti-Information Deficiency Syndrome** where the defences against information break down, and the tie between **information and human purpose is severed**\[13\]\[14\]. Information becomes "garbage," incapable of answering fundamental human questions\[14\].

**The Loving Resistance Fighter:** An individual who maintains a **psychic and epistemological distance from technology** so that it always appears strange and never natural or inevitable\[21\]. These individuals refuse to accept efficiency as the pre-eminent goal of human relations and take the great narratives of history and religion seriously\[37\]\[38\].

**Media as Epistemology:** The theory that **definitions of truth are derived from the character of the media** through which information is conveyed\[2\]. Each medium provides a unique mode of discourse by providing a new orientation for thought and expression\[39\].

**The Medium is the Metaphor:** The principle that **media forms act as metaphors** that unobtrusively but powerfully enforce specific definitions of reality\[40\]. Unlike a direct message, a media-metaphor classifies, frames, and enlarges the world for us\[41\].

**Meta-semantics:** A discipline through which individuals psychologically position themselves **outside the context of a semantic environment** to assess the "whys and hows" of communication\[19\]\[42\]. It focuses on the **relationships between what is said and the rules of the environment**\[42\].

**Post-Truth Epistemology:** A landscape where **facts and information are less influential** in shaping opinion than appeals to **emotion and personal belief**\[24\]. This is often driven by mistrust in institutions and the dominance of algorithmic content curation\[24\]\[43\].

**Propaganda:** Defined by Postman as **"language that invites us to respond emotionally, emphatically, more or less immediately, and in an either-or manner"**\[22\]\[23\]. It is distinct from language that stimulates curiosity or causes us to ask questions\[23\].

**Reification:** The logical error of **confusing words with things** or treating an abstract idea (like "intelligence") as a physical thing (like the "pancreas")\[26\]\[27\]. This process is often facilitated by the "is" of projection\[27\]\[44\].

**Scientism:** The desperate and illusory belief that **standardized procedures called "science" can provide an unimpeachable source of moral authority**\[17\]. It assumes that the methods of natural sciences can be applied without modification to the social world\[45\].

**Semantic Environment:** A multifaceted social situation consisting of **people, their purposes, and the rules of discourse** by which those purposes are achieved\[10\]. Language is "stupid" when it fails to recognize the environment it is in\[46\].

**Stupid Talk:** Talk that has a **confused direction, inappropriate tone, or vocabulary ill-suited to its context**, thereby failing to achieve its legitimate purposes\[11\]. It is viewed as an **individual mistake in performance** that is generally correctable\[11\]\[47\].

**Technopoly:** A **"totalitarian technocracy"** where technology pre-empts all other forms of authority and renders traditional narratives and symbols invisible\[5\]. It consists of the **deification of technology**, where culture seeks its authorization and orders from technological systems\[48\].

**Tool-Using Culture:** A culture where tools are invented to **solve specific physical problems or serve the symbolic world** (myth, ritual, religion) without attacking the culture’s underlying integrity\[49\]. In these cultures, **theology or metaphysics provides the primary order and meaning** to existence\[50\].

---
> [!info]- References
> [1] [Book] Postman - Amusing Ourselves to Death.pdf
> [2] [Book] Postman - Amusing Ourselves to Death.pdf
> [3] PressThink_ Neil Postman (1931-2003)_ Some Recollections.pdf
> [5] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [6] [Book] Postman - Amusing Ourselves to Death.pdf
> [7] [Book] Postman - Amusing Ourselves to Death.pdf
> [8] [Book] Postman - Amusing Ourselves to Death.pdf
> [9] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [10] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [11] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [12] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [13] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [14] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [15] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [17] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [18] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [19] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [21] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [22] Hobbs 2022 Postman's Legacy  ETC.pdf
> [23] Postman - Propaganda.pdf
> [24] Hobbs 2022 Postman's Legacy  ETC.pdf
> [25] Hobbs 2022 Postman's Legacy  ETC.pdf
> [26] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [27] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [28] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [29] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [30] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [31] [Book] Postman - Amusing Ourselves to Death.pdf
> [32] [Book] Postman - Amusing Ourselves to Death.pdf
> [33] [Book] Postman - Amusing Ourselves to Death.pdf
> [34] [Book] Postman - Amusing Ourselves to Death.pdf
> [35] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [36] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [37] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [38] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [39] [Book] Postman - Amusing Ourselves to Death.pdf
> [40] [Book] Postman - Amusing Ourselves to Death.pdf
> [41] [Book] Postman - Amusing Ourselves to Death.pdf
> [42] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [43] Hobbs 2022 Postman's Legacy  ETC.pdf
> [44] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [45] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [46] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [47] [Book] Postman - Crazy Talk Stupid Talk.pdf
> [48] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [49] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf
> [50] [Book] Postman - Technopoly The Surrender of Culture to Technology.pdf


FILE: 'Niklas Luhmann.md'
---
exported: '2026-02-01T00:25:49.382Z'
source: NotebookLM
type: chat
title: Niklas Luhmann on 💬Keywords and Jargon
tags:
  - Keywords
  - Niklas-Luhmann
author: Niklas Luhmann
---

Based on the provided sources, here are the key concepts, principles, and theories organized into a structured list of keywords followed by a comprehensive glossary. The material is drawn from Niklas Luhmann’s systems theory (covering general systems, social systems, and organizations) and Professor Michael Mainelli’s work on risk management.

### **Part 1: Key Concepts and Keywords**

**General Systems Theory & Epistemology**

• System/Environment Difference

• Autopoiesis

• Operational Closure

• Structural Coupling

• Complexity (and Complexity Reduction)

• Observation (Distinction and Indication)

• Re-entry

• Self-Reference (Basal, Processual, Reflection)

• Constructivism

**Social Systems & Communication**

• Communication (Information, Utterance, Understanding)

• Double Contingency

• Meaning (_Sinn_)

• Interpenetration

• Psychic Systems vs. Social Systems

• Expectation (Normative vs. Cognitive)

**Organization & Decision Theory**

• Organization (as Autopoietic System of Decisions)

• Decision

• Paradox of Decision-Making

• Uncertainty Absorption

• Decision Premises

• Decision Programs (Conditional vs. Purposive)

• Membership

**Risk Management & Scientific Management**

• Scientific Management (Taylorism)

• Environmental Consistency Confidence (ECC)

• Key Risk Indicators (KRIs) vs. Risk Indicators (RIs)

• Abductive Reasoning

• Falsifiability

\--------------------------------------------------------------------------------

### **Part 2: Glossary of Terms**

**A. Systems Theory Foundations**

**Autopoiesis**A concept originally coined by Maturana and Varela for biological systems, defined as a system's ability to produce and reproduce its own elements and boundaries through its own operations\[1\],\[2\]. In Luhmann’s theory, this concept is abstracted to include social systems (which reproduce communications) and psychic systems (which reproduce thoughts), meaning the system produces everything it uses as a unit\[3\],\[4\].

**Complexity**A state where a system or environment contains more elements and relations than can be connected at any one time, enforcing selectivity\[5\]. Complexity compels the system to select specific relations and exclude others, which implies contingency and risk\[5\]. A system must reduce environmental complexity (by forming structures) to build up its own internal complexity\[6\].

**Observation**The operation of making a distinction and indicating one side of that distinction (and not the other)\[7\]. Observation is not a psychic subject's privilege but an operation of the system itself; a system observes itself by distinguishing itself from its environment\[8\],\[9\].

**Operational Closure**The principle that a system operates exclusively within its own boundaries and cannot use its operations to intervene in the environment, nor can the environment operate directly within the system\[10\],\[11\]. Closure is the condition for openness; because the system is closed, it can construct a specific sensitivity to environmental stimuli\[12\],\[13\].

**Re-entry**A concept from George Spencer-Brown’s calculus of forms referring to the reintroduction of a distinction into what is distinguished by it\[14\]. For example, the distinction between system and environment is copied back into the system, allowing the system to observe itself\[15\],\[16\].

**Structural Coupling**The mechanism by which operationally closed systems relate to their environment\[17\]. It does not determine the system’s operations but acts as a source of irritation or perturbation that the system processes according to its own structures\[18\]. For example, the "eye" does not see the environment directly but operates via neurophysiological impulses triggered by light (structural coupling)\[19\],\[20\].

**System/Environment Difference**The constitutive distinction of systems theory; a system is not an object but the difference between itself and its environment\[17\]. The environment is always more complex than the system, and the system maintains itself by stabilizing a boundary and managing this complexity difference\[18\],\[21\].

**B. Social Systems and Meaning**

**Communication**The fundamental element of social systems, not human beings or actions\[4\]. It is a synthesis of three selections: information (what is conveyed), utterance (how it is conveyed), and understanding (the distinction between information and utterance)\[19\]. Communication is an autopoietic operation that produces further communication\[22\].

**Double Contingency**The fundamental problem of social order where two systems (black boxes) encounter each other, and each makes their behavior dependent on the other, leading to infinite indeterminacy\[23\]. Social systems emerge to solve this problem by fixing expectations and reducing indeterminacy, often catalyzed by a "concession of freedom" or trust\[24\],\[25\].

**Interpenetration**A relationship where systems (specifically psychic and social systems) contribute their own complexity to each other while remaining environments for one another\[26\]. It explains how human consciousness and social systems are structurally coupled and mutually enabling without merging\[27\],\[28\].

**Meaning (****Sinn****)**The medium through which psychic and social systems process complexity\[4\]. It is defined phenomenologically as the "horizon of possibilities" virtually present in every actualization; it allows a system to experience the difference between what is actual and what is possible\[4\]. Meaning ensures that systems cannot lose themselves in the environment because meaning always refers to further meaning\[29\].

**Psychic Systems**Distinct from social systems, these are autopoietic systems that reproduce themselves through consciousness (thoughts) rather than communication\[30\],\[31\]. They belong to the environment of social systems, not the system itself\[32\].

**C. Organization and Decision**

**Decision**The specific operation that generates and reproduces organizations\[33\]. A decision is an observation that fixes a difference between the past (which is unalterable) and the future (which is unknown), transforming open contingency into closed contingency\[34\],\[35\]. Every decision communicates that it could have been made otherwise, thus generating the need for further decisions\[36\],\[37\].

**Decision Premises**Structures within an organization that guide future decisions, thereby reducing complexity and absorbing uncertainty\[38\]. They serve as conditions for the "correctness" of decisions and include decision programs, communication channels, and personnel\[33\],\[39\].

**Decision Programs**A type of decision premise. They can be **Conditional Programs** (if X happens, then do Y), which focus on input and past facts\[40\], or **Purposive Programs** (goals/means), which focus on output and future effects, requiring causal planning\[41\],\[42\].

**Organization**A specific type of autopoietic social system that consists of decisions and reproduces itself through the communication of decisions\[43\]. It distinguishes itself by using membership as a condition for participation\[44\].

**Paradox of Decision-Making**The concept that a decision is a choice between alternatives where the decision itself is not one of the alternatives but the selection of a distinction\[45\]. The paradox lies in the fact that the decision-maker must choose even though the future is unknown, often resolving this by attributing the decision to a "subject" or "authority" to hide the lack of ultimate justification\[46\],\[47\].

**Uncertainty Absorption**A process where inferences are drawn from evidence, and only the inferences (not the evidence) are communicated to the next stage\[48\]. This connects decisions to one another and is essential for the autopoiesis of organizations, as it transforms uncertainty into the certainty required for subsequent decisions\[33\],\[49\].

**D. Risk and Scientific Management**

**Abductive Reasoning**A creative form of reasoning used in the scientific method that generates hypotheses to best explain observations (distinct from inductive or deductive reasoning)\[50\].

**Environmental Consistency Confidence (ECC)**A risk management approach that uses statistical correlation to predict incidents and losses based on environmental and activity data. If outcomes (losses) correlate with inputs (environment/activity), the organization is "consistent" with its environment\[51\],\[52\].

**Falsifiability**The principle, attributed to Karl Popper, that a theory or hypothesis is scientific only if it provides the means for its own refutation; scientific theories are transient, not immutable truths\[53\].

**Key Risk Indicators (KRIs)**Regular measurement data (statistics/metrics) shown to have _predictive capability_ for estimating future losses and incidents\[54\],\[55\]. If an indicator does not predict losses, it is merely a "risk indicator" (RI), not a "Key" one\[55\].

**Scientific Management**A paradigm promoted by Frederick Winslow Taylor aiming to systematize management through rigorous observation, experimentation, and the application of the scientific method to improve organizations\[56\]. It involves gathering data, hypothesizing, deducing predictions, and testing them experimentally\[57\].

---
> [!info]- References
> [1] [Book] Luhmann - Introduction to Systems Theory.pdf
> [2] [Book] Luhmann - Introduction to Systems Theory.pdf
> [3] [Book] Luhmann - Social Systems (Writing Science).pdf
> [4] [Book] Luhmann - Social Systems (Writing Science).pdf
> [5] [Book] Luhmann - Social Systems (Writing Science).pdf
> [6] [Book] Luhmann - Social Systems (Writing Science).pdf
> [7] [Book] Luhmann - Introduction to Systems Theory.pdf
> [8] [Book] Luhmann - Introduction to Systems Theory.pdf
> [9] [Book] Luhmann - Introduction to Systems Theory.pdf
> [10] [Book] Luhmann - Introduction to Systems Theory.pdf
> [11] [Book] Luhmann - Introduction to Systems Theory.pdf
> [12] [Book] Luhmann - Introduction to Systems Theory.pdf
> [13] [Book] Luhmann - Organization and Decision.pdf
> [14] [Book] Luhmann - Organization and Decision.pdf
> [15] [Book] Luhmann - Introduction to Systems Theory.pdf
> [16] [Book] Luhmann - Organization and Decision.pdf
> [17] [Book] Luhmann - Introduction to Systems Theory.pdf
> [18] [Book] Luhmann - Introduction to Systems Theory.pdf
> [19] [Book] Luhmann - Social Systems (Writing Science).pdf
> [20] [Book] Luhmann - Social Systems (Writing Science).pdf
> [21] [Book] Luhmann - Introduction to Systems Theory.pdf
> [22] [Book] Luhmann - Social Systems (Writing Science).pdf
> [23] [Book] Luhmann - Social Systems (Writing Science).pdf
> [24] [Book] Luhmann - Social Systems (Writing Science).pdf
> [25] [Book] Luhmann - Social Systems (Writing Science).pdf
> [26] [Book] Luhmann - Social Systems (Writing Science).pdf
> [27] [Book] Luhmann - Introduction to Systems Theory.pdf
> [28] [Book] Luhmann - Social Systems (Writing Science).pdf
> [29] [Book] Luhmann - Social Systems (Writing Science).pdf
> [30] [Book] Luhmann - Introduction to Systems Theory.pdf
> [31] [Book] Luhmann - Introduction to Systems Theory.pdf
> [32] [Book] Luhmann - Introduction to Systems Theory.pdf
> [33] [Book] Luhmann - Organization and Decision.pdf
> [34] [Book] Luhmann - Organization and Decision.pdf
> [35] [Book] Luhmann - Organization and Decision.pdf
> [36] [Book] Luhmann - Organization and Decision.pdf
> [37] [Book] Luhmann - Organization and Decision.pdf
> [38] [Book] Luhmann - Organization and Decision.pdf
> [39] [Book] Luhmann - Organization and Decision.pdf
> [40] [Book] Luhmann - Organization and Decision.pdf
> [41] [Book] Luhmann - Organization and Decision.pdf
> [42] [Book] Luhmann - Organization and Decision.pdf
> [43] [Book] Luhmann - Organization and Decision.pdf
> [44] [Book] Luhmann - Organization and Decision.pdf
> [45] [Book] Luhmann - Organization and Decision.pdf
> [46] [Book] Luhmann - Organization and Decision.pdf
> [47] [Book] Luhmann - Organization and Decision.pdf
> [48] [Book] Luhmann - Introduction to Systems Theory.pdf
> [49] [Book] Luhmann - Organization and Decision.pdf
> [50] Risk-case-study.md
> [51] Risk-case-study.md
> [52] Risk-case-study.md
> [53] Risk-case-study.md
> [54] Risk-case-study.md
> [55] Risk-case-study.md
> [56] Risk-case-study.md
> [57] Risk-case-study.md


FILE: 'OU Course.md'
---
exported: 2026-02-07T16:15:16.730Z
source: NotebookLM
type: chat
title: OU Course on 💬Keywords and Jargon
tags:
  - Keywords
  - OU-Course
author: OU Course
---
Based on the provided sources, here are the key concepts, principles, and theories extracted from the Open University Systems courses (T301, T306, B822) and the Cybersemiotics readings.

### **Key Concepts and Keywords**

**1\. Nature of Problems**

• **Mess:** Ill-defined, unbounded problems with no clear solution; a system of problems\[1\],\[2\].

• **Difficulty:** Bounded problems with clear priorities and recognizable solutions\[1\].

• **Wicked Problems:** Complex problems involving uncertainty, ambiguity, and societal constraints\[3\].

• **Problem Owner:** The person or group concerned with or affected by the situation\[4\].

**2\. Systems Thinking & Approaches**

• **Holism:** Viewing the "whole" rather than just the parts; recognizing that the whole has properties the parts do not have\[5\],\[6\].

• **Systemic vs. Systematic:**

    ◦ _Systematic:_ Step-by-step, linear, reductionist\[7\],\[8\].    ◦ _Systemic:_ Holistic, focused on relationships, feedback, and emergence\[7\],\[8\].
• **Hard Systems:** Approaches (like Systems Engineering) used when objectives are clear and quantifiable\[9\],\[10\].

• **Soft Systems:** Approaches used when objectives are unclear and different worldviews exist\[11\],\[12\].

• **Failures Approach:** Investigating "why" something went wrong by comparing reality against a formal system model\[13\],\[14\].

**3\. Methodology Tools**

• **Rich Picture:** A graphical summary of a situation including facts, soft information, and relationships\[15\],\[16\].

• **CATWOE:** A mnemonic (Customers, Actors, Transformation, Weltanschauung, Owners, Environment) used to formulate root definitions\[17\],\[18\].

• **Root Definition:** A concise description of what a system is (A system to do X, by Y, in order to achieve Z)\[19\].

• **Multiple Cause Diagram:** A diagram mapping the causal chains contributing to an event\[20\],\[21\].

**4\. Creativity and Cognition**

• **Metaphor:** Using one concept to understand another (e.g., organization as a machine vs. organism)\[22\],\[23\].

• **Reframing:** Changing the conceptual frame or label applied to a situation to solve it\[24\].

• **Tacit Knowledge:** Unconscious ways of knowing and assimilating knowledge\[25\].

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**Autopoiesis**A concept describing systems that are self-producing and self-organizing. In cybersemiotics, this relates to the self-referring observership derived from second-order cybernetics\[26\].

**Boundary**The dividing line between a system and its environment. It is a mental construct decided by the observer, determining what is inside the system (controllable) and what is outside (environment)\[27\],\[28\].

**CATWOE**A checklist used to verify the completeness of a Root Definition in Soft Systems Methodology\[18\]:

• **C (Customers):** Victims or beneficiaries of the transformation.

• **A (Actors):** Those who perform the activities.

• **T (Transformation):** The conversion of input to output.

• **W (Weltanschauung):** The worldview making the transformation meaningful.

• **O (Owners):** Those who can stop the activity.

• **E (Environmental constraints):** Elements outside the system taken as given.

**Cybersemiotics**A transdisciplinary perspective integrating cybernetics (information theory) and semiotics (sign processes) to address knowledge production, cognition, and communication\[26\].

**Emergence**The phenomenon where a system exhibits properties as a whole that are not found in its component parts (e.g., the wetness of water is not found in hydrogen or oxygen)\[29\],\[7\].

**Environment**The context surrounding a system. It affects the system but is not controlled by it. In sustainable development, this can refer to the ecological/biophysical environment or the broader systemic context\[27\],\[30\].

**Formal System Model**A paradigm used in the Failures Approach to compare against real-world situations. It includes a decision-making subsystem, a performance-monitoring subsystem, and defined objectives\[31\],\[32\].

**Hard Systems Approach**An approach applied to problems where goals can be clearly specified, performance monitored, and implementation achieved. It is often associated with Systems Engineering and Aids to Decision Making (ADM)\[10\],\[33\].

**Human Activity System**A system where the elements are human activities. These are abstract models used in Soft Systems Methodology to explore real-world situations, not descriptions of the real world itself\[34\],\[35\].

**Juggler Metaphor**A model for the systems practitioner who must keep four "balls" in the air:

• **Being:** Awareness of one's own tradition and ethics.

• **Engaging:** Interacting with the real-world situation.

• **Contextualizing:** Choosing the right approach.

• **Managing:** Handling the overall performance and change\[36\].

**Mess**A system of external problems that are interconnected, unbounded, and have a longer, uncertain timescale. Messes cannot be "solved" like puzzles; they require management and learning\[1\].

**Rich Picture**A cartoon-like diagram used at the start of an investigation to capture the "hard" (structures) and "soft" (feelings, conflict) aspects of a situation without imposing a rigid structure\[11\],\[16\].

**Root Definition**A statement describing the core purpose of a purposeful activity system. It follows the structure: "A system to do P (what) by Q (how) in order to achieve R (why)"\[37\],\[38\].

**Soft Systems Methodology (SSM)**A learning-oriented approach for messy, ill-defined problem situations where there are conflicting worldviews. It uses "systems" as mental tools to structure debate rather than seeing them as entities existing in the real world\[11\],\[39\].

**Systemic vs. Systematic****Systematic** thinking is reductionist and linear (step-by-step analysis). **Systemic** thinking focuses on the whole, relationships, feedback loops, and emergence\[7\].

**3 Es (Measures of Performance)**Criteria used to judge the success of a transformation in SSM\[37\]:

• **Efficacy:** Does the means work?

• **Efficiency:** Is it done with minimum resources?

• **Effectiveness:** Does it achieve the longer-term goal?

**Weltanschauung**German for "worldview." It refers to the set of beliefs, values, and assumptions that make a particular Root Definition or system meaningful to an observer\[18\],\[40\].

---
> [!info]- References
> [1] IERC - systems thinking for managing change.pdf
> [2] T301 Block IV - Soft Systems Analysis.pdf
> [3] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [4] block_4_full.pdf
> [5] OU T306 Managing Complexity Block 1.pdf
> [6] T301 Block I - Introduction.pdf
> [7] Managing complexity - A systems approach - Introduction.pdf
> [8] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [9] Managing complexity - A systems approach - Introduction.pdf
> [10] T301 Block IIIa - Systems Models - 1 of 2.pdf
> [11] IERC - problem solving in small groups.pdf
> [12] T301 Block IV - Soft Systems Analysis.pdf
> [13] T301 Block II - Systems Paradigms Systems Failures.pdf
> [14] T301 Block II - Systems Paradigms Systems Failures.pdf
> [15] Managing complexity_ a systems approach – introduction_ View as single page.pdf
> [16] T301 Block IV - Soft Systems Analysis.pdf
> [17] IERC - from technology push to organisational pull.pdf
> [18] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [19] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [20] IERC - Diagrams as an aid to thinking.pdf
> [21] IERC - systems thinking for managing change.pdf
> [22] [Book] B822 - Book 1 Creativity and Perception in Management.pdf
> [23] [Book] B822 - Book 1 Creativity and Perception in Management.pdf
> [24] [Book] B822 - Book 2 Managing Problems Creatively.pdf
> [25] [Book] B822 - Book 1 Creativity and Perception in Management.pdf
> [26] [Book] Brier - Introduction to Cybersemiotics A Transdisciplinary Perspective.pdf
> [27] IERC - A guided tour of diagramming techniques.pdf
> [28] Managing complexity - A systems approach - Introduction.pdf
> [29] Managing complexity - A systems approach - Introduction.pdf
> [30] block_4_full.pdf
> [31] T301 Block II - Systems Paradigms Systems Failures.pdf
> [32] T301 Block IV - Soft Systems Analysis.pdf
> [33] T301 Block IV - Soft Systems Analysis.pdf
> [34] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [35] T301 Block IV - Soft Systems Analysis.pdf
> [36] Managing complexity - A systems approach - Introduction.pdf
> [37] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [38] T301 Block IV - Soft Systems Analysis.pdf
> [39] OU T306 Managing Complexity Block 1.pdf
> [40] T301 Block IV - Soft Systems Analysis.pdf


FILE: 'Patrick Hoverstadt.md'
---
exported: 2026-02-07T21:56:46.636Z
source: NotebookLM
type: chat
title: Patrick Hoverstadt on 💬Keywords and Jargon
tags:
  - Keywords
  - Patrick-Hoverstadt
author: Patrick Hoverstadt
---
Based on the provided texts, here are the key concepts, principles, and theories extracted from Patrick Hoverstadt’s work on Systems Thinking, the Viable System Model (VSM), and Strategy.

### **Keywords**

**Core Frameworks**

• **The Viable System Model (VSM):** System 1 (Operations), System 2 (Coordination), System 3 (Delivery/Cohesion), System 4 (Intelligence), System 5 (Policy).

• **Patterns of Strategy:** Structural Coupling, Strategic Fit, The Dimensions of Strategy (Power, Fit, Time).

• **The Grammar of Systems:** 33 Systems Laws and Principles, 9 Patterns of Thinking.

**Systemic Properties & Dynamics**

• **Emergence:** Self-organization, Autopoiesis, Holism.

• **Complexity:** Variety, Requisite Variety, Recursive/Fractal Structure, Chaos vs. Order.

• **Feedback Loops:** Circular Causality, Homeostasis, Positive/Negative Feedback, Relaxation Time.

• **Relationships:** Structural Coupling, Co-evolution, Transduction, Boundaries.

**Cognitive Concepts**

• **Second-Order Cybernetics:** The observer, Mental Models, Map vs. Territory.

• **Purpose:** POSIWID (Purpose Of A System Is What It Does).

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**1\. Organizational Structure & The Viable System Model (VSM)**

• **Viable System Model (VSM):** A model developed by Stafford Beer to diagnose and design organizations that are capable of maintaining their separate existence (viability) in a changing environment\[1\]. It is based on a fractal structure where the same functional elements exist at every level of the organization\[2\].

• **Fractal Organization:** The concept that organizations are recursive; systems contain sub-systems that have the same generic organizational characteristics as the whole. A viable system is made up of viable systems\[3\].

• **Primary Activities:** The activities an organization performs that deliver value directly to the external environment (customers), as distinguished from support or regulatory activities\[3\].

• **System 1 (Operations):** The collection of operational units (sub-systems) that actually do the primary work of the organization\[4\].

• **System 2 (Coordination):** The function responsible for dampening oscillations between operational units (e.g., scheduling, standards) to prevent them from destabilizing each other\[5\].

• **System 3 (Delivery Management/Cohesion):** The function responsible for the "here and now" management of the internal organization, ensuring resources are allocated and performance is met. It balances the autonomy of the parts with the cohesion of the whole\[6\],\[7\].

• **System 4 (Intelligence):** The function responsible for looking "outside and then," capturing the future environment, market trends, and innovation. It acts as the organization's adaptation mechanism\[8\],\[9\].

• **System 5 (Policy):** The function responsible for balancing the demands of the present (System 3) with the demands of the future (System 4) to maintain the organization’s ultimate identity and direction\[5\],\[4\].

• **Algedonic Signal:** A "pain or pleasure" signal that bypasses normal management filters to alert System 5 directly of a critical threat or success (implied in "monitoring for trust")\[10\].

**2\. Strategy & Structural Coupling**

• **Structural Coupling:** A concept from Maturana and Varela describing the relationship between a system and its environment (or another system) where each triggers changes in the structure of the other over time. It is the engine of co-evolution and the "dark matter" of strategy\[11\],\[12\].

• **Strategic Fit:** The nature and attractiveness of the coupling between an organization and other actors. It is composed of three elements: **Differentiation** (Herd vs. Individual), **Drive** (Shape vs. React), and **Stretch** (Incremental vs. Paradigm shift)\[13\],\[14\].

• **Power (Dimension):** A strategic lever defined by **Strength** (Stronger vs. Weaker) and **Concentration** (Single vs. Diffuse focus). It is enabled by **Critical Mass** and **Agility**\[15\],\[16\].

• **Time (Dimension):** A strategic lever defined by relative speed (**Faster**, **Slower**, **Synchronized**). It is enabled by **Foresight**, **Cycle Time**, and **Change Rate**\[17\],\[18\].

• **80 Patterns of Strategy:** A taxonomy of archetypal strategic maneuvers (e.g., "Gorilla," "Grey Emience," "Trojan Horse") derived from observing how organizations actually interact through structural coupling, rather than how they plan\[19\].

**3\. Systems Laws & Principles (The Grammar)**

• **Ashby’s Law of Requisite Variety:** "Only variety can absorb variety." To control a system, the regulator must have as many available actions (variety) as the system has possible states. If the regulator has less variety, the system will be out of control\[20\],\[21\].

• **Conant-Ashby Theorem:** "Every good regulator of a system must be a model of that system." You cannot manage a system effectively if your mental or formal model of it is simpler than the system itself\[22\],\[23\].

• **Circular Causality (1st & 2nd Principles):** The recognition that systems are driven by loops rather than linear cause-and-effect.

    ◦ _1st Principle (Positive Feedback):_ Drives change, growth, or instability (e.g., exponential growth, vicious circles)\[24\].    ◦ _2nd Principle (Negative Feedback):_ Drives stability and correction (e.g., thermostats, homeostasis)\[25\].
• **The Darkness Principle:** "No system can be known completely." There is always an element of the system that remains obscure; therefore, management must handle uncertainty rather than eliminating it\[26\],\[27\].

• **Homeostasis Principle:** A system survives only so long as all essential variables are maintained within their physiological limits\[28\],\[29\].

• **Relaxation Time Principle:** The time it takes for a system to return to stability after a shock. If the interval between shocks is shorter than the relaxation time, the system will become permanently unstable\[30\],\[31\].

• **Law of Calling:** The act of making a distinction; defining a boundary that separates "this" from "that." It is the most basic act of cognition and system definition\[32\].

• **Law of Crossing:** Crossing a boundary constitutes a change of state. The view from inside a system is fundamentally different from the view from outside\[33\],\[34\].

• **Adams’ 3rd Law:** "A system composed of the lowest risk components available will be a high-risk system." Optimizing for local risk creates systemic fragility because it removes the ability to adapt\[35\],\[36\].

**4\. Cognitive & Philosophical Concepts**

• **POSIWID:** "The Purpose Of A System Is What It Does." A principle stating that a system's purpose is defined by its actual behavior and outputs, not by the written intent or mission statement of its designers\[37\],\[38\].

• **Second-Order Cybernetics:** The cybernetics of the observer. Recognizing that the observer is part of the system they are observing and that their models determine what they can see\[39\],\[40\].

• **Holism:** A thinking pattern that looks "up" to the containing system (meta-system) to understand meaning, rather than "down" to the parts (reductionism). It asks, "Of what is this a part?"\[41\],\[42\].

• **Autopoiesis:** A term coined by Maturana and Varela referring to systems that are self-producing and self-maintaining (e.g., biological cells, societies)\[43\],\[44\].

---
> [!info]- References
> [1] Hoverstadt - Organisational Viability as a factor in Sustainable Development of Technology.pdf
> [2] Hoverstadt - Organisational Viability as a factor in Sustainable Development of Technology.pdf
> [3] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [4] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [5] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [6] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [7] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [8] Hoverstadt - Modelling Organisations using the Viable System Model.pdf
> [9] Hoverstadt - Organisational Viability as a factor in Sustainable Development of Technology.pdf
> [10] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [11] [Book] Hoverstadt - Patterns of Strategy.pdf
> [12] [Book] Hoverstadt - Patterns of Strategy.pdf
> [13] [Book] Hoverstadt - Patterns of Strategy.pdf
> [14] [Book] Hoverstadt - Patterns of Strategy.pdf
> [15] [Book] Hoverstadt - Patterns of Strategy.pdf
> [16] [Book] Hoverstadt - Patterns of Strategy.pdf
> [17] [Book] Hoverstadt - Patterns of Strategy.pdf
> [18] [Book] Hoverstadt - Patterns of Strategy.pdf
> [19] [Book] Hoverstadt - Patterns of Strategy.pdf
> [20] [Book] Hoverstadt - Patterns of Strategy.pdf
> [21] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [22] [Book] Hoverstadt - The Grammar of Systems.pdf
> [23] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [24] [Book] Hoverstadt - Patterns of Strategy.pdf
> [25] [Book] Hoverstadt - Patterns of Strategy.pdf
> [26] Hoverstadt history of complexity.pdf
> [27] [Book] Hoverstadt - The Grammar of Systems.pdf
> [28] Hoverstadt history of complexity.pdf
> [29] [Book] Hoverstadt - The Grammar of Systems.pdf
> [30] Hoverstadt history of complexity.pdf
> [31] [Book] Hoverstadt - The Grammar of Systems.pdf
> [32] [Book] Hoverstadt - The Grammar of Systems.pdf
> [33] [Book] Hoverstadt - Patterns of Strategy.pdf
> [34] [Book] Hoverstadt - The Grammar of Systems.pdf
> [35] [Book] Hoverstadt - Patterns of Strategy.pdf
> [36] [Book] Hoverstadt - The Grammar of Systems.pdf
> [37] [Book] Hoverstadt - The Grammar of Systems.pdf
> [38] [Book] Hoverstadt - The fractal organization creating sustainable organizations with the Viable System Model.pdf
> [39] [Book] Hoverstadt - Patterns of Strategy.pdf
> [40] [Book] Hoverstadt - The Grammar of Systems.pdf
> [41] [Book] Hoverstadt - The Grammar of Systems.pdf
> [42] [Book] Hoverstadt - The Grammar of Systems.pdf
> [43] Hoverstadt history of complexity.pdf
> [44] [Book] Hoverstadt - The Grammar of Systems.pdf


FILE: 'Paul Cilliers.md'
---
exported: '2026-01-31T20:15:13.828Z'
source: NotebookLM
type: chat
title: Paul Cilliers on 💬Keywords and Jargon
tags:
  - Keywords
  - Paul-Cilliers
author: Paul Cilliers
---
Based on the sources, the study of complex systems involves a shift from reductionist, rule-based analysis toward a relational understanding of emergence, limits, and ethical responsibility\[1\].

### **Key Concepts, Principles and Theories**

• **Complexity (General vs. Restricted)**\[4\]\[5\]

• **Self-Organisation**\[6\]\[7\]

• **Emergence**\[8\]\[9\]

• **Non-linearity**\[10\]\[11\]

• **Incompressibility**\[12\]\[13\]

• **Boundaries and Framing**\[3\]\[14\]

• **Différance and Trace**\[15\]\[16\]

• **Distributed Representation**\[17\]\[18\]

• **Identity and Diversity**\[19\]\[20\]

• **Modesty and The Provisional Imperative**\[21\]\[22\]

• **Agonistics of the Network**\[23\]\[24\]

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**Agonistics of the Network:** A state in which different local narratives and discourses interact through a process of struggle, competition, and cooperation to dynamically determine their relevance\[25\]\[26\].

**Boundaries:** Functional and constitutive components that do not merely separate a system from its environment but connect them through a porous interface\[14\]\[27\]. In complex systems, boundaries are often "folded in," meaning the system consists of boundaries rather than a safe "inside"\[3\]\[27\].

**Complexity (General):** A critical approach that acknowledges complex systems are open, non-linear, and irreducible to simple descriptions or universal master keys\[4\]\[5\].

**Complexity (Restricted):** A reductionist approach that acknowledges relationality but attempts to reduce complex behavior to general principles, universal laws, or mathematical algorithms\[4\]\[5\].

**Connectionism:** A computational model, often implemented in neural networks, where knowledge is distributed across connection strengths between units rather than stored in local, iconic nodes\[17\]\[28\].

**Deconstruction:** A philosophical strategy used to investigate the structural conditions of meaning, illustrating that such conditions are contingent and can be displaced or transformed\[18\].

**Différance:** A Derridean term combining "difference" and "deferral" to describe how meaning is generated through relationships and is perpetually subject to change as it reverberates through a network\[15\]\[16\].

**Distributed Representation:** A framework where information is encoded in patterns of relationships across an entire network, meaning no single node represents a specific concept in isolation\[17\].

**Emergence:** The appearance of higher-order properties in a system that result from the dynamic interaction of its components and cannot be predicted by analyzing those components individually\[8\].

**Ethics of Complexity:** The unavoidable normative dimension of dealing with systems we cannot fully know; because we must choose a "frame" for our models, we are responsible for the aspects of reality we exclude\[21\].

**Framing:** The act of drawing a boundary around a system for the purpose of description, which necessarily reduces complexity and introduces distortions based on the observer's perspective\[12\].

**Identity:** An emergent property resulting from a system's internal diversity and the history of its interactions, rather than a pre-given or static essence\[19\].

**Incompressibility:** The principle that a complex system cannot be simplified into an algorithm or a model that is smaller than the system itself without losing essential information\[12\].

**Modesty:** A responsible intellectual attitude that acknowledges the limits of human understanding and the provisional nature of all knowledge claims regarding complex things\[21\].

**Non-linearity:** A condition where the output of a system is not proportional to its input, meaning small causes can have large effects (and vice versa)\[10\].

**Provisional Imperative:** An ethical strategy commanding that one should act while remaining critically aware that their knowledge is limited and their actions may require revision\[22\].

**Self-Organisation:** The spontaneous process by which a complex system develops or changes its internal structure and behavior to adapt to its environment without external control\[6\].

**Trace:** The relationship of difference between components in a system; each component is constituted by the "traces" of other components rather than possessing positive, self-sufficient content\[15\].

**Utopianism (Complex):** A liberating capacity to imagine a future departing from the present while remaining rooted in the "messiness" of contextual specificities rather than abstract blueprints\[47\]\[48\].

---
> [!info]- References
> [1] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [3] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [4] Cilliers 2010 - Difference Identity and Complexity.pdf
> [5] [Book] Cilliers - Complexity difference and identity.pdf
> [6] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [7] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [8] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [9] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [10] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [11] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [12] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [13] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [14] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [15] Cilliers 2010 - Difference Identity and Complexity.pdf
> [16] [Book] Cilliers - Complexity difference and identity.pdf
> [17] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [18] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [19] Cilliers 2010 - Difference Identity and Complexity.pdf
> [20] [Book] Cilliers - Complexity difference and identity.pdf
> [21] Cilliers 2010 - Difference Identity and Complexity.pdf
> [22] [Book] Cilliers - Critical Complexity (Categories).pdf
> [23] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [24] [Book] Cilliers - Critical Complexity (Categories).pdf
> [25] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [26] [Book] Cilliers - Complexity difference and identity.pdf
> [27] Cilliers - boundaries hierarchies and networks in complex systems.pdf
> [28] [Book] Cilliers - 1998 - Complexity and postmodernism - Routledge.pdf
> [47] [Book] Cilliers - Complexity difference and identity.pdf
> [48] [Book] Cilliers - Complexity difference and identity.pdf


FILE: 'Peter Checkland.md'
---
exported: 2026-02-07T17:24:55.171Z
source: NotebookLM
type: chat
title: Peter Checkland on 💬Keywords and Jargon
tags:
  - Keywords
  - Peter-Checkland
author: Peter Checkland
---
Based on the provided texts, which primarily cover the work of Peter Checkland and his collaborators, here are the key concepts, principles, and theories associated with Soft Systems Methodology (SSM), organized into keywords and a detailed glossary.

### **Keywords**

**Core Methodological Concepts**

• Soft Systems Methodology (SSM)

• Hard Systems Thinking

• Action Research

• The Learning Cycle

• Systemicity (Shift from Ontology to Epistemology)

**Modelling Tools & Techniques**

• Rich Pictures

• Root Definition (RD)

• CATWOE

• PQR Formula

• Conceptual Model (Activity Model)

• The 3 Es (Measures of Performance)

• Formal System Model

**Philosophical & Social Theories**

• Weltanschauung (Worldview)

• Holon

• Human Activity System (HAS)

• Appreciative Systems (Vickers)

• Accommodation

• Problematical Situation

• Mode 1 / Mode 2 SSM

**Information Systems Specific**

• Data / Capta / Information / Knowledge

• Process for Organization Meanings (POM)

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**Accommodation**The goal of an SSM investigation. Unlike "consensus," which implies total agreement on values and ends, an accommodation is an arrangement where conflicting parties with different worldviews find a version of the situation that they can live with, enabling action to proceed despite ongoing differences in values\[1\],\[2\],\[3\].

**Action Research**The research method through which SSM was developed. It involves the researcher entering a real-world situation to help improve it, while simultaneously reflecting on the process to generate new theoretical knowledge. In this view, theory and practice creates each other in a cyclic process\[4\],\[5\],\[6\].

**Appreciative System**A theory developed by Sir Geoffrey Vickers and adopted by Checkland to explain social processes. It posits that human beings perceive the world through a filter of "readinesses to notice" (appreciative settings), judge what they see against standards of fact and value, and take action which in turn modifies the settings. It replaces the "goal-seeking" model of human behavior with one of "relationship managing"\[7\],\[8\],\[9\].

**Capta**A distinction made by Checkland and Holwell to clarify Information Systems. "Data" is the mass of available facts; "Capta" is the subset of that data which an observer selects, pays attention to, or creates. When meaning is attributed to _capta_, it becomes _information_\[10\],\[11\],\[12\].

**CATWOE**A mnemonic used to test the rigour of a **Root Definition**. It ensures the definition considers:

• **C (Customers):** Victims or beneficiaries of the transformation.

• **A (Actors):** Those who would do the activities.

• **T (Transformation):** The process of converting input to output.

• **W (Weltanschauung):** The worldview that makes the transformation meaningful.

• **O (Owners):** Those who could stop or abolish the system.

• **E (Environmental constraints):** Elements outside the system taken as given\[13\],\[14\],\[15\].

**Conceptual Model**A logical assembly of verbs (activities) required to carry out the **Root Definition**. These are not descriptions of the real world, but "ideal types" or intellectual devices used to structure a debate about the real world. They must be built using the dependencies of the activities (activity A must happen before B)\[16\],\[17\],\[18\].

**Hard Systems Thinking**The "optimizing" paradigm (e.g., Systems Engineering, classical Operations Research). It assumes that the world contains systems (ontology) and that problems can be defined as a search for an efficient means to achieve a clear objective or goal. It is ill-suited for messy, human situations where objectives are contested\[19\],\[20\],\[21\].

**Holon**A term borrowed from Arthur Koestler to describe an entity that is simultaneously a whole and a part of a larger whole. Checkland uses "holon" to refer to the abstract systems models built in SSM, reserving the word "system" for everyday language to avoid the confusion that the models represent reality\[22\],\[23\],\[24\].

**Human Activity System (HAS)**A specific type of **holon** used in SSM. It models a set of activities so connected as to make a purposeful whole (e.g., "A system to paint a fence" or "A system to punish criminals"). It is always defined from a specific **Weltanschauung**\[25\],\[26\],\[27\].

**Mode 1 vs. Mode 2 SSM**A distinction in how SSM is applied:

• **Mode 1:** The formal, explicit use of the seven-stage methodology, often used by novices or for structuring large studies.

• **Mode 2:** The internalized, mental use of SSM principles by an experienced practitioner to make sense of the flux of everyday events without necessarily adhering to the rigid stage-by-stage structure\[28\],\[29\],\[30\].

**Problematical Situation**The starting point of an SSM inquiry. Checkland avoids the word "problem" (which implies a solution exists) and instead refers to a "situation of concern" or "problematical situation"—a complex flux of events and ideas that someone feels needs improvement\[31\],\[32\],\[33\].

**Rich Pictures**A "finding out" technique used in the early stages of SSM. It involves drawing the situation (using cartoons, symbols, and arrows) to capture the structure, processes, climate, and conflicts without immediately imposing a formal systems structure. It represents the situation as a culture\[34\],\[35\],\[36\].

**Root Definition (RD)**A concise verbal description of a relevant system. It describes _what_ the system is (not just what it does). It usually follows the **PQR** formula: Do **P** (what), by **Q** (how), in order to contribute to **R** (why/long-term aim)\[34\],\[37\],\[38\].

**Soft Systems Methodology (SSM)**A learning system for tackling ill-structured, messy problem situations. It shifts systemicity from the world (assuming the world is a system) to the process of inquiry (organizing our learning about the world as a system). It compares conceptual models against perceived reality to define changes that are systematically desirable and culturally feasible\[39\],\[40\],\[41\].

**Systemicity**The quality of being a system. The crucial difference between "hard" and "soft" thinking is the location of systemicity. Hard thinking assumes systemicity lies in the world (ontology); Soft thinking assumes systemicity lies in the process of inquiry into the world (epistemology)\[42\],\[43\],\[44\].

**The 3 Es**Criteria for judging the performance of a purposeful system:

• **Efficacy:** Does the means work? (Is the transformation produced?)

• **Efficiency:** Is it done with minimum resources?

• **Effectiveness:** Does it help achieve the longer-term goal (the 'W' or the 'R')?(Later extensions include Ethicality and Elegance)\[45\],\[46\],\[47\].

**Weltanschauung**German for "Worldview." The "taken-as-given" framework of assumptions that makes a particular **Root Definition** meaningful. For example, one worldview might see a prison as a system for punishment, while another sees it as a system for rehabilitation. SSM requires making these worldviews explicit\[48\],\[49\],\[23\].

---
> [!info]- References
> [1] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [2] [Book] Checkland - Critical Issues in Systems Theory and Practice.pdf
> [3] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [4] Checkland - Action research its nature and validity.pdf
> [5] [Book] Checkland,Holwell - 1998 - Information, systems, and information systems - Wiley.pdf
> [6] [Book] Checkland,Holwell - 1998 - Information, systems, and information systems - Wiley.pdf
> [7] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [8] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [9] Checkland 2005 - Webs of Significance - the work of Geoffrey Vickers.pdf
> [10] [Book] Checkland - Learning for Action.pdf
> [11] [Book] Checkland,Holwell - 1998 - Information, systems, and information systems - Wiley.pdf
> [12] [Book] Checkland,Holwell - 1998 - Information, systems, and information systems - Wiley.pdf
> [13] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [14] Checkland 1997 - Reflecting on SSM the link between Root Definitions and Conceptual Models.pdf
> [15] [Book] Checkland - 1981 - Systems thinking, systems practice - J. Wiley.pdf
> [16] Checkland - SSM in encylopedia of operations research.pdf
> [17] Checkland 2011 - Systems Thinking and Soft Systems Mehthodology.pdf
> [18] [Book] Checkland - 1981 - Systems thinking, systems practice - J. Wiley.pdf
> [19] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [20] Checkland - SSM in encylopedia of operations research.pdf
> [21] Checkland 2011 - Systems Thinking and Soft Systems Mehthodology.pdf
> [22] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [23] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [24] [Book] Checkland,Holwell - 1998 - Information, systems, and information systems - Wiley.pdf
> [25] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [26] Checkland 1983 - OR and the Systems Movement mappings and conflicts.pdf
> [27] [Book] Checkland - 1981 - Systems thinking, systems practice - J. Wiley.pdf
> [28] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [29] [Book] Checkland - Critical Issues in Systems Theory and Practice.pdf
> [30] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [31] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [32] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf
> [33] [Book] Checkland - Learning for Action.pdf
> [34] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [35] [Book] Checkland - 1981 - Systems thinking, systems practice - J. Wiley.pdf
> [36] [Book] Checkland,Scholes - 1990 - Soft systems methodology in action - Wiley.pdf
> [37] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [38] Comparing the systems approaches of checkland and blockley.pdf
> [39] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [40] Checkland - SSM in encylopedia of operations research.pdf
> [41] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [42] Checkland - SSM in encylopedia of operations research.pdf
> [43] Checkland 1983 - OR and the Systems Movement mappings and conflicts.pdf
> [44] Checkland 2011 - Systems Thinking and Soft Systems Mehthodology.pdf
> [45] An Appreciative Critique and Refinement of Checklands Soft Systems Methodology.pdf
> [46] OU T306_4 Checkland Systems Practice Managing sustainability - The Inquiring Process which is SSM.pdf
> [47] [Book] Checkland - Learning for Action.pdf
> [48] Checkland - From Optimising to Learning a development of systems thinking for the 1990s.pdf
> [49] Checkland - Soft Systems Methodology A Thirty Year Retrospective.pdf


FILE: 'Peter Senge.md'
---
exported: '2026-01-31T20:16:21.993Z'
source: NotebookLM
type: chat
title: Peter Senge on 💬Keywords and Jargon
tags:
  - Keywords
  - Peter-Senge
author: Peter Senge
---
### Keywords

**Learning Organization**\[1\]\[2\], **Systems Thinking**\[3\]\[4\], **Personal Mastery**\[5\]\[6\], **Mental Models**\[5\]\[7\], **Shared Vision**\[5\]\[8\], **Team Learning**\[5\]\[9\], **Metanoia**\[10\]\[11\], **Creative Tension**\[12\]\[13\], **Leverage**\[14\]\[15\], **Dynamic Complexity**\[14\]\[16\], **Generative Learning**\[17\]\[18\], **Systems Archetypes**\[19\]\[20\], **Defensive Routines**\[21\]\[22\], **System Leadership**\[23\]\[24\], **Current Reality**\[12\]\[13\], **Dialogue**\[5\]\[25\], **Inquiry and Advocacy**\[26\]\[27\].

\--------------------------------------------------------------------------------

### Attached Glossary

• **Adaptive Learning:** A form of learning focused on **coping** and responding more effectively to environmental changes\[17\].

• **Creative Tension:** The natural energy generated by the gap between where we want to be (**vision**) and telling the truth about where we are (**current reality**)\[12\].

• **Defensive Routines:** Entrenched habits, such as "smooth over" behaviors or "abstraction wars," used to protect ourselves from the embarrassment and threat of exposing our thinking\[21\].

• **Dialogue:** The capacity of team members to **suspend assumptions** and enter into a "free-flowing of meaning" through genuine thinking together\[5\].

• **Dynamic Complexity:** A condition where **cause and effect are distant in time and space**, and interventions produce subtle, non-obvious consequences over time\[14\].

• **Espoused Theory vs. Theory-in-Use:** The gap between what we say we believe (espoused) and the **deeper mental models** revealed by our actual actions (theory-in-use)\[33\]\[34\].

• **Generative Learning:** A deeper impulse to learn that focuses on **creating** and expanding our capability to produce results we truly desire\[17\].

• **Leaps of Abstraction:** The mental process of jumping from observable data to **generalizations** so quickly that we treat the assumptions as absolute facts\[35\]\[36\].

• **Leverage:** The principle that **small, well-focused actions** can produce significant, enduring improvements if applied in the "right place" within a system\[14\].

• **Mental Models:** Deeply ingrained **assumptions, generalizations, or internal images** that influence how we perceive problems and take action\[5\].

• **Metanoia:** A fundamental **shift of mind** that represents the true meaning of learning; a movement from seeing ourselves as separate to seeing ourselves as connected to the world\[10\]\[11\].

• **Personal Mastery:** The discipline of **continually clarifying personal vision**, focusing energies, and seeing reality objectively as a creative work\[5\].

• **Shared Vision:** A practice of unearthing collective "pictures of the future" that foster **genuine commitment** and enrollment rather than simple compliance\[5\].

• **System Leadership:** A role for individuals who catalyze **collective leadership** by helping people see the larger system and move beyond reactive problem-solving\[23\].

• **Systems Archetypes:** Recurring systemic structures, such as **"Limits to Growth"** or **"Shifting the Burden,"** that provide a language for describing common patterns of behavior across different management settings\[19\].

• **Systems Thinking:** The **"Fifth Discipline"** that integrates the other four; it is a conceptual framework for seeing **interrelationships** rather than isolated things and processes of change rather than snapshots\[3\].

• **The Six Conditions of Systems Change:** A framework of interdependent conditions that hold problems in place: **Policies, Practices, and Resource Flows** (explicit); **Relationships and Power Dynamics** (semi-explicit); and **Mental Models** (implicit/transformative)\[45\]\[46\].

---
> [!info]- References
> [1] 2022_11_28_15_32_00.pdf
> [2] Senge - Mr Learning Organisation.pdf
> [3] 11 Laws of Systems Thinking Peter Senge with references.pdf
> [4] peter_senge_the_fifth_discipline1.pdf
> [5] 11 Laws of Systems Thinking Peter Senge with references.pdf
> [6] peter_senge_the_fifth_discipline1.pdf
> [7] peter_senge_the_fifth_discipline1.pdf
> [8] peter_senge_the_fifth_discipline1.pdf
> [9] peter_senge_the_fifth_discipline1.pdf
> [10] peter_senge_the_fifth_discipline1.pdf
> [11] peter_senge_the_fifth_discipline1.pdf
> [12] 2022_11_28_15_32_00.pdf
> [13] peter_senge_the_fifth_discipline1.pdf
> [14] 2022_11_28_15_32_00.pdf
> [15] peter_senge_the_fifth_discipline1.pdf
> [16] peter_senge_the_fifth_discipline1.pdf
> [17] 2022_11_28_15_32_00.pdf
> [18] peter_senge_the_fifth_discipline1.pdf
> [19] 2022_11_28_15_32_00.pdf
> [20] peter_senge_the_fifth_discipline1.pdf
> [21] 2022_11_28_15_32_00.pdf
> [22] peter_senge_the_fifth_discipline1.pdf
> [23] Winter_2015_The_Dawn_of_System_Leadership.pdf
> [24] Winter_2015_The_Dawn_of_System_Leadership.pdf
> [25] peter_senge_the_fifth_discipline1.pdf
> [26] 2022_11_28_15_32_00.pdf
> [27] peter_senge_the_fifth_discipline1.pdf
> [33] 2022_11_28_15_32_00.pdf
> [34] peter_senge_the_fifth_discipline1.pdf
> [35] 2022_11_28_15_32_00.pdf
> [36] peter_senge_the_fifth_discipline1.pdf
> [45] Senge - The Water of Systems Change.pdf
> [46] Senge - The Water of Systems Change.pdf


FILE: 'Reg Revans.md'
---
exported: '2026-01-31T20:10:22.988Z'
source: NotebookLM
type: chat
title: Reg Revans on 💬Keywords and Jargon
tags:
  - Keywords
  - Reg-Revans
author: Reg Revans
---
Based on the sources provided, the following are the key concepts, principles, and theories that define Reginald Revans’ work and the methodology of Action Learning.

### **Keywords**

**Action Learning** • **Learning Equation (L = P + Q)** • **Questioning Insight (Q)** • **Programmed Knowledge (P)** • **The Set** • **Comrades in Adversity** • **Problems vs. Puzzles** • **Wicked Problems** • **System Beta** • **Risk Imperative** • **Principle of Insufficient Mandate** • **Client Group** • **Unlearning** • **Wisdom vs. Cleverness** • **Self-Development**.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts, Principles, and Theories**

**Action Learning**A social and organizational development approach where people learn through their **attempts to change real-world situations**\[1\]. It is built on the premise that there is no learning without action and no sober, deliberate action without learning\[2\]\[3\].

**Accoucheur**A "managerial midwife" or **useful intermediary** within an organization who helps "give birth" to the idea of action learning by building coalitions of support among senior management\[4\]\[5\].

**Cleverness vs. Wisdom**A fundamental distinction in Revans' philosophy. **Cleverness** is the pursuit of marginal gains in existing efficiency (incremental growth), while **wisdom** is the ability to discriminate and pose new questions in conditions of uncertainty to achieve radical change\[6\]\[7\].

**Client Group (Structure d’accueil)**A band of allies recruited by the action learner to help **implement a strategic plan**\[8\]\[9\]. This group typically includes those who understand the problem, those who care about it, and those who have the power to act\[10\]\[11\].

**Comrades in Adversity**A term describing the relationship between members of a "set"\[12\]\[13\]. It emphasizes that learning is a **social process** where peers support one another while facing the risks and stresses of real-world problem-solving\[14\]\[15\].

**Facilitation (Ambiguity of)**A controversial role in action learning. Revans was skeptical of facilitators, viewing them as potential "expert" authorities that could create **dependency**\[16\]\[17\]. He argued that the set should achieve independence as quickly as possible and that "the facilitator is dispensable"\[18\]\[19\].

**L = P + Q (The Learning Equation)**The central theoretical construct of action learning. It posits that **Learning (L)** is the sum of **Programmed Knowledge (P)**—what is already known and taught—and **Questioning Insight (Q)**—the ability to ask fresh questions in conditions of ignorance\[20\].

**Principle of Insufficient Mandate**A core principle stating that "**those unable to change themselves cannot change what goes on around them**"\[24\]. It highlights the inextricable link between personal self-development and organizational change\[24\]\[27\].

**Problems vs. Puzzles****Puzzles** are difficulties with known solutions that can be solved by experts using Programmed Knowledge\[28\]. **Problems** (or "wicked problems") are intractable situations with no single right answer, requiring Questioning Insight and leadership\[28\].

**Risk Imperative**The principle that significant learning only occurs when there is a "**risk of penalty for failure**"\[32\]\[33\]. Action learning must involve real threats and opportunities where the manager is personally accountable for the outcome\[16\]\[32\].

**Set (The)**A small group of 4-6 peers who meet regularly to offer each other **criticism, advice, and support**\[34\]. The set acts as a "mirror" reflecting the learner's actions and helping them reinterpret their experiences\[37\]\[38\].

**System Alpha, Beta, and Gamma**Revans developed a theory of human action (praxeology) involving three systems:

• **Alpha:** The **decision or strategy system** based on values and resources\[39\].

• **Beta:** The **influencing or negotiation cycle** of action, following the scientific method (Analysis, Development, Procurement, Assembly, Implementation, Review)\[39\].

• **Gamma:** The unique **learning process** of the individual action learner\[42\].

**Unlearning**The process of **escaping old mindsets** and the "idolization of past experience" to allow for new thinking\[43\]. It is considered essential for managing change and innovation\[45\].

**Wicked Problems**Complex problems characterized by **interdependencies** and unintended consequences, making them hard to describe and impossible to solve with rational analysis alone\[31\]\[46\]. They are the primary domain of leadership rather than management\[31\].

---
> [!info]- References
> [1] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [2] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [3] [Book] Revans - ABC of Action Learning.pdf
> [4] [Book] Revans - ABC of Action Learning.pdf
> [5] [Book] Revans - ABC of Action Learning.pdf
> [6] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [7] Revans 1981 Management productivity and risk - the way ahead.pdf
> [8] [Book] Revans - ABC of Action Learning.pdf
> [9] [Book] Revans - ABC of Action Learning.pdf
> [10] Revans 1981 Management productivity and risk - the way ahead.pdf
> [11] [Book] Revans - ABC of Action Learning.pdf
> [12] [Book] Revans - ABC of Action Learning.pdf
> [13] smith 1997 - revans action learning explained.pdf
> [14] Revans 1981 Management productivity and risk - the way ahead.pdf
> [15] [Book] Revans - ABC of Action Learning.pdf
> [16] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [17] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [18] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [19] [Book] Revans - ABC of Action Learning.pdf
> [20] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [24] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [27] [Book] Revans - ABC of Action Learning.pdf
> [28] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [31] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [32] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [33] [Book] Revans - ABC of Action Learning.pdf
> [34] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [37] [Book] Revans - ABC of Action Learning.pdf
> [38] [Book] Revans - ABC of Action Learning.pdf
> [39] [Book] Revans - ABC of Action Learning.pdf
> [42] [Book] Revans - ABC of Action Learning.pdf
> [43] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [45] Pedler - Reginald Revans The Pioneer of action learning.pdf
> [46] Pedler - Reginald Revans The Pioneer of action learning.pdf


FILE: 'Relational Biologists.md'
---
exported: '2026-01-31T20:21:10.573Z'
source: NotebookLM
type: chat
title: Relational Biologists on 💬Keywords and Jargon
tags:
  - Keywords
author: Relational Biologists
---
### **Key Keywords**

**Modeling Relation**, **Epistemic Cut**, **Complex Systems**, **Simple Systems (Mechanisms)**, **Organism**, **(M,R)-Systems**, **Biological Relativity**, **Downward Causation**, **Anticipatory Systems**, **Semantic/Semiotic Closure**, **Impredicativity**, **Rate-Independence**, **Harnessing Stochasticity**.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts, Principles, and Theories**

**Anticipatory System**A system that contains an **internal predictive model** of itself and its environment, allowing it to change state at a present instant based on the model’s predictions about a future instant\[1\]. In biological systems, these models often relate neutral stimuli to favorable outcomes, such as a plant triggering dormancy based on day-length\[4\]\[5\].

**Biological Relativity, Principle of**The principle asserting that there is **no privileged level of causality** in biological systems\[6\]. It holds that causation operates simultaneously across multiple scales, from the molecular to the organismal, and that the level at which a function is integrated is an empirical question\[9\].

**Causation, Downward**The process by which higher levels of organization exert **functional constraints** on the dynamics of lower levels\[12\]. In mathematical terms, this is often represented as high-level organization determining the **initial and boundary conditions** under which lower-level differential equations operate\[12\].

**Closure to Efficient Causation**Robert Rosen’s defining characteristic of an **organism**, stating that all components of a system required for its production are themselves produced from within the system\[17\]. This constitutes a closed loop where every efficient cause is entailed internally\[18\]\[20\].

**Complex System**A system that admits **multiple, non-equivalent, and irreducible descriptions**\[21\]. Unlike simple systems, complex systems possess **non-computable models** and contain hierarchical cycles of causal entailment\[24\].

**Epistemic Cut**A necessary conceptual or physical **separation between the observer (subject) and the observed (object)**, or between a symbolic description and the material construction it governs\[27\]. Without this cut, measurement and symbolization become vacuous\[30\].

**Impredicativity**A property of self-referential systems where a thing is defined in terms of a totality to which it belongs, creating **vicious circles** or closed loops of entailment\[33\]. While forbidden in purely syntactic computation, impredicativities are viewed as essential to the organization of living systems\[36\].

**Laws vs. Rules**A fundamental distinction where **laws** are universal, inexorable, and rate-dependent, while **rules (or constraints)** are local, arbitrary, and **rate-independent**\[39\]. Rules require material embodiments to be executed and are often the result of "frozen accidents" in evolution\[39\]\[42\].

**Modeling Relation**The establishment of a **congruence between a natural system and a formal system** such that the inferential structure of the formal model mirrors the causal structure of the natural world\[43\]. It involves the encoding of observables into symbols and the decoding of mathematical theorems into predictions\[45\].

**(M,R)-Systems (Metabolism-Repair Systems)**A class of relational models that represent the **minimal organization of a cell**\[48\]. It partitions cellular activity into metabolism (M), which processes environment, and repair (R), which maintains the metabolic machinery; under specific conditions, these systems also entail **replication**\[51\].

**Rate-Independence**A property of information and symbolic constraints where the **meaning or function of a string** is independent of the speed at which it is read or written\[40\]. This contrasts with physical laws, which are inherently rate-dependent and defined by time derivatives\[40\]\[55\].

**Semantic (or Semiotic) Closure**An autonomous closure between the **material dynamics (laws)** and the **symbolic constraints (rules)** of a system\[56\]. It arises when the molecular strings of a genome only function as symbols if they are interpreted by translation molecules, which are themselves products of that genome\[57\].

**Simple System (Mechanism)**A natural system that has a **unique largest model** from which all other models can be derived\[23\]. Simple systems are characterized by the fact that all their models are **simulable (computable)** and they contain no closed loops of efficient causation\[34\].

**Stochasticity, Harnessing of**The process by which organisms use **random fluctuations** (molecular or environmental) to generate **novelty and creative choices**\[65\]. Living systems are organized to prevent stochasticity from merely canceling out, instead using it to find solutions to environmental challenges, analogous to hypermutation in the immune system\[68\].

---
> [!info]- References
> [1] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [4] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [5] Robert Rosens Anticipatory Systems Theory The art and science of thinking ahead.pdf
> [6] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [9] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [12] Noble - Biological circular causality but not symmetry of causation so where what and when are the boundaries.pdf
> [17] louie - rosen relational diagrams of living systems.pdf
> [18] louie - rosen relational diagrams of living systems.pdf
> [20] louie - rosen relational diagrams of living systems.pdf
> [21] Irreducible and complementary semiotic - Howard Pattee.pdf
> [23] Rosen 1987 - On Complex Systems.pdf
> [24] [Book] Rosen - Theoretical Biology and Complexity. Three Essays on the Natural Philosophy of Complex Systems.pdf
> [27] Irreducible and complementary semiotic - Howard Pattee.pdf
> [30] Irreducible and complementary semiotic - Howard Pattee.pdf
> [33] [Book] Rosen - Essays on Life Itself.pdf
> [34] [Book] Rosen - Essays on Life Itself.pdf
> [36] louie - rosen relational diagrams of living systems.pdf
> [39] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [40] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [42] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [43] Rosen 1987 - On Complex Systems.pdf
> [45] [Book] Rosen - Anticipatory Systems Philosophical Mathematical and Methodological Foundations.pdf
> [48] [Book] Rosen - Theoretical Biology and Complexity. Three Essays on the Natural Philosophy of Complex Systems.pdf
> [51] [Book] Rosen - Essays on Life Itself.pdf
> [55] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [56] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [57] [Book] Pattee - Laws Language and Life Howard Pattee’s classic papers on the physics of symbols with contemporary commentary.pdf
> [65] Noble - Harnessing stochasticity how do organisms make choices.pdf
> [68] Noble - Harnessing stochasticity how do organisms make choices.pdf


FILE: 'Robert Flood.md'
---
exported: '2026-01-31T20:11:05.064Z'
source: NotebookLM
type: chat
title: Robert Flood on 💬Keywords and Jargon
tags:
  - Keywords
  - Robert-Flood
author: Robert Flood
---
### **Key Keywords**

• **Systems Thinking**\[1\]

• **Complexity Theory**\[4\]

• **Critical Systems Thinking (CST)**\[7\]

• **Soft Systems Methodology (SSM)**\[11\]

• **System Dynamics (SD)**\[15\]

• **Open Systems Theory (OST)**\[19\]

• **Total Systems Intervention (TSI)**\[23\]

• **Triple Loop Learning**\[27\]

• **Boundary Judgement**\[30\]

• **Emergence**\[19\]

• **Metamodeling**\[37\]

• **Metadecisions**\[37\]

• **Action Research**\[43\]

• **Feedback Loops**\[15\]

• **Homeostasis**\[49\]

• **Power-Knowledge**\[9\]

\--------------------------------------------------------------------------------

### **Attached Glossary**

**Abstraction:** A mental process by which images of reality are refined through different levels of conceptualization, often used to single out a characteristic for special consideration\[38\].

**Action Research:** A collaborative process of critical inquiry between researchers and people in a situation, where reflection on action yields insights for improvements\[44\]\[56\].

**Boundary Judgement:** The choice made in problem-solving about what belongs to the system of interest and what belongs to the environment; it is an ethical choice identifying who benefits and who is excluded\[31\].

**Complexity:** Associated with anything found difficult to understand\[6\]. It can be categorized into **organized simplicity** (few variables), **disorganized complexity** (many random variables), and **organized complexity** (rich systems that are neither simple nor random)\[59\].

**Critical Systems Thinking (CST):** A systems school that promotes human emancipation and uses multiple perspectives to surface moments of power-knowledge\[8\]. It is committed to critical awareness, social awareness, and methodological pluralism\[63\].

**Emergence:** The core systems concept that the "whole is more than the sum of its parts," referring to properties that arise from the interrelatedness of parts but are not present in the parts themselves\[19\].

**Feedback:** A process where the influence of an element impacts others and eventually feeds back to itself; it can be **negative (balancing)** to maintain stability or **positive (amplifying)** to create growth or decline\[47\].

**Homeostasis:** The maintenance of a steady-state or normal condition in a changing environment through the interplay of feedback loops\[47\].

**Local Systemic Intervention (LSI):** A postmodern interpretation of TSI focused on creative thinking about issues, choice-making over options, and achieving locally relevant intervention\[24\]\[67\].

**Metadecisions:** Decisions made at a metalevel of logic or abstraction that resolve conflicts or dissolve constraints that are unsolvable at the object level\[37\].

**Metamodeling:** The process of modeling the design process itself at a metalevel of logic higher than the object-level modeling\[38\].

**Open Systems Theory (OST):** A theory viewing systems as exchanging matter and energy with their environments across permeable and dynamic boundaries\[19\].

**Soft Systems Methodology (SSM):** A methodology for tackling ill-structured or "messy" situations by facilitating debate between participants with different worldviews to achieve accommodation\[12\].

**System Dynamics (SD):** A methodology that constructs diagrammatic and mathematical models of feedback processes to simulate behavior and support policy analysis\[15\].

**Systems Thinking:** A conceptual framework and body of knowledge developed over the last 50 years to make patterns of interconnection clearer and help see how to change them\[3\].

**Total Systems Intervention (TSI):** A meta-methodology for problem-solving that uses **systemic metaphors** to choose and implement the most appropriate specific systems methodologies for a given context\[26\].

**Triple Loop Learning:** An advanced learning model conjoining three loops of inquiry: (1) efficiency of design ("Are we doing things right?"), (2) debate over purpose ("Are we doing the right things?"), and (3) power/fairness ("Is rightness buttressed by mightiness?")\[27\].

---
> [!info]- References
> [1] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [3] Flood - System Thinking - Action Research.pdf
> [4] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [6] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [7] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [8] Flood - System Thinking - Action Research.pdf
> [9] Flood Finnestrand - A mighty step criticial systemic interpretation of the Learning Organisation.pdf
> [11] Flood - System Thinking - Action Research.pdf
> [12] Flood - System Thinking - Action Research.pdf
> [15] Flood - System Thinking - Action Research.pdf
> [19] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [23] [Book] Flood - Critical systems-thinking - Current research and practice.pdf
> [24] [Book] Flood - Critical systems-thinking - Current research and practice.pdf
> [26] [Book] Flood - Dealing with Complexity An Introduction to the Theory and Application of Systems Science.pdf
> [27] Flood 1996 - Contours of diversity managmeent and triple loop learning.pdf
> [30] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [31] A Maturing of Systems Thinking Evidence from Three Perspectives - Barton Emery Flood.pdf
> [37] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [38] [Book] Gigch - Metadecisions Rehabilitating Epistemology.pdf
> [43] Flood - System Thinking - Action Research.pdf
> [44] Flood 2000 - A Brief Review of Peter Checklands Contribution to Systemic Thinking.pdf
> [47] Flood - System Thinking - Action Research.pdf
> [49] Flood - System Thinking - Action Research.pdf
> [56] Flood 2000 - A Brief Review of Peter Checklands Contribution to Systemic Thinking.pdf
> [59] Flood 1987 - Complexity a definition by construction of a conceptual framework.pdf
> [63] Flood - System Thinking - Action Research.pdf
> [67] [Book] Flood - Critical systems-thinking - Current research and practice.pdf


FILE: 'Robert Pirsig.md'
---
exported: '2026-01-31T20:24:26.204Z'
source: NotebookLM
type: chat
title: Robert Pirsig on 💬Keywords and Jargon
tags:
  - Keywords
  - Robert-Pirsig
author: Robert Pirsig
---
Here are the key concepts, principles, and theories from the works of Robert Pirsig, structured as keywords and a comprehensive glossary.

### **Keywords**

**Metaphysics of Quality (MOQ)**; **Dynamic Quality**; **Static Quality**; **Subject-Object Metaphysics (SOM)**; **Areté**; **Dharma**; **Rta**; **Gumption**; **Gumption Traps**; **The Giant**; **Static Filter**; **Cultural Immune System**; **Mu**; **Conceptually Unknown**; **Evolutionary Morality**; **Philosophology**; **Preintellectual Reality**.

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts and Theories**

**Core Philosophical Frameworks**

• **Metaphysics of Quality (MOQ):** A rational framework that treats **Quality (Value)** as the primary empirical reality of the world, rather than mind or matter\[1\]. It asserts that the world is composed of three things: mind, matter, and Quality\[2\]\[4\].

• **Subject-Object Metaphysics (SOM):** The traditional Western worldview that divides reality into **subjects (mind)** and **objects (matter)**\[5\]. Pirsig argues this framework is inadequate because it cannot explain values or "stuckness"\[8\]\[9\].

• **Dynamic Quality:** The **pre-intellectual cutting edge of reality**; the source of all things, freedom, and evolution\[10\]. It is the "spur of the moment" force that creates new patterns of being\[12\]\[13\].

• **Static Quality:** The fixed patterns of value that emerge in the wake of Dynamic Quality to **preserve evolutionary gains**\[10\]. These are subdivided into four levels: **inorganic, biological, social, and intellectual**\[16\]\[17\].

**Evolutionary and Moral Theories**

• **Evolutionary Hierarchy of Value:** Reality is organized into four discrete levels. Each higher level is built upon the lower but is **often in opposition to it**\[18\].

    1. **Inorganic:** Stable patterns of value like substance and physical laws\[21\]\[22\].    2. **Biological:** Senses and survival drives\[23\]\[24\].    3. **Social:** Institutions, customs, and laws\[23\]\[25\].    4. **Intellectual:** Science, philosophy, and mathematics\[26\]\[27\].
• **Principle of Evolutionary Morality:** Morality is defined by the hierarchy of these levels. It is **moral for a higher level to suppress a lower level** (e.g., an idea killing a society is more moral than a society killing an idea)\[24\].

• **Static Latching:** The process by which a Dynamic advance is protected from degeneration by a **static pattern** (e.g., DNA as a latch for life, or laws as a latch for social progress)\[15\]\[30\].

**Cognitive and Scientific Concepts**

• **Conceptually Unknown:** A term bridging the MOQ and Niels Bohr’s **Complementarity**; it refers to the "unmeasured phenomenal object" that exists before observation or intellectual patterning\[31\]\[32\].

• **Mu:** A Japanese term meaning "no thing." It is used to "unask" a question when a binary **Yes/No** answer is invalid because the context is too small for the truth\[33\]\[34\].

• **The Static Filter:** A psychological mechanism where a person’s existing static patterns **filter out undesirable or unrecognized data** (e.g., not seeing the "green flash" of the sun because one hasn't been told to look for it)\[35\]\[36\].

• **Cultural Immune System:** The social mechanism that **identifies and destroys deviant ideas** or behaviors to protect the status quo, often unable to distinguish between a "common criminal" and a "Galileo"\[36\].

• **Unambiguous Communication:** The scientific test for **objectivity**. Truth is seen as a social consensus achieved when observers can communicate their results in a way that others can replicate\[39\].

**Historical and Practical Concepts**

• **Areté / Rta / Dharma:** Ancient terms (Greek, Proto-Indo-European, and Sanskrit) for **Excellence or Cosmic Order**. Pirsig identifies these as the original ancestors of his concept of Quality, existing before the split of "Good" and "True"\[42\].

• **Gumption:** The **psychic gasoline** or reservoir of good spirits necessary to perform quality work or fix a machine\[45\]\[46\].

• **Gumption Traps:** Internal or external conditions that drain gumption and cause a person to lose sight of Quality\[47\]\[48\]. These include **Value Rigidity** (inability to revalue facts) and **Anxiety**\[49\]\[50\].

• **Philosophology:** The **academic study of other people's philosophy**, which Pirsig distinguishes from the creative act of actually philosophizing\[51\]\[52\].

• **The Giant:** A metaphor for a **social superorganism** (like a city or corporation) that exploits and "devours" biological human beings for its own sustenance and growth\[53\].

• **Stuckness:** The "zero moment of consciousness" where traditional logic fails. In the MOQ, this is viewed as an **opportunity** to face reality directly without the distortion of old patterns\[56\].

---
> [!info]- References
> [1] Pirsig - Subjects Objects Data and Values.pdf
> [2] Pirsig - Subjects Objects Data and Values.pdf
> [4] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [5] Pirsig - Subjects Objects Data and Values.pdf
> [8] [Book] Pirsig - Lila an inquiry into morals.pdf
> [9] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [10] Pirsig - Subjects Objects Data and Values.pdf
> [12] [Book] Pirsig - Lila an inquiry into morals.pdf
> [13] [Book] Pirsig - Lila an inquiry into morals.pdf
> [15] [Book] Pirsig - Lila an inquiry into morals.pdf
> [16] Pirsig - Subjects Objects Data and Values.pdf
> [17] [Book] Pirsig - Lila an inquiry into morals.pdf
> [18] Pirsig - Subjects Objects Data and Values.pdf
> [21] Pirsig - Subjects Objects Data and Values.pdf
> [22] [Book] Pirsig - Lila an inquiry into morals.pdf
> [23] Pirsig - Subjects Objects Data and Values.pdf
> [24] [Book] Pirsig - Lila an inquiry into morals.pdf
> [25] [Book] Pirsig - Lila an inquiry into morals.pdf
> [26] Pirsig - Subjects Objects Data and Values.pdf
> [27] [Book] Pirsig - Lila an inquiry into morals.pdf
> [30] [Book] Pirsig - Lila an inquiry into morals.pdf
> [31] Pirsig - Subjects Objects Data and Values.pdf
> [32] Pirsig - Subjects Objects Data and Values.pdf
> [33] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [34] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [35] [Book] Pirsig - Lila an inquiry into morals.pdf
> [36] [Book] Pirsig - Lila an inquiry into morals.pdf
> [39] Pirsig - Subjects Objects Data and Values.pdf
> [42] [Book] Pirsig - Lila an inquiry into morals.pdf
> [45] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [46] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [47] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [48] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [49] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [50] [Book] Pirsig - Zen and the art of Motor maintanance.pdf
> [51] [Book] Pirsig - Lila an inquiry into morals.pdf
> [52] [Book] Pirsig - Lila an inquiry into morals.pdf
> [53] [Book] Pirsig - Lila an inquiry into morals.pdf
> [56] [Book] Pirsig - Zen and the art of Motor maintanance.pdf


FILE: 'Roger James.md'
---
exported: '2026-01-31T23:07:41.772Z'
source: NotebookLM
type: chat
title: Roger James on 💬Keywords and Jargon
tags:
  - Keywords
  - Roger-James
author: Roger James
---

Based on the provided source materials, here is an extraction of the key concepts, principles, and theories regarding Systems Thinking, Cybernetics, and Complexity.

### Part 1: Keywords and Core Themes

The sources present a "tower of thought"\[1\] that moves from observation to abstraction. The key themes can be grouped as follows:

**1\. The Nature of Complexity**

• **Organized vs. Disorganized Complexity:** The distinction between systems with few variables (simplicity), myriad variables (disorganized/statistical), and the critical "middle region" of organized complexity (the "Goldilocks" zone)\[2\]\[3\].

• **Subjectivity of Complexity:** The theory that complexity is often a measure of the observer's lack of understanding rather than an intrinsic property of the system\[4\]\[5\].

• **Wicked Problems:** Problems with no definitive formulation, no stopping rule, and no true/false solutions\[6\]\[7\].

**2\. Second-Order Systems Thinking (Epistemology)**

• **Observer Dependence:** The shift from viewing systems as objects in the real world (Ontology) to viewing systems as mental constructs used to understand the world (Epistemology)\[8\]\[9\].

• **The "Epistemic Cut":** The distinction between the material world (laws/constraints) and the abstract world of symbols and descriptions (rules/controls)\[10\]\[11\].

• **Constructivism:** The idea that we construct understanding through distinctions, perspectives, and relationships\[12\].

**3\. Structural & Cybernetic Principles**

• **Requisite Variety:** The law that a control system must have at least as much variety (states) as the system it attempts to control\[13\]\[14\].

• **Transduction:** The mechanism by which signals or information cross boundaries between different layers or systems, often involving a loss or compression of detail\[14\]\[15\].

• **Hierarchy & Holons:** The organization of systems where entities (holons) act as wholes to their parts and parts to their wholes\[16\]\[17\].

• **Feedback & Circular Causality:** The shift from linear cause-and-effect to circular loops where outputs influence inputs\[18\]\[19\].

**4\. Methodologies & Tools**

• **Soft Systems Methodology (SSM):** A learning system for tackling ill-structured problems by comparing conceptual models with the real world\[16\]\[20\].

• **Interpretive Structural Modeling (ISM):** A computer-assisted learning process to structure complex relationships and hierarchies\[21\]\[22\].

• **Viable System Model (VSM):** A model based on the structure of living organisms to ensure organizational viability\[23\]\[24\].

• **Triz:** A problem-solving framework based on abstraction and the resolution of contradictions\[25\]\[26\].

\--------------------------------------------------------------------------------

### Part 2: Glossary of Key Concepts

**Abduction**A form of reasoning distinct from deduction (general to specific) and induction (specific to general). Abduction is the process of forming the best explanatory hypothesis for an observation; it is often associated with the creative leap in diagnostic or design thinking\[27\]\[28\].

**Appreciative System**Derived from Geoffrey Vickers, this refers to the culturally and personally determined set of values and norms through which an observer perceives and judges a situation. It dictates what we notice and how we value it\[29\]\[30\].

**CATWOE**A mnemonic used in Soft Systems Methodology (SSM) to define the necessary elements of a "Root Definition." It stands for **C**ustomers, **A**ctors, **T**ransformation process, **W**eltanschauung (Worldview), **O**wners, and **E**nvironmental constraints\[31\]\[32\].

**Constraints vs. Controls**A distinction used to bridge the physical and abstract worlds. **Constraints** are physical limitations (laws of nature, thermodynamics) that reduce possibilities. **Controls** are informational or arbitrary rules (like genetic codes or traffic lights) that harness energy to select specific outcomes from the remaining possibilities\[33\]\[34\].

**Disorganized Complexity**A state characterized by a vast number of variables where the individual behavior is random or unknown, but the aggregate behavior is predictable using statistical methods (e.g., gas molecules, thermodynamics). This contrasts with **Organized Complexity**, where variables are interrelated into an organic whole\[3\]\[35\].

**Emergence**Properties or behaviors of a whole system that cannot be found in or predicted solely from the properties of its individual parts. Emergence arises from the interactions and structure of the parts\[36\]\[37\]. The sources note that emergence is often meaningless in the language of the lower level (e.g., the shape of an apple has no meaning at the level of a cell)\[38\].

**Epistemic Cut**The separation between the physical world (matter/energy) and the symbolic world (information/description). Systems thinking requires navigating this gap without confusing the map (epistemic) with the territory (ontic)\[10\]\[11\].

**Equifinality**A principle of open systems where the same final state can be reached from different initial conditions and by different paths. This contrasts with closed systems where the final state is determined by initial conditions\[39\].

**Holon**A term coined by Arthur Koestler to describe entities that act simultaneously as a whole (looking down at their parts) and as a part (looking up at the larger system). It replaces the rigid "system vs. part" dichotomy with a recursive hierarchy\[16\]\[17\].

**Interpretive Structural Modeling (ISM)**A methodology developed by John Warfield to help groups structure complex issues. It uses mathematical algorithms to organize ideas into a hierarchy of relationships (e.g., "supports," "aggravates"), helping to overcome cognitive limitations regarding the number of variables humans can handle\[22\]\[40\].

**Law of Requisite Variety (Ashby's Law)**A cybernetic principle stating that "only variety can destroy variety." To control a system, the regulator must have a repertoire of responses (variety) at least equal to the variety of disturbances the system faces\[41\]\[42\].

**Middle Numbers (The Goldilocks Region)**The zone of "Organized Complexity" situated between organized simplicity (mechanisms) and disorganized complexity (aggregates). This is the domain of systems thinking, where systems are too complex for analytic reduction but too organized for statistics\[3\].

**Problem Structuring Methods (PSMs)**A family of interactive and participatory approaches (including SSM, SODA, and Strategic Choice) designed to assist groups in handling "wicked" or "messy" problems. They focus on structuring the problem and learning rather than providing a mathematical solution\[45\]\[46\].

**Rich Picture**A graphical technique used in the early stages of SSM to capture the complexity of a situation. It depicts stakeholders, structures, processes, and—crucially—conflict, emotions, and culture, without imposing a rigid formal structure\[47\]\[48\].

**Root Definition**In SSM, a concise sentence that describes a system of purposeful activity. It defines _what_ the system does, _how_ it does it, and _why_ (the worldview). It is structured using the CATWOE elements\[31\]\[32\].

**Second-Order Understanding**An awareness that the observer is part of the system being observed. It moves beyond asking "what is the system?" (First Order) to asking "why do I perceive the system this way?" It acknowledges that descriptions of the world reveal as much about the observer as the observed\[49\]\[50\].

**Soft Systems Methodology (SSM)**An approach developed by Peter Checkland that treats "systems" not as real-world objects, but as a process of inquiry. It distinguishes between the "Real World" (messy, problematic) and the "Systems Thinking World" (where abstract models are built to debate the real world)\[9\]\[20\].

**Transduction**The process by which variety (information/complexity) is converted or compressed as it crosses a boundary between a system and its environment, or between levels of a hierarchy. It is a filtering mechanism that allows a system to handle the complexity of its environment\[14\]\[15\].

**Weltanschauung**German for "Worldview." In Systems Thinking, this refers to the specific set of beliefs, assumptions, and values that make a particular definition of a system or problem meaningful to a specific observer\[31\]\[51\].

**Wicked Problem**A class of problems (defined by Rittel and Webber) that are ill-formulated, have no stopping rule, and for which solutions are not true or false, but good or bad. Every wicked problem is essentially unique and is often a symptom of another problem\[6\]\[7\].

---
> [!info]- References
> [1] Perlite.pdf
> [2] Recent.pdf
> [3] Recent.pdf
> [4] Perlite.pdf
> [5] Recent.pdf
> [6] Perlite.pdf
> [7] Recent.pdf
> [8] Perlite.pdf
> [9] Perlite.pdf
> [10] Recent.pdf
> [11] Recent.pdf
> [12] Recent.pdf
> [13] Perlite.pdf
> [14] Recent.pdf
> [15] Perlite.pdf
> [16] Recent.pdf
> [17] Recent.pdf
> [18] Perlite.pdf
> [19] Recent.pdf
> [20] Recent.pdf
> [21] Recent.pdf
> [22] Recent.pdf
> [23] Perlite.pdf
> [24] Recent.pdf
> [25] Perlite.pdf
> [26] Recent.pdf
> [27] Perlite.pdf
> [28] Perlite.pdf
> [29] Recent.pdf
> [30] Recent.pdf
> [31] Recent.pdf
> [32] Recent.pdf
> [33] Perlite.pdf
> [34] Recent.pdf
> [35] Recent.pdf
> [36] Perlite.pdf
> [37] Perlite.pdf
> [38] Perlite.pdf
> [39] Recent.pdf
> [40] Recent.pdf
> [41] Perlite.pdf
> [42] Recent.pdf
> [45] Recent.pdf
> [46] Recent.pdf
> [47] Recent.pdf
> [48] Recent.pdf
> [49] Perlite.pdf
> [50] Recent.pdf
> [51] Recent.pdf


FILE: 'Ross Ashby.md'
---
exported: 2026-02-07T16:17:21.598Z
source: NotebookLM
type: chat
title: Ross Ashby on 💬Keywords and Jargon
tags:
  - Ross-Ashby
  - Keywords
author: Ross Ashby
---
Based on the provided texts, here are the key concepts, principles, and theories associated with W. Ross Ashby’s work, presented as keywords followed by a detailed glossary.

### **Keywords**

**Core Concepts**

• State-Determined System (The Machine)

• System vs. Object

• Variables vs. Parameters

• The Black Box

• Operationalism

**Regulation and Control**

• The Law of Requisite Variety

• The Conant-Ashby Theorem (Good Regulator Theorem)

• Essential Variables

• Regulation as Blocking Flow

• Error-Controlled vs. Cause-Controlled Regulation

**Adaptation and Learning**

• Ultrastability (Double Feedback Loop)

• The Homeostat

• Step-Mechanisms (Gating Mechanisms)

• Habituation

• Adaptation as Equilibrium

**Information and Organization**

• Information as Selection

• Constraint Analysis

• Cylindrance

• Self-Organization (as Selection by Equilibrium)

• Information-Tight Systems

• Intelligence Amplification

\--------------------------------------------------------------------------------

### **Glossary of Terms**

**1\. Foundations of System Theory**

• **System vs. Object:** Ashby distinguishes rigorously between a physical "object" (which contains an infinity of variables) and a "system." A **system** is defined as a list of variables selected by the observer from the infinite number available on the real object\[1\].

• **State-Determined System (Machine):** A system where the "next state" is uniquely determined by the "present state" and the current values of its inputs (parameters). If a system behaves capriciously (unpredictably), it indicates that a relevant variable has been ignored and must be included to make the system state-determined\[1\].

• **Variables vs. Parameters:**

    ◦ **Variables** are the changing parts (operands) within the system being studied; they define the state\[7\].    ◦ **Parameters** are the conditions or inputs (operators) that determine _how_ the variables behave. A change in a variable is a change of state (behavior); a change in a parameter is a change in the _way_ of behaving (a change in the system's organization)\[7\].
• **The Black Box:** A method of investigation where the internal machinery of a system is hidden. The investigator must deduce the system's nature (its canonical representation) solely by manipulating inputs and observing outputs (the protocol) to find regularities\[8\].

• **Operationalism:** The principle that concepts must be defined by the specific operations used to measure or observe them, rather than by abstract or metaphysical properties. For example, "connection" is defined by whether a change in one variable causes a change in another, regardless of physical linkage\[11\]\[12\].

**2\. Regulation, Variety, and Control**

• **Variety:** The number of distinct elements or states that a system can possess. It is often measured logarithmically (in bits). Variety is not an intrinsic property of an object but depends on the observer's distinctions\[13\]\[14\].

• **The Law of Requisite Variety:** Ideally, a regulator seeks to keep the outcome variety at a minimum (stability) despite high variety in environmental disturbances. The law states that **"only variety can destroy variety."** The capacity of a regulator to suppress disturbances cannot exceed its capacity as an information channel; the regulator must have a variety of responses at least equal to the variety of disturbances it seeks to control\[15\].

• **Conant-Ashby Theorem (Good Regulator Theorem):** A theorem stating that **"every good regulator of a system must be a model of that system."** To regulate a system optimally, the regulator must be isomorphic (structurally similar) to the system it regulates\[19\].

• **Essential Variables:** A specific set of variables in an organism (e.g., body temperature, blood sugar) that must be kept within specific physiological limits for the organism to survive. The goal of regulation is to protect these variables from environmental disturbance\[19\].

• **Regulation as Blocking Flow:** A successful regulator acts as a block that prevents the transmission of variety (disturbances) from the environment to the essential variables. Ideally, the regulator transmits a "message of zero entropy" (constancy) to the essential variables\[25\].

**3\. Adaptation and Ultrastability**

• **Ultrastability:** Ashby's mechanism for adaptation using **double feedback loops**:

    1. **Loop 1 (Frequent):** The system reacts to sensory input using its current behavior patterns.    2. **Loop 2 (Infrequent):** If Essential Variables go outside their limits (signaling failure), a second feedback loop triggers a change in the system's **step-mechanisms** (parameters). This changes the system's internal organization randomly until a new stability is found\[19\].
• **The Homeostat:** A machine built by Ashby to demonstrate ultrastability. It consisted of four interconnected units that would automatically reconfigure their internal connections (via stepping switches) whenever the system became unstable, continuing until a stable configuration was found\[22\].

• **Habituation:** The process by which a system stops responding to a repetitive stimulus. Ashby explains this mechanistically: a system destroys the internal communication channels that allow the stimulus to disrupt it, thereby becoming stable (adapted) regarding that specific stimulus\[30\]\[31\].

**4\. Information, Constraints, and Complexity**

• **Information as Selection:** Ashby views information not as "stuff" but as the act of **selection** from a set of possibilities. Intelligence is defined as "appropriate selection"\[15\].

• **Constraint:** A relation between variables that restricts the total variety. If variables A and B are independent, variety is maximal. If A determines B, variety is restricted; this restriction is a **constraint**. Ashby equates the presence of organization with the presence of constraints\[9\].

• **Cylindrance:** A measure of the complexity of a relation in a multi-variable system. It indicates the minimum dimensionality required to reconstruct the total relation. If a system of 100 variables has a cylindrance of 3, it means the system can be understood by looking at interactions of just 3 variables at a time, representing a massive simplification\[37\].

• **Self-Organization:** Ashby argues this term is often contradictory. A machine cannot change its own transfer function (f) to g because that implies f was a function of the state, which violates the definition of a machine.

    ◦ _Corrected Definition:_ A system can be "self-organizing" in the sense that it moves from a set of unorganized states to a set of stable, organized states (an attractor) as it approaches equilibrium. The system "selects" the stable states\[40\].
• **Bremermann’s Limit:** A theoretical limit on the information-processing capacity of matter (1047 bits per gram per second). Ashby uses this to argue that for problems exceeding this limit (transcomputational problems), explicit calculation is impossible, and systems must rely on simplification and constraint analysis\[43\].

• **Intelligence Amplification:** The concept that human intelligence can be amplified by designing a system that generates selection power greater than that of the designer. This is achieved by coupling a selection mechanism (the machine) to a source of high variety (information), allowing the machine to evolve solutions the designer could not compute\[46\].

---
> [!info]- References
> [1] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [7] Ashby’s Cybernetic Framework_ System, Parameter, and Environment.pdf
> [8] Ashby 1991 - Facets of Systems Science.pdf
> [9] Ashby Mechanisms.pdf
> [11] Adaptive Systems work of ashby and ultrastability version 2.pdf
> [12] Ashby Mechanisms.pdf
> [13] Ashby 1991 - Requisite Variety and Its Implications for the Control of Complex Systems.pdf
> [14] the great ashby - casti.pdf
> [15] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [19] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [22] Ashby - Principles of the Self-Organising System.pdf
> [25] Ashby 1991 - Requisite Variety and Its Implications for the Control of Complex Systems.pdf
> [30] Ashby Mechanisms.pdf
> [31] ashby pschiatry.pdf
> [37] Ashby Mechanisms.pdf
> [40] 2004 Umpleby - Ashby general theory of adaptive systems.pdf
> [43] Ashby Mechanisms.pdf
> [46] Ashby Mechanisms.pdf


FILE: 'Russ Ackoff.md'
---
exported: '2026-01-31T20:21:51.444Z'
source: NotebookLM
type: chat
title: Russ Ackoff on 💬Keywords and Jargon
tags:
  - Keywords
author: Russ Ackoff
---
### Key Concepts, Principles, and Theories

The work of Russell L. Ackoff represents a fundamental shift from **Machine-Age (analytical)** thinking to **Systems-Age (synthetic)** thinking\[1\]\[2\]. The central theory is that a system is a whole that cannot be understood by taking it apart; its properties derive from the **interactions of its parts**, not their actions taken separately\[2\]. Consequently, improving the performance of parts independently often leads to the **suboptimization** or destruction of the system as a whole\[4\].

Management’s primary role in this paradigm is to manage **interactions** rather than actions\[7\]. This is applied through **Interactive Planning**, a methodology that seeks to **dissolve** problems by redesigning the system so the problem can no longer occur, rather than merely solving or resolving it\[10\]. The cornerstone of this process is **Idealized Design**, where stakeholders design a replacement for a currently existing system from scratch, subject only to technological feasibility and operational viability\[14\].

Organizationally, Ackoff proposes three specific architectures to support this worldview: the **Circular Organization** for democratic control\[17\], the **Multidimensional Structure** for permanent flexibility\[21\], and the **Internal Market Economy** to eliminate bureaucratic monopolies\[25\]. Finally, the work emphasizes that **development** is a matter of increased **competence** and **wisdom**—the ability to do the right thing (effectiveness)—rather than just doing things right (efficiency)\[29\].

\--------------------------------------------------------------------------------

### Keywords

• **Systems Thinking**\[2\]

• **Synthesis**\[2\]

• **The Mess (Problematique)**\[37\]

• **Interactive Planning**\[40\]

• **Idealized Design**\[14\]

• **Problem Dissolution**\[10\]

• **Circular Organization**\[17\]

• **Multidimensional Structure**\[21\]

• **Internal Market Economy**\[25\]

• **Omnicompetence**\[44\]

• **Suboptimization**\[4\]

• **Mental Content Hierarchy (DIKUW)**\[32\]

• **Stakeholder View**\[49\]

• **Errors of Omission vs. Commission**\[52\]

\--------------------------------------------------------------------------------

### Glossary of Distinctions

**Analysis vs. Synthesis**

• **Analysis:** A three-step process of breaking a whole into parts, explaining the parts, and aggregating them into an explanation of the whole; it reveals **structure** and "how it works"\[55\].

• **Synthesis:** A three-step process of identifying a containing whole, explaining the containing whole, and disaggregating that explanation to identify the **function** of the part; it reveals "why it operates as it does"\[55\].

**Efficiency vs. Effectiveness**

• **Efficiency:** Measured by "doing things right"; it focuses on the volume of output relative to input or the probability of a means reaching an end\[31\].

• **Effectiveness:** Measured by "doing the right thing"; it is a function of **wisdom** and the value of the outcome\[31\].

**Ends vs. Means vs. Ideals**

• **Ends:** Desired outcomes of action\[61\]\[62\].

• **Means:** Behaviors or courses of action used to pursue ends\[63\].

• **Ideals:** Ends that are believed to be unattainable but toward which continuous progress is possible (e.g., Omnicompetence)\[61\].

**Idealized Design**An explicit statement of what an organization's stakeholders would have **right now** if they could have whatever they wanted, subject to two constraints: **Technological Feasibility** (no science fiction) and **Operational Viability** (must be able to survive in the current environment)\[14\].

**Interactive Planning**A systems approach to planning that is **participative, coordinated, integrated, and continuous**\[69\]. It involves planning **backward** from a desired future (idealized design) to the present\[72\].

**Internal Market Economy**A design where every unit within an organization operates as a **profit center**, possessing the freedom to buy goods/services from internal or external sources and sell their output to any buyer\[25\].

**The Mess**A system of interacting problems; the behavior of a mess depends on how its parts interact rather than how they act independently\[37\].

**Omnicompetence**The meta-ideal of humanity: the continuous progress toward the ability to satisfy all of one's own desires and the desires of others\[45\].

**Problem Dissolution**Treating a problem by **redesigning** the system or its environment so that the problem is eliminated and cannot reoccur\[10\].

**System**A whole consisting of two or more parts where: (1) each part can affect the behavior of the whole, (2) the effect of each part depends on at least one other part, and (3) no part has an independent effect on the whole\[1\].

**System Typology (Purposefulness)**

• **Deterministic:** Neither the parts nor the whole have purposes (e.g., a clock)\[86\]\[87\].

• **Animate:** The whole has a purpose, but the parts do not (e.g., a person and their organs)\[86\]\[88\].

• **Social:** Both the parts and the whole have purposes (e.g., a corporation)\[86\].

• **Ecological:** The parts have purposes, but the whole does not (e.g., nature or Earth)\[86\]\[87\].

**Wisdom**The highest level of mental content; it involves the evaluation of outcomes based on long-term values and ethics, distinguishing it from data, information, knowledge, and understanding\[31\].

---
> [!info]- References
> [1] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [2] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [4] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [7] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [10] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [14] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [17] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [21] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [25] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [29] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [31] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [32] [Book] Ackoff et al - 2006 - Idealized design - Wharton School Pub.pdf
> [37] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [40] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [44] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [45] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [49] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [52] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [55] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [61] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [62] [Book] Ackoff - A Guide to Controlling Your Corporations Future.pdf
> [63] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [69] [Book] Ackoff - 1981 - Creating the corporate future - Wiley.pdf
> [72] [Book] Ackoff - 1978 - The art of problem solving - Wiley.pdf
> [86] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [87] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf
> [88] [Book] Ackoff - 1999 - Re-creating the corporation - Oxford University press.pdf


FILE: 'Stafford Beer.md'
---
exported: 2026-02-07T16:17:59.667Z
source: NotebookLM
type: chat
title: Stafford Beer on 💬Keywords and Jargon
tags:
  - Stafford-Beer
  - Keywords
author: Stafford Beer
---
Based on the comprehensive collection of texts provided—ranging from Stafford Beer's early work in _Cybernetics and Management_ to his later developments in _Beyond Dispute_ and _The Heart of Enterprise_—here are the key concepts, principles, and theories extracted in the form of keywords and a detailed glossary.

### Key Concepts and Theories (Keywords)

**Foundational Theories**

• Management Cybernetics

• Ashby’s Law of Requisite Variety

• Information Theory (Entropy/Negentropy)

• General Systems Theory

• Gödel’s Incompleteness Theorem (applied to management)

**The Viable System Model (VSM)**

• Viability

• Recursion (Recursive System Theorem)

• The Five Subsystems (System 1, 2, 3, 4, 5)

• Autonomy

• The Three-Four Homeostat

• Algedonic Loop

**Control and Regulation**

• Homeostasis

• Feedback (Negative/Positive)

• The Black Box

• Variety Engineering (Attenuation/Amplification)

• Transduction

**Organizational Philosophy & Methodology**

• POSIWID (The Purpose Of A System Is What It Does)

• Autopoiesis

• Team Syntegrity (Syntegration)

• Completion From Without

• Eudemony

\--------------------------------------------------------------------------------

### Glossary of Cybernetic Terms and Principles

I. Core Cybernetic Principles

**Cybernetics**Defined by Norbert Wiener as "the science of communication and control in the animal and the machine." Stafford Beer redefined it for his context as "the science of effective organization"\[1\]\[2\]. It treats control not as coercion, but as the regulation of systems to maintain stability and adaptability\[3\].

**Variety**The measure of complexity in a system, defined specifically as the **number of possible states** a system can assume\[4\]\[5\]. Because complex systems (like an economy or a firm) have astronomically high variety, management is fundamentally the process of handling variety\[6\]\[7\].

**Ashby’s Law of Requisite Variety**A fundamental law stating that "only variety can destroy variety." For a regulator (manager) to control a system, the regulator must have a capacity for variety equivalent to the variety of the system being controlled\[8\]. If the regulator has less variety than the system, the system will become unregulated; management must therefore use **attenuators** (to filter incoming variety) and **amplifiers** (to boost their own variety) to balance the equation\[11\].

**Homeostasis**The capacity of a system to hold its critical variables within physiological or acceptable limits in the face of unexpected disturbance\[12\]\[13\]. It is the mechanism by which a system maintains internal stability (equilibrium) through self-regulation\[14\].

**Entropy and Negentropy**Entropy is a measure of a system's tendency to move toward disorder (a more probable state). **Negentropy** (negative entropy) constitutes information or organization that reverses this trend, allowing a system to maintain order and structure\[15\]\[16\].

**The Black Box**A control mechanism or system element that is opaque to the observer. It is defined by its input and output, not by its internal workings. Management cybernetics asserts that one does not need to enter or understand the internal complexity of a black box to manipulate it or measure its variety\[17\].

II. The Viable System Model (VSM)

**Viable System**A system capable of maintaining a separate, independent existence within a specified environment\[20\]\[21\]. The VSM is a neurocybernetic model that maps the necessary and sufficient conditions for any organization (biological or social) to be viable\[22\].

**Recursion**The principle that every viable system contains, and is contained in, a viable system\[23\]\[24\]. Like nesting Russian dolls, the organizational structure repeats at every level (e.g., the shop floor, the factory, the division, the corporation). The laws of viability apply invariantly at every level of recursion\[25\].

**System One (Operations)**The collection of operational elements that produce the system (e.g., manufacturing units). These are viable systems in their own right and must possess **Autonomy** to manage their local environments\[26\]\[27\].

**System Two (Anti-Oscillation)**The function responsible for dampening oscillations between System One units. It coordinates activity (e.g., scheduling, standards) to prevent the autonomous units from destabilizing the whole system through uncoordinated competition for resources\[26\]\[28\].

**System Three (Inside and Now)**The control function responsible for the immediate, day-to-day management of the internal enterprise. It optimizes the interaction of System One units to create synergy (synoptic view)\[26\]\[29\].

_(Star)_\*An audit channel that allows System Three to sporadically penetrate directly into System One operations to verify information and monitor performance, bypassing the standard management filters\[11\]\[30\].

**System Four (Outside and Then)**The development and intelligence function. It scans the external environment for future threats and opportunities (market research, R&D) and captures the "outside and then" to ensure adaptation\[26\]\[31\].

**System Five (Identity/Policy)**The function responsible for logical **Closure** and identity. It formulates policy and arbitrates between the demands of the present (System Three) and the future (System Four) to ensure the system maintains its essential character and balance\[26\]\[32\].

**Algedonic Loop**From the Greek _algos_ (pain) and _hedos_ (pleasure). A communication channel that bypasses standard filters to signal urgent threats (pain) or opportunities (pleasure) directly from operations to the highest level of management (System 5), ensuring rapid response to crisis\[33\]\[34\].

III. Organizational Dynamics and Philosophy

**POSIWID**An acronym for "The Purpose Of A System Is What It Does." A cybernetic dictums stating that a system's purpose is defined by its actual outputs and behavior, not by the stated intentions or rhetoric of its managers\[35\]\[36\].

**Autopoiesis**A concept (borrowed from Maturana and Varela) referring to a system's ability to "produce itself." A viable system continuously regenerates its own organization and maintains its identity through all environmental changes\[37\]\[38\].

**Team Syntegrity**A technique for non-hierarchical problem solving and planning. It utilizes the geometry of an **icosahedron** to organize 30 people into 12 overlapping topic teams. It is designed to generate "logical closure" and integrate diverse perspectives without the loss of variety typical in standard committees\[39\]\[40\].

**Completion From Without**A principle derived from Gödel’s Incompleteness Theorem. It states that no system of language or control can be fully complete or understandable within its own terms; it requires a metalanguage or a higher-order system to resolve its undecidable propositions\[41\]\[42\].

**Eudemony**A measure of well-being or prosperity (more than just happiness or wealth) used to evaluate the success of a social system or enterprise\[43\]\[44\].

**The Three-Four Homeostat**The critical balancing mechanism between System Three (managing the present) and System Four (managing the future). Viability depends on maintaining a dynamic equilibrium between these two often conflicting pulls\[45\].

---
> [!info]- References
> [1] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [2] [Book] Beer,Whittaker - 2009 - Think before you think - Wavestone Press.pdf
> [3] [Book] Beer - 1965 - Cybernetics and Management - The English Universities Press.pdf
> [4] [Book] Beer - 1965 - Cybernetics and Management - The English Universities Press.pdf
> [5] [Book] Davies - The Unaccountability Machine Why Big Systems Make Terrible Decisions - and How The World Lost its Mind.pdf
> [6] [Book] Beer - 1994 - Platform for change - J. Wiley.pdf
> [7] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [8] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [11] Yolles - The Implications of Beers Ontological System Metasystem Dichotomy.pdf
> [12] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [13] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [14] [Book] Beer - 1994 - Platform for change - J. Wiley.pdf
> [15] [Book] Beer,Beer - 1994 - Decision and control - J. Wiley.pdf
> [16] [Book] Beer - 1994 - Platform for change - J. Wiley.pdf
> [17] [Book] Beer - 1965 - Cybernetics and Management - The English Universities Press.pdf
> [20] Adams 2007 - Stafford Beer Contribution to Management Science.pdf
> [21] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [22] Adams 2007 - Stafford Beer Contribution to Management Science.pdf
> [23] Beer - On the Nature of Models - Let us now praise famous men and women too.pdf
> [24] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [25] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [26] Yolles - The Implications of Beers Ontological System Metasystem Dichotomy.pdf
> [27] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [28] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [29] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [30] [Book] Beer - 1985 - Diagnosing the system for organizations - Wiley.pdf
> [31] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [32] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [33] [Book] Beer - 1981 - Brain of the firm - J. Wiley.pdf
> [34] [Book] Davies - The Unaccountability Machine Why Big Systems Make Terrible Decisions - and How The World Lost its Mind.pdf
> [35] 1454555.pdf
> [36] [Book] Davies - The Unaccountability Machine Why Big Systems Make Terrible Decisions - and How The World Lost its Mind.pdf
> [37] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [38] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [39] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [40] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf
> [41] [Book] Beer - 1965 - Cybernetics and Management - The English Universities Press.pdf
> [42] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [43] [Book] Beer - 1994 - Platform for change - J. Wiley.pdf
> [44] [Book] Beer,Beer - 1994 - The heart of enterprise - John Wiley & Sons.pdf
> [45] [Book] Beer - 1994 - Beyond dispute - Wiley.pdf


FILE: 'TOC.md'
---
tags:
  - Keywords
  - TOC
title: TOC on 💬Keywords and Jargon
author: TOC
---
> [!question] #Keywords Can you extract the key concepts, principles and theories in the form of keywords and an attached glossary?

```dataview
LIST
WHERE file.folder = this.file.folder
AND file.name != this.file.name
SORT file.name ASC
```

- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Alicia Juarrero]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Barry Richmond]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Bob Williams]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/C. West Churchman]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Christopher Alexander]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Claude Shannon]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Dave Snowden]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/David L Abel]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Dee Hock]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Donella Meadows]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Fred Emery]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Geoffrey Vickers]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Gregory Bateson]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Herb Simon]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Humberto Maturana]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Hylton Boothroyd]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/J. Gerard Wolff]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Max Boisot]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/MC Jackson]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/MOM]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Nassim Nicholas Taleb]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Neil Postman]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Niklas Luhmann]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Paul Cilliers]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Peter Senge]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Reg Revans]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Relational Biologists]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Robert Flood]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Robert Pirsig]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Roger James]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Russ Ackoff]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Theory of Constraints]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Tim Allen]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/TOG]]
- [[Mastering_The_Muddle/💬QSets/💬Keywords + Jargon/Triz]]

FILE: 'TOG.md'
---
exported: '2026-01-31T23:08:03.208Z'
source: NotebookLM
type: chat
title: TOG on 💬Keywords and Jargon
tags:
  - Keywords
  - TOG
author: TOG
---

Based on the conversations and documents provided, the group is developing a paper and a conceptual framework that challenges rigid, "functionalist" Systems Thinking (ST) methodologies. They advocate for a context-sensitive, risk-based approach grounded in experience and complexity science.

Here are the key concepts, principles, and theories extracted from the sources, followed by a glossary.

### **Key Concepts & Themes**

**1\. The "Italian Flag" Risk Interpretation**This is a central model adopted by the group to interpret evidence and utility. It moves beyond a binary (good/bad) view to a ternary view of evidence regarding an intervention or system state.

• **Green:** What is known to be good, positive, or working; "settled evidence" of value\[1\],\[2\],\[3\].

• **Red:** What is known to be bad, negative, or counter-purposeful; "settled evidence" of failure or harm\[1\],\[2\],\[3\].

• **White:** Uncertainty, the unknown, or "entropy." This represents the gap in knowledge or the "not proven." The goal of analysis is often to navigate from the White/Red zones toward the Green, or to "close the white gap" through insight\[4\],\[5\],\[6\],\[7\].

**2\. Directional Thinking (Right-to-Left vs. Left-to-Right)**A distinction in how problems are approached and solutions designed.

• **Left to Right (L>R):** Evolutionary thinking. Making "stuck things move" or improving existing practices (e.g., evolving the Lancaster bomber to the Lincoln)\[1\],\[5\].

• **Right to Left (R>L):** Conceptual or "idiosyncratic analysis." Starting from a future concept, desired outcome, or constraint and working backward (e.g., designing the Vulcan bomber based on new knowledge/physics). It involves deconstructing the mental scaffolding of a problem\[8\],\[1\],\[9\].

**3\. The "Framework": Purpose, Framing, Scaling, and Conditions**The group proposes this structure as an alternative to rigid methodologies (like VSM or Cynefin). It emphasizes that one must first establish the context before applying tools.

• **Purpose/Outcomes:** Defining the intent or "why"\[8\],\[10\].

• **Framing & Scaling:** Setting the boundaries (scope) and the level of recursion (scale) at which to intervene\[11\],\[12\].

• **Conditions:** Acknowledging the environmental factors and "complexity as a muddle" that enable or constrain action\[12\],\[13\],\[14\].

**4\. Critique of "Functionalist" Methodologies**The group explicitly critiques established ST figures (Jackson, Snowden, Hoverstadt) and methods (VSM, Cynefin, Vanguard) for being:

• **Functionalist:** "Turning the handle" on frameworks without understanding value or context\[13\],\[15\].

• **Performative:** Doing strategy for "pretend" rather than understanding\[16\].

• **Stasis-seeking:** Aiming for a new "Business As Usual" (BAU) or stability, which the group argues is an illusion in complex socio-technical systems\[17\],\[18\].

\--------------------------------------------------------------------------------

### **Principles of Practice**

• **Constitutive Rules:** Unlike regulative rules (which regulate existing behaviors), constitutive rules define the very existence of an activity (e.g., the rules of chess). The group applies this to methodologies: does the application of a tool create actual value, or just compliance?\[19\],\[20\],\[21\].

• **The "Death of Methodology":** The rejection of "silver bullet" methodologies in favor of a principle-driven, evidence-based approach. The belief is that rigorous adherence to a single methodology often distorts reality to fit the model\[22\],\[23\],\[24\].

• **Minimal Intervention (Nudge):** Prioritizing small, high-impact changes ("strategic nudges") rather than "boiling the ocean." This aligns with the concept of "action theory" and minimal change for maximum impact\[9\],\[25\],\[26\].

• **Experiential Knowledge ("Deep Smarts"):** The idea that mastery and effective intervention depend on deep experience and context ("knowing what to ignore"), which cannot be outsourced or replaced by simple process charts\[27\],\[22\],\[28\].

• **Navigating Counterfactuals:** Systems Thinking requires recognizing "what did not happen" as much as explaining what did. It involves navigating a world of counterfactuals to understand risk and opportunity\[29\],\[30\].

\--------------------------------------------------------------------------------

### **Theories & Philosophical Underpinnings**

• **Weaver’s Model of Science:** Used to categorize systems into three types:

    1. **Organized Simplicity:** Few variables (classical mechanics)\[5\].    2. **Disorganized Complexity:** Billions of variables, handled via statistical mechanics (averages)\[5\].    3. **Organized Complexity:** The "middle" region (often the "White" zone of the flag) where variables are interrelated into an organic whole. This is the realm of Systems Thinking\[5\],\[31\].
• **Gödel’s Incompleteness Theorems:** Used as an analogy to argue that within complex socio-technical systems, "truth outruns provability." No single methodology can fully represent or control a complex system; therefore, certainty is a delusion\[32\],\[33\],\[24\].

• **Ergodicity vs. Knowledge Gaps:**

    ◦ _Epistemic Uncertainty (Gödel shortfall):_ Sins of omission; have we considered everything?    ◦ _Aleatory Uncertainty (Ergodic shortfall):_ Sins of commission; does the situation permit every possibility?\[34\],\[35\].
• **Constructivism/Observer Dependence:** Complexity is defined as an "observer phenomenon." A system is not inherently complex; it is the observer who designates it as such based on their framing. Structure and boundaries are dependent on the observer\[36\],\[37\],\[38\].

\--------------------------------------------------------------------------------

### **Glossary of Terms**

**Action Theory**An approach linked to "Strategic Nudges," focusing on minimal changes that yield maximum impact/outcomes, effectively deploying systems thinking to move from insight to execution\[25\].

**Constitutive Rules**Rules that create the possibility of an activity (e.g., "X counts as Y in context C"). In the group's framework, these are used to validate if a methodology is effectively creating value, distinguishing effective application from mere procedural compliance\[21\],\[39\].

**Entropy (in the context of the Italian Flag)**Associated with the "White" zone of the flag. It represents the decay of knowledge or the state of indifference where the observer must do "work" to maintain understanding and position a situation as either desirable (Green) or undesirable (Red)\[6\],\[7\].

**Functionalist (Mindset)**A critique of practitioners who apply tools and frameworks (like VSM) mechanically as "experts" without deep insight into the specific context or the "quality" of the outcome. Contrasted with **Interpretivist** approaches\[13\],\[40\].

**Italian Flag Risk Interpretation**A three-valued logic model used to assess evidence and risk:

• _Green:_ Known Good/Positive evidence.

• _Red:_ Known Bad/Negative evidence (or constraints that prevent sustainability).

• _White:_ Uncertainty/Unknowns (where Systems Thinking is applied to generate understanding)\[5\],\[2\],\[41\].

**Left-to-Right (L>R) Thinking**Evolutionary thinking that improves existing systems incrementally. It is often described as making "stuck things move"\[1\],\[5\].

**Right-to-Left (R>L) Thinking**Conceptual or "idiosyncratic" thinking that starts from a future desire, constraint, or solution concept and works backward to the present. It helps in thinking of fundamentally different solutions (e.g., a different type of wing)\[8\],\[1\].

**Stasis**The state of stability or "Business As Usual." The group identifies the "illusion of stasis" as the "enemy," arguing that complex systems are dynamic and that seeking permanent stability is a flaw in many methodologies\[17\],\[18\].

**Triple Loop Learning**A level of learning that goes beyond changing tactics (single loop) or strategy (double loop) to questioning the underlying context, purpose, and principles. The group's framework aims to promote this\[42\],\[24\].

**White Space**In the group's specific lexicon, this refers to the gap between pertinent poles (e.g., between Red and Green) where intervention and insight are required. It is the space of "organized complexity" or "entropy" that the analyst must navigate\[7\],\[43\].

---
> [!info]- References
> [1] Hull Themes.pdf
> [2] The Other Group.pdf
> [3] The Other Group.pdf
> [4] Hull Themes.pdf
> [5] Hull Themes.pdf
> [6] The Other Group.pdf
> [7] The Other Group.pdf
> [8] Hull Themes.pdf
> [9] Hull Themes.pdf
> [10] The Other Group.pdf
> [11] The Other Group.pdf
> [12] The Other Group.pdf
> [13] The Other Group.pdf
> [14] The Other Group.pdf
> [15] The Other Group.pdf
> [16] Hull Themes.pdf
> [17] The Other Group - Whatsapp.pdf
> [18] The Other Group - Whatsapp.pdf
> [19] The Other Group.pdf
> [20] The Other Group.pdf
> [21] The Other Group.pdf
> [22] Hull Themes.pdf
> [23] The Other Group.pdf
> [24] The Other Group.pdf
> [25] The Other Group.pdf
> [26] The Other Group.pdf
> [27] Hull Themes.pdf
> [28] Hull Themes.pdf
> [29] The Other Group - Whatsapp.pdf
> [30] The Other Group.pdf
> [31] The Other Group.pdf
> [32] The Other Group.pdf
> [33] The Other Group.pdf
> [34] The Other Group.pdf
> [35] The Other Group.pdf
> [36] Hull Themes.pdf
> [37] The Other Group - Whatsapp.pdf
> [38] The Other Group.pdf
> [39] The Other Group.pdf
> [40] The Other Group.pdf
> [41] The Other Group.pdf
> [42] The Other Group.pdf
> [43] The Other Group.pdf


FILE: 'Theory of Constraints.md'
---
exported: '2026-01-31T23:10:05.255Z'
source: NotebookLM
type: chat
title: Theory of Constraints on 💬Keywords and Jargon
tags:
  - Keywords
  - Theory-of-Constraints
author: Theory of Constraints
---

Based on the provided sources, which primarily cover H. William Dettmer’s work on the Theory of Constraints (TOC), the Logical Thinking Process, and Strategic Navigation, here are the key concepts, principles, and theories organized into a keyword list and a detailed glossary.

### **Key Concepts and Keywords**

• **System Management & Theory:** Theory of Constraints (TOC), Systems Approach, Analysis vs. Synthesis, Profound Knowledge, Constraint (Physical vs. Policy), Core Problem vs. Critical Root Cause.

• **Performance Metrics:** Throughput (T), Inventory/Investment (I), Operating Expense (OE), Passive vs. Active Inventory.

• **The Five Focusing Steps:** Identify, Exploit, Subordinate, Elevate, Go Back (Inertia).

• **The Logical Thinking Process (Tools):** Intermediate Objectives (IO) Map, Current Reality Tree (CRT), Evaporating Cloud (EC) / Conflict Resolution Diagram (CRD), Future Reality Tree (FRT), Negative Branch (NB), Prerequisite Tree (PRT), Transition Tree (TT).

• **Logic & Validation:** Categories of Legitimate Reservation (CLR), Sufficiency Logic, Necessity Logic, Causality vs. Correlation.

• **Strategy & Change:** Strategic Navigation, OODA Loop, Blitzkrieg Principles (Schwerpunkt, Einheit), Critical Success Factors (CSF), Injections, Resistance to Change.

\--------------------------------------------------------------------------------

### **Glossary of Key Terms**

**1\. General Systems and Theory of Constraints (TOC)**

• **Theory of Constraints (TOC):** A prescriptive theory and methodology for achieving system optimization rather than process maximization. It views an organization as an integrated whole (a chain) where performance is limited by a constraint. It focuses on identifying and managing this constraint to improve overall performance\[1\].

• **Systems Approach (Synthesis):** A holistic management approach that focuses on the interactions among components to understand how the system functions as a whole. It stands in contrast to analysis, which breaks systems down into isolated parts\[5\].

• **Analysis vs. Synthesis:**_Analysis_ is the process of breaking complex situations down into component parts to understand them in isolation. _Synthesis_ is the process of combining disparate parts into a new whole to understand interactions and create new solutions\[5\].

• **Constraint:** The factor (element or policy) that most limits a system’s ability to achieve its goal. It is analogous to the "weakest link" in a chain. Constraints can be physical (resources, market demand) or policy-based (rules, mindset)\[8\].

• **Five Focusing Steps:** A five-step process for managing system constraints:

    1. **Identify** the system constraint.    2. **Decide** how to exploit the constraint.    3. **Subordinate** everything else to the above decision.    4. **Elevate** the constraint.    5. **Go back** to step 1 (avoiding inertia)\[12\].
• **Profound Knowledge:** A concept from W. Edwards Deming, essential for quality improvement, comprising four components: appreciation for a system, knowledge of variation, theory of knowledge, and understanding of psychology\[15\]\[16\].

**2\. Performance Metrics (Throughput Accounting)**

• **Throughput (T):** The rate at which the entire system generates money through sales. It is not equivalent to production output; it requires a sale\[17\]\[18\].

• **Inventory / Investment (I):** All the money the system invests in things it intends to sell (raw materials, etc.) and items traditionally considered assets (facilities, equipment). Goldratt later expanded this definition to include "Investment"\[19\].

    ◦ _Passive Inventory:_ Materials acted upon (e.g., raw materials).    ◦ _Active Inventory:_ Assets that act upon the passive inventory (e.g., machines)\[22\].
• **Operating Expense (OE):** All the money the system spends turning Inventory into Throughput (e.g., labor, utilities, depreciation). It is the money going out of the system\[19\]\[23\].

**3\. The Logical Thinking Process (Tools)**

• **Logical Thinking Process:** A set of logic trees and rules designed to answer three management questions: _What to change? What to change to?_ and _How to cause the change?_\[24\].

• **Intermediate Objectives (IO) Map:** A hierarchy of necessary conditions required to achieve a system's goal. It identifies the Goal, Critical Success Factors (CSF), and Necessary Conditions (NC). It serves as the standard for desired performance\[27\].

• **Current Reality Tree (CRT):** A logical structure depicting the state of reality as it currently exists. It traces a chain of cause and effect from visible symptoms (Undesirable Effects) back to root causes\[24\].

    ◦ _Undesirable Effect (UDE):_ A visible indication (symptom) that the system is not performing as it should, usually resulting from a deeper root cause\[24\].    ◦ _Critical Root Cause (CRC):_ The lowest level of cause in a CRT over which a decision-maker has influence; the few causes that produce the majority of UDEs. (Supersedes the older term "Core Problem")\[35\].
• **Evaporating Cloud (EC) / Conflict Resolution Diagram (CRD):** A tool used to resolve hidden conflicts or dilemmas that perpetuate chronic problems. It exposes invalid assumptions underlying a conflict to create "win-win" solutions\[39\].

• **Future Reality Tree (FRT):** A logic tree used to test the efficacy of a proposed solution. It validates that specific actions will produce desired effects and helps identify/prevent potential negative side effects\[43\].

    ◦ _Injection:_ A new condition or action initiated to change reality, neutralize a conflict, or solve a problem\[40\].    ◦ _Negative Branch:_ An anticipated unfavorable side effect of an injection, which can be trimmed (prevented) by adding further injections\[48\].
• **Prerequisite Tree (PRT):** A tool used to identify obstacles preventing the implementation of a solution and the intermediate objectives (IOs) necessary to overcome them. It sequences these IOs\[51\].

• **Transition Tree (TT):** A step-by-step implementation plan that details the specific actions required to move from the current state to a desired future state, providing the rationale for each step\[54\].

**4\. Logic Rules (Categories of Legitimate Reservation)**

• **Categories of Legitimate Reservation (CLR):** A set of eight rules of logic used to verify the validity of connections in logic trees and to communicate disagreement without confrontation\[26\].

    1. **Clarity:** Is the statement unambiguous and understood?\[60\]\[61\]    2. **Entity Existence:** Is the statement a complete sentence and does it exist in reality?\[60\]\[62\]    3. **Causality Existence:** Does the cause actually lead to the effect?\[60\]\[63\]    4. **Cause Insufficiency:** Is the cause sufficient on its own, or are dependent causes missing (requiring an ellipse)?\[60\]\[64\]    5. **Additional Cause:** Is there a separate, independent cause that could produce the same effect?\[60\]\[65\]    6. **Cause-Effect Reversal:** Is the arrow pointing in the correct direction (cause to effect)?\[60\]\[66\]    7. **Predicted Effect Existence:** If the cause is true, what other intangible effects should be observable?\[67\]\[68\]    8. **Tautology:** Is circular logic being used (the effect is offered as proof of the cause)?\[67\]\[69\]

**5\. Strategy and Military Concepts**

• **OODA Loop:** A strategic cycle developed by John Boyd consisting of _Observe, Orient, Decide, and Act_. It emphasizes the importance of "orientation" (worldview) and speed in decision cycles\[70\].

• **Blitzkrieg Principles:**

    ◦ _Schwerpunkt:_ Center of gravity or focus point; the main thrust of effort (analogous to the system constraint)\[73\]\[74\].    ◦ _Einheit:_ Mutual trust and cohesion within a team\[75\]\[76\].    ◦ _Auftragstaktik:_ Moral contract; giving subordinates the freedom to act within the commander's intent\[75\]\[77\].    ◦ _Fingerspitzengefühl:_ "Fingertip feel" or intuitive skill/competence\[75\]\[76\].
• **METT-TC:** A military acronym used for gathering strategic information: Mission, Enemy, Terrain and weather, Troops and support available, Time available, and Civil considerations\[78\]\[79\].

• **Strategic Navigation:** The concept of steering an organization toward a destination (goal) using a synthesis of TOC, systems thinking, and military strategy principles\[80\]\[81\].

---
> [!info]- References
> [1] Constraint Theory - Dettmer.pdf
> [5] Part-1-IntrotoSystemsApproach.pdf
> [8] Part-6-SystemsandConstraints.pdf
> [12] Part-6-SystemsandConstraints.pdf
> [15] Part-1-IntrotoSystemsApproach.pdf
> [16] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [17] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [18] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [19] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [22] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [23] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [24] Constraint Theory - Dettmer.pdf
> [26] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [27] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [35] Part-8-PolicyAnalysis-TheTP.pdf
> [39] Constraint Theory - Dettmer.pdf
> [40] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [43] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [48] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [51] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [54] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [60] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [61] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [62] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [63] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [64] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [65] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [66] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [67] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [68] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [69] [Book] Dettmer - 1997 - Goldratt's theory of constraints - ASQC Quality Press.pdf
> [70] Part-5-TheLearningOrganization.pdf
> [73] Part-2-BusinessandtheBlitzkrieg.pdf
> [74] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [75] Part-2-BusinessandtheBlitzkrieg.pdf
> [76] [Book] Dettmer - The logical thinking process  a systems approach to complex problem solving.pdf
> [77] Part-5-TheLearningOrganization.pdf
> [78] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [79] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [80] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf
> [81] [Book] Dettmer - Strategic Navigation A Systems Approach to Business Strategy.pdf


FILE: 'Tim Allen.md'
---
exported: '2026-01-31T23:08:55.828Z'
source: NotebookLM
type: chat
title: Tim Allen on 💬Keywords and Jargon
tags:
  - Keywords
author: Tim Allen
---

Based on the provided sources, which focus heavily on the work of T.F.H. Allen, Joseph Tainter, Thomas Hoekstra, and colleagues, here are the key concepts, principles, and theories organized into keywords and a detailed glossary.

### **Keywords**

**General Systems & Hierarchy Theory**

• Hierarchy Theory

• Holon (and Holarchy)

• Levels of Observation vs. Levels of Organization

• Scale (Grain and Extent)

• Constraint and Context

• Rate-Dependence vs. Rate-Independence

• Near-Decomposability

• The Observer (Epistemology)

**Complexity & Thermodynamics**

• Complexity vs. Complicatedness

• Emergence

• Thermodynamic Gradient

• Dissipative Structures

• Middle-Number Systems

• Rosen’s Modeling Relation

**Ecological Economics & Societal Evolution**

• High Gain vs. Low Gain

• Energy Return on Investment (EROI)

• Diminishing Returns on Complexity

• Energy-Complexity Spiral

• Problem Solving (as a driver of complexity)

• Supply-Side Sustainability

\--------------------------------------------------------------------------------

### **Glossary of Key Concepts**

**I. Hierarchy and Systems Theory**

**Hierarchy Theory**A theory of observation used to analyze complex systems. It focuses on the role of the observer in defining the system and asserts that complexity is organized into levels where higher levels provide context and constraint to lower levels\[1\]. It posits that nature is organized in levels because hierarchical structures (like "Chinese boxes") are the most viable form for systems of moderate complexity to evolve\[1\].

**Holon**A term coined by Arthur Koestler to describe an entity that is simultaneously a whole and a part. It is "Janus-faced," looking inward to its own parts (controlling them) and outward to the larger system (being controlled/constrained by it)\[2\]. In ecology, a holon acts as an interface or skin between a set of components and the environment\[2\].

**Levels of Observation vs. Levels of Organization**A critical distinction in hierarchy theory:

• **Levels of Observation:** These are scale-dependent (based on size/time). They are determined by the measurement protocol (grain and extent). For example, a larger organism is at a higher level of observation than a smaller one\[5\]\[6\].

• **Levels of Organization:** These are definitional (type-based) and not necessarily scalar. For example, "population" is a level of organization defined by the equivalence of organisms, not necessarily by size (e.g., a population of mites is smaller than a single elephant)\[7\]\[8\].

**Constraint**The mechanism by which higher levels control lower levels. Upper levels behave at lower frequencies (slower) and have less integrity/bond strength than lower levels; this slowness allows them to act as boundary conditions or contexts that limit the degrees of freedom of the faster-moving parts below\[9\].

**Near-Decomposability**A property of hierarchical systems where the interactions _within_ components (subsystems) are much stronger and faster than interactions _between_ components. This allows the system to be analyzed by separating it into parts (decomposition) with only a small loss of accuracy, facilitating the description of complexity\[12\].

**Rate-Dependence vs. Rate-Independence**A distinction derived from Pattee:

• **Rate-dependent:** Refers to dynamic physical laws and fluxes (thermodynamics) where speed and rate matter (e.g., a ball falling)\[15\]\[16\].

• **Rate-independent:** Refers to non-dynamic constraints, rules, or codes (e.g., DNA, language, books) that do not exist at a rate but determine the structure or direction of the system\[15\].

\--------------------------------------------------------------------------------

**II. Complexity and Epistemology**

**Complexity vs. Complicatedness**

• **Complexity:** Often defined via Rosen as a system that cannot be fully simulated by a formal model (it has a non-simulable model). It involves deep hierarchical organization, emergence, and semantic/linguistic elements (meaning)\[19\].

• **Complicatedness:** Refers to structural elaboration, such as increasing the number of parts or connections (horizontal differentiation) without necessarily adding new levels of organization. It increases the "span" of a hierarchy rather than its depth\[9\]\[19\].

**Emergence**The appearance of new structures or properties at a higher level of organization that cannot be predicted solely from the properties of lower-level parts. It often occurs when a system under positive feedback hits a constraint, forcing a reorganization or the appearance of a new level\[17\].

**Middle-Number Systems**Systems that are too complex to be described by the behavior of individual parts (like planetary mechanics) but have too few parts to be described by statistical averages (like gas laws). Ecology often deals with these intractable middle-number systems\[24\]\[25\].

**Narrative**A tool for dealing with complexity when formal models fail. While models remove uncertainty by fixing specifications, narratives allow for the tension between focal and tacit levels of analysis, accommodating the changing nature of complex systems over time\[26\].

\--------------------------------------------------------------------------------

**III. Energy, Resources, and Societal Evolution**

**High Gain vs. Low Gain**A duality describing resource use strategies:

• **High Gain:** Systems that use high-quality, ready-made resources (steep energy gradients). They are predicted by flux/rate (thermodynamics). They are inefficient, profligate, and often ephemeral (e.g., an engine burning gasoline, a boom-town)\[29\].

• **Low Gain:** Systems that use low-quality resources which require processing/refining before use (shallow energy gradients). They are predicted by efficiency and coded plans (organization). They are often structurally complex and persistent (e.g., extracting oil from tar sands, subsistence agriculture)\[29\].

**Energy Return on Investment (EROI)**The ratio of the amount of energy acquired from a resource to the amount of energy expended to obtain that resource. High-gain systems have high EROI; low-gain systems have low EROI. As high-quality resources are depleted, societies must move to lower EROI resources, necessitating increased organizational complexity\[34\].

**The Energy-Complexity Spiral**The concept that energy and complexity are inextricably linked: inexpensive energy stimulates the growth of complexity, while maintaining higher complexity requires ever-increasing amounts of energy. This creates a feedback loop where solving problems leads to more complexity, which demands more energy\[37\]\[38\].

**Diminishing Returns on Complexity**Joseph Tainter's theory that societies increase complexity to solve problems. Initially, this investment yields high returns. However, over time, the cost of maintaining this complexity increases, leading to diminishing marginal returns. Eventually, the cost becomes unsustainable, making the society vulnerable to collapse\[39\].

**Supply-Side Sustainability**A management philosophy arguing that one should manage for the _context_ (the health of the productive system/ecosystem) rather than for the specific resource (the output). If the context is maintained, the system will provide the resource as a subsidy. It opposes managing for specific yields (demand-side) which often degrades the system\[42\].

**Collapse**Defined as a rapid simplification of a society—the loss of an established level of social, political, or economic complexity. It typically occurs when the energetic costs of maintaining complexity exceed the benefits, often due to diminishing returns on problem-solving\[45\]\[46\].

---
> [!info]- References
> [1] Wu 2013 - Hierarchy theory-An overview.pdf
> [2] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [5] Allen The Landscape Levels id Dead.pdf
> [6] Wu 2013 - Hierarchy theory-An overview.pdf
> [7] Allen - A Last Hurrah for Modernist Realism in Ecology.pdf
> [8] [Book] Allen - Toward a Unified Ecology.pdf
> [9] Allen 1999 - Supply side sustainability.pdf
> [12] Wu 2013 - Hierarchy theory-An overview.pdf
> [15] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [16] Allen 2015 - The Observer in Complex Systems  the Gateway Papers.pdf
> [17] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [19] Allen 1999 - Supply side sustainability.pdf
> [24] [Book] Allen - Hierarchy perspectives for ecological complexity.pdf
> [25] [Book] Allen - Hierarchy perspectives for ecological complexity.pdf
> [26] Allen - Narratives and transdisciplines for a post-industrial world.pdf
> [29] Allen - Confronting Economic Profit with Hierarchy Theory the concept of gain in ecology.pdf
> [34] Allen - Resource Transitions and Energy Gain Contexts of Organisation.pdf
> [37] Tainter 2011 Energy complexity and sustainability.pdf
> [38] Tainter Allen 2015 Energy gain and the evolution of organization.pdf
> [39] Tainter 2006 Social Complexity and Sustainability.pdf
> [42] Allen 1999 - Supply side sustainability.pdf
> [45] Tainter 2006 Social Complexity and Sustainability.pdf
> [46] Tainter 2013 Complexity problem-solving sustainability and resilience.pdf


FILE: 'Triz.md'
---
exported: '2026-01-31T23:10:29.753Z'
source: NotebookLM
type: chat
title: Triz on 💬Keywords and Jargon
tags:
  - Keywords
author: Triz
---

Based on the provided sources, which focus heavily on the Theory of Inventive Problem Solving (Triz), Bartini’s LT-system of kinematic quantities, and the synthesis of these two into "Inventology" and "Technology for Innovation," here are the extracted key concepts, principles, and theories, followed by a detailed glossary.

### **Part 1: Key Concepts and Theories**

**1\. The Theory of Inventive Problem Solving (Triz)**Triz is presented not merely as a brainstorming method but as an exact science of system evolution. The core theory posits that technical systems evolve according to objective laws, and innovation requires resolving contradictions rather than compromising\[1\]\[2\].

• **Keywords:**_Ideality, Technical Contradiction, Physical Contradiction, Su-Field Analysis, ARIZ, Evolution of Systems, Resources._

**2\. Bartini’s LT-System (Kinematic System of Physical Quantities)**This theory, developed by R.O. di Bartini, proposes that all physical quantities can be expressed using only two base dimensions: Length (L) and Time (T). This system is used to predict new physical laws and classify physical effects based on their dimensional invariance\[3\]\[4\].

• **Keywords:**_LT-Table, Invariant, Dimensionality, Transfer Matrix, Entity._

**3\. Integration of Triz and LT-System (Inventology)**This concept represents a synthesis where Triz tools (like the contradiction matrix) are mapped onto Bartini’s physical laws. This allows for a mathematical-physical modeling of inventive problems, moving from subjective brainstorming to objective calculation of the "X-element" (resource) needed to solve a problem\[5\]\[6\].

• **Keywords:**_LT-Contradiction Matrix, Innovative Synergism, Mathematical-Physical Model, X-Element._

**4\. New Laws of Conservation (Physical Economy)**Based on gaps identified in the Bartini LT-table, several new conservation laws have been proposed to aid in strategic management, logistics, and economics. These expand traditional physics into the realm of "physical economy"\[7\]\[8\].

• **Keywords:**_Extencia, Expancia, Volupower, Linergy, Arergy, Volergy, Mobility, Operability._

**5\. System Development Methodologies**These are structured processes used alongside Triz to analyze systems, identify root causes, and simplify designs.

• **Keywords:**_Value Methodology, Trimming, Root-Cause Analysis (RCA), Function Analysis._

\--------------------------------------------------------------------------------

### **Part 2: Glossary of Key Terms**

**AcceFlow**A newly proposed conservation law representing the acceleration of flow. Its mathematical formula is Afl\=Flow/time\=mass/time2. It fills a specific cell in the Bartini Table\[9\].

**Algorithm for Inventive Problem Solving (ARIZ)**A set of sequential, logical procedures for analyzing a problem situation to create effective solutions using Triz concepts. It is considered an algorithm for the human brain (not computers) designed to overcome psychological inertia\[10\]\[11\].

**Arergy (Arergation)**A concept representing the area distribution of energy (Area + Ergon). Its measurement unit is the Sergal. It is part of the "new toponymy" of entities derived from Bartini’s table\[12\]\[13\].

**Bartini’s LT-Table**A kinematic system of physical quantities where all values are expressed as powers of Length (L) and Time (T). The vertical columns contain degrees of length, and horizontal rows contain degrees of time. Intersection points represent dimensions of physical quantities (e.g., Energy is L5T−4)\[4\]\[14\].

**Contradiction (System/Technical)**A situation where improving one parameter of a system causes the deterioration of another parameter. Triz seeks to resolve this without compromise using Inventive Principles\[15\].

**Contradiction (Physical)**A conflict within a single element of a system where the element must possess mutually exclusive physical properties (e.g., be hot and cold, or mobile and stationary) to satisfy different requirements. Resolving this often leads to an Ideal Final Result\[18\]\[19\].

**Expancia**A proposed law of conservation dealing with the expansion of power, or the "area spread of power." It is developed based on the law of Extencia\[20\].

**Extencia**A proposed law of conservation dealing with the "linear displacement of power." It is defined as the velocity of moving energy or work (Ext\=Power×Distance). Its measurement range in the LT system is L6T−5\[21\]\[22\].

**Function Analysis**A discipline within Value Methodology that separates the intent or purpose of a product from its design description. It uses a verb-noun structure (e.g., "transmit torque") to define what a system does\[23\].

**Ideal Final Result (IFR/Ideality)**The evolutionary direction of all systems. A system is considered ideal if it performs its required functions without existing as a physical entity (mass, volume, energy cost). Ideality is calculated as the sum of useful functions divided by the sum of costs and harmful effects\[24\]\[25\].

**Invariant**A common property or feature possessed by different effects or objects within a classification system. In the context of Bartini’s LT-basis, it is determined by the transfer matrix of proportionality between input and output\[26\]\[27\].

**Inventive Principles**A set of 40 abstract rules (e.g., Segmentation, Asymmetry, Spheroidality) identified by Genrich Altshuller to resolve System Contradictions\[28\]\[29\].

**Linergy**A term proposed to replace "Transfer" in the LT-system, derived from "linear + ergon," representing the transmission of energy over a distance\[13\].

**LT-Contradiction Matrix**A tool that integrates the Triz contradiction matrix with Bartini’s LT-table. It allows for the tensorial calculation of contradictions and helps identify the physical characteristics of the resource (X-element) needed to solve a problem\[6\]\[30\].

**Mobility**A conservation law discovered by Bartini, defined as the rate of Extencia or the speed at which power is transported in linear displacement. Its dimension is L6T−6\[31\].

**Physical Economy**A branch of economy that utilizes scientific laws (specifically conservation laws from the LT-system) to manage human and material resources, transportation, and strategic development\[7\]\[32\].

**Root-Cause Analysis (RCA)**A systematic method used to identify the fundamental cause of a fault or problem. It involves tracing cause-and-effect relationships back from an undesirable event\[33\]\[34\].

**Separation Principles**Generic approaches used to resolve Physical Contradictions by separating conflicting requirements in time, space, or condition (e.g., an object is hard in one condition and soft in another)\[35\].

**Substance-Field (Su-Field) Analysis**A modeling technique in Triz where problems are represented as a model of two substances (S1​ and S2​) interacting through a Field (F). Solutions involves transforming this model (e.g., adding a third substance or changing the field)\[36\]\[37\].

**System of Standard Solutions**A set of 76 standard rules organized into five classes, used to transform Substance-Field models of problems into models of solutions. These allow for the transfer of effective solutions across different branches of technology\[38\]\[39\].

**Trimming**A method for improving systems by eliminating low-value or problematic components and redistributing their useful functions to the remaining components or the super-system\[40\]\[41\].

**Volupower**A proposed law of conservation dealing with the "three-dimensional volumetric spread of power." It is defined mathematically as Expancia×Length (L8T−5)\[42\]\[43\].

**X-Element**An unknown resource (substance, field, or energy) that must be found or introduced into a system to resolve a contradiction and achieve the Ideal Final Result. In mathematical modeling of invention, it is often the variable solved for in differential equations\[44\].

---
> [!info]- References
> [1] [Book] Bukhman - Technology for Innovation.pdf
> [2] Salamatov Book Triz The Right Solution at the Right Time - Chapter 2.pdf
> [3] Formation of a Function Series for Estimates of Transportation Energy based on Bartini.pdf
> [4] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [5] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [6] Rajic - Mathematical - Physical Model of Solving Inventive Problems.pdf
> [7] The conservation of extencia - a new law of conservation.pdf
> [8] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [9] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [10] [Book] Bukhman - Technology for Innovation.pdf
> [11] [Book] Bukhman - Technology for Innovation.pdf
> [12] Formation of a Function Series for Estimates of Transportation Energy based on Bartini.pdf
> [13] Formation of a Function Series for Estimates of Transportation Energy based on Bartini.pdf
> [14] The conservation of extencia - a new law of conservation.pdf
> [15] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [18] Innovative synergism as a result of Triz and LT - system synthesis.pdf
> [19] [Book] Bukhman - Technology for Innovation.pdf
> [20] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [21] The conservation of extencia - a new law of conservation.pdf
> [22] The conservation of extencia - a new law of conservation.pdf
> [23] [Book] Bukhman - Technology for Innovation.pdf
> [24] [Book] Bukhman - Technology for Innovation.pdf
> [25] [Book] Bukhman - Technology for Innovation.pdf
> [26] Bushuev - Trends of Physical Effects.pdf
> [27] Bushuev - Trends of Physical Effects.pdf
> [28] [Book] Bukhman - Technology for Innovation.pdf
> [29] [Book] Bukhman - Technology for Innovation.pdf
> [30] Rajic - LT Contradiction Matrix.pdf
> [31] The conservation of extencia - a new law of conservation.pdf
> [32] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [33] [Book] Bukhman - Technology for Innovation.pdf
> [34] [Book] Bukhman - Technology for Innovation.pdf
> [35] [Book] Bukhman - Technology for Innovation.pdf
> [36] [Book] Bukhman - Technology for Innovation.pdf
> [37] [Book] Bukhman - Technology for Innovation.pdf
> [38] [Book] Bukhman - Technology for Innovation.pdf
> [39] [Book] Bukhman - Technology for Innovation.pdf
> [40] [Book] Bukhman - Technology for Innovation.pdf
> [41] [Book] Bukhman - Technology for Innovation.pdf
> [42] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [43] Viva Di Bartini Eleven New Laws of Conservation Expanding Physics for Global Strategic Management and Strategic Development.pdf
> [44] Innovative synergism as a result of Triz and LT - system synthesis.pdf


FILE: 'Warren Weaver.md'
---
exported: 2026-02-07T17:25:20.075Z
source: NotebookLM
type: chat
title: Warren Weaver on 💬Keywords and Jargon
tags:
  - Keywords
  - Warren-Weaver
author: Warren Weaver
---
Based on the provided sources, here are the key concepts, principles, and theories organized into keywords and a comprehensive glossary.

### Keywords

**General Systems Thinking**

• The Systems Triumvirate

• The Square Law of Computation

• The Law of Medium Numbers

• The Principle of Indifference

• The Observer (and the Eye-Brain Law)

• The Generalized Thermodynamic Law

• The Principle of Invariance

• The Strong Connection Law

• The Used Car Law

**Complexity Science**

• Organized vs. Disorganized Complexity

• Complex vs. Complicated Systems

• Self-Organisation

• Emergence (Weak vs. Novel)

• Scope, Resolution, and State

• Complex Adaptive Systems (CAS)

• The Edge of Chaos

• Statistical Complexity

**Systemic Design**

• Framing (Environmental and Problem)

• The Four Big Ideas (Learning, Difference, Systems, Social Creation)

• Mindset, Methodology, and Methods

• Operational Design

• Narrative and Discourse

• Reframing

**Information Theory & Semiotics**

• Entropy (and Excess Entropy)

• Predictive Information

• Markov Blankets

• Free Energy Principle (FEP)

• Transcendental Signified

\--------------------------------------------------------------------------------

### Glossary of Key Concepts, Principles, and Theories

I. General Systems Thinking (Weinberg & Weaver)

• **Generalized Thermodynamic Law:** A principle stating that "more probable states are more likely to be observed than less probable states, unless specific constraints exist to keep them from occurring"\[1\]\[2\]. It implies that things we see frequently are frequent either due to physical reasons (First Law) or mental reasons/observer bias (Second Law)\[3\].

• **Law of Medium Numbers:** A concept describing the region of "organized complexity"\[4\]. It sits between "organized simplicity" (small numbers, mechanistic, handled by analytics) and "unorganized complexity" (large numbers, random, handled by statistics). Medium number systems are too complex for analysis and too organized for statistics\[5\].

• **Organized Complexity:** Problems involving a sizable number of factors which are interrelated into an organic whole (e.g., biology, economics). These systems cannot be handled effectively by statistical mechanics (which handle disorganized complexity) or Newtonian mechanics (which handle simplicity)\[6\]\[7\].

• **Principle of Indifference:** The principle stating that "laws should not depend on a particular choice of notation"\[8\]\[9\]. It warns against confusing the label or symbol with the thing itself (e.g., calling a tail a leg does not make it a leg).

• **Principle of Invariance:** The heuristic that we understand the meaning of a property or factor by investigating transformations—those that preserve the property and those that destroy it\[10\]\[11\].

• **Square Law of Computation:** An estimation that unless simplifications can be made, the amount of computation involved in solving a system of equations increases at least as fast as the square of the number of equations. This places limits on the power of computing devices, including the human brain, to understand complex systems\[12\]\[13\].

• **Strong Connection Law:** A principle stating that "systems, on the average, are more tightly connected than the average"\[14\]. It suggests that in systems, "all other things are rarely equal," countering the reductionist assumption of _ceteris paribus_\[15\].

• **Systems Triumvirate:** The three fundamental questions that govern general systems thinking: 1. Why do I see what I see? 2. Why do things stay the same? (Stability) 3. Why do things change?\[16\]\[17\].

• **Used Car Law:** A law regarding system adaptation and regulation: 1. A system that is doing a good job of regulation need not adapt. 2. A system may adapt in order to simplify its job of regulating. This highlights the trade-off between maintaining identity (regulation) and changing structure (adaptation)\[18\]\[19\].

II. Complexity Science & Emergence (Ryan, Prokopenko, et al.)

• **Adaptation:** A process where a system changes its behavior to increase the mutual information between itself and a complex, non-stationary environment\[20\]. It involves a cycle of variation, interaction, feedback, selection, and retention\[21\].

• **Complex vs. Complicated:**_Complicated_ systems (like engines) can be decomposed and analyzed; the whole is the sum of the parts. _Complex_ systems (like insurgencies) have interdependent parts where interactions generate novel behavior; they cannot be reduced without losing essential dynamics\[22\]\[23\].

• **Emergence (Scope not Level):** A redefinition of emergence proposing that emergent properties are determined by the relationship between the **scope** (spatial boundary), **resolution** (detail), and **state** of a system, rather than by hierarchical "levels"\[24\].

    ◦ _Weak Emergence:_ Properties present in a macrostate but not apparent in the microstate due only to a difference in resolution (epistemic/observer limitation)\[25\]\[26\].    ◦ _Novel Emergence:_ Properties present in a macrostate but not present in _any_ microstate that differs only in scope (ontological)\[27\].
• **Predictive Information:** The amount of information observed in the past that can be used to predict the future. In self-organizing systems, this corresponds to the "excess entropy" or the richness of the structure\[28\]\[29\].

• **Self-Organization:** The process by which a system increases its internal organization (order) without a central director or explicit external instruction\[30\]\[31\]. Information-theoretically, this occurs when the internal complexity of the system increases more than the complexity of the external influence\[32\]\[33\].

• **Statistical Complexity:** A measure of the amount of information needed to predict the future of a system, distinct from random complexity (entropy) or perfect order. It captures the structure of the underlying process\[34\]\[35\].

III. Systemic Design (Ryan, SAMS)

• **Design:** A methodology for applying critical and creative thinking to understand, visualize, and describe complex, ill-structured problems and develop approaches to solve them\[36\]. It is an iterative process of learning and adapting\[37\].

• **Four Big Ideas:** The core concepts permeating systemic design\[38\]:

    1. **Learning:** Design is a learning system; the team must learn how to learn\[39\]\[40\].    2. **Difference:** Innovation requires diversity; seeing the "difference which makes a difference"\[41\].    3. **Systems:** Viewing problems as open, purposeful, complex wholes with interdependent parts\[42\].    4. **Social Creation:** Design is a collaborative act; knowledge is socially constructed through discourse\[43\].
• **Framing:** The act of selecting, organizing, interpreting, and making sense of a complex reality to define the "problem" and the "environment"\[39\]\[44\]. It involves creating a narrative and graphic representation of the current state.

• **Problem Situation:** A situation in which the designation of objectives is itself problematic; a problem that cannot be explicitly stated without oversimplifying. Often referred to as a "wicked problem" or "mess"\[45\].

• **Systemic Design Mindset:** A set of values and habits characterized as Inquiring, Open, Integrative, Collaborative, and Centered. It encourages a "fast and loose" application of methods to facilitate learning\[46\]\[47\].

IV. Information Theory, Semiotics & Social Theory (Shannon, Rahman, et al.)

• **Entropy:** In information theory, a measure of the uncertainty or freedom of choice in selecting a message. Higher entropy implies greater uncertainty and potential information\[48\]\[49\].

• **Free Energy Principle (FEP):** A theory stating that all self-organizing systems (from particles to people) strive to minimize "variational free energy" (surprise) to maintain their structural integrity (Markov blanket) against the natural tendency toward disorder\[50\]\[51\].

• **Markov Blanket:** A statistical boundary that separates the internal states of a system from its external environment. It defines the scope of the "self" or agent\[52\]\[53\].

• **Myth of Objectivity:** The argument that social reality and symbolic capacity are anchored in a shared belief in objective norms (or "transcendental signifieds") which, though technically mythical/constructed, allow disparate agents to cohere into a group identity\[54\]\[55\].

• **Transcendental Signified:** A concept from Derrida referring to a central concept (e.g., God, Democracy) that anchors a system of meaning, stopping the endless chain of signifiers and providing a fixed point for truth/meaning within a culture\[56\].

---
> [!info]- References
> [1] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [2] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [3] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [4] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [5] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [6] Seising - Weaver science and complexity revisited.pdf
> [7] Seising - Weaver science and complexity revisited.pdf
> [8] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [9] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [10] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [11] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [12] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [13] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [14] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [15] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [16] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [17] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [18] An Introduction to General Systems Thinking ( PDFDrive ).pdf
> [19] Weinberg - 1975 - An introduction to general systems thinking - Wiley(Book).pdf
> [20] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [21] Ryan - Science of Adaptation The foundation for an adaptive approach.pdf
> [22] [Book] Ryan - Art of Design Student Text.pdf
> [23] [Book] Ryan - Art of Design Student Text.pdf
> [24] Emergence is coupled to scope not level - Ryan.pdf
> [25] Emergence is coupled to scope not level - Ryan.pdf
> [26] Emergence is coupled to scope not level - Ryan.pdf
> [27] Emergence is coupled to scope not level - Ryan.pdf
> [28] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [29] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [30] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [31] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [32] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [33] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [34] An Information Theoretic Primer on Complexity Self-organisation and Emergence.pdf
> [35] Ryan an information theoretic primer on complexity self organization and emergence.pdf
> [36] [Book] Ryan - Art of Design Student Text.pdf
> [37] [Book] Ryan - Art of Design Student Text.pdf
> [38] [Book] Ryan - Art of Design Student Text.pdf
> [39] A Theory of Systemic Design - Ryan.pdf
> [40] [Book] Ryan - Art of Design Student Text.pdf
> [41] [Book] Ryan - Art of Design Student Text.pdf
> [42] [Book] Ryan - Art of Design Student Text.pdf
> [43] [Book] Ryan - Art of Design Student Text.pdf
> [44] [Book] Ryan - Art of Design Student Text.pdf
> [45] [Book] Ryan - Art of Design Student Text.pdf
> [46] A Theory of Systemic Design - Ryan.pdf
> [47] Ryan - A Framework for Systemic Design.pdf
> [48] Seising 2010 - Cybernetics systems theory information theory and fuzzy sets.pdf
> [49] [Book] Shannon - Mathematical Theory of Communication.pdf
> [50] Rahman - Myth of objectivity and the origin of symbols.pdf
> [51] Rahman - Myth of objectivity and the origin of symbols.pdf
> [52] Rahman - Myth of objectivity and the origin of symbols.pdf
> [53] Rahman - Myth of objectivity and the origin of symbols.pdf
> [54] Rahman - Myth of objectivity and the origin of symbols.pdf
> [55] Rahman - Myth of objectivity and the origin of symbols.pdf
> [56] Rahman - Myth of objectivity and the origin of symbols.pdf


FILE: 'index.md'
---
aliases:
  - Summary
  - Keywords
tags:
  - Keywords
  - Summary
title: 💬Keywords and Jargon
author: index
linter-yaml-title-alias: Summary
---
This prompt is to deliver the different definitions together with a glossary for references of how often common terms and definitions are used differently. It was less successful in producing a set of clear principles.

> [!question] Prompt
> Can you extract the key concepts, principles and theories in the form of keywords and an attached glossary

# Summary

These sources provide a comprehensive **multidisciplinary glossary** of systemic thought, spanning **cybernetics, cognitive science, and management theory**. They detail the intellectual contributions of influential theorists who redefined how we understand **complex adaptive systems** and **human-centred design**. Key themes include the shift from **mechanistic metaphors** to **biological and organic models**, emphasizing the role of the **observer** in constructing reality. The texts explore practical methodologies for addressing **wicked problems** through **iterative learning**, **metaphorical framing**, and **recursive logic**. Ultimately, the collection serves as a foundational guide to the **principles of complexity**, offering tools to navigate the interplay between **information, meaning, and purposeful action**.


